/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import org.w3c.dom.Node;

public class PermissionDescriptor
implements XMLizable {
    private String type;
    private String name;
    private String action;

    public PermissionDescriptor(Node node) throws InstantiationException {
        this.type = XMLUtils.getNodeAttribute(node, "type");
        this.name = XMLUtils.getNodeAttribute(node, "name");
        this.action = XMLUtils.getNodeAttribute(node, "action");
        if (this.type == null) {
            throw new InstantiationException("permission tag with missing type attribute");
        }
    }

    public PermissionDescriptor(String type, String name, String actions) {
        this.type = type;
        this.name = name;
        this.action = actions;
    }

    /*
     * WARNING - void declaration
     */
    public Permission getPermission(ClassLoader loader) throws InstantiationException {
        void var3_4;
        Object instance;
        Class<?> type;
        try {
            type = Class.forName(this.type, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Permission type '" + this.type + "' not found");
        }
        if (this.name == null) {
            try {
                instance = type.newInstance();
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Error creating Permission instance of type '" + this.type + "': " + e);
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException("Error creating Permission instance of type '" + this.type + "': " + e);
            }
        }
        try {
            Constructor<?> constructor;
            if (this.action == null) {
                constructor = type.getConstructor(String.class);
                instance = constructor.newInstance(this.name);
            } else {
                constructor = type.getConstructor(String.class, String.class);
                instance = constructor.newInstance(this.name, this.action);
            }
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Error creating Permission instance of type '" + this.type + "': " + e);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException("Permission type '" + this.type + "' lacks a valid " + type + "(String" + (this.action == null ? "" : ", String") + ") constructor, it can not have a " + (this.action == null ? "name" : "action") + " set for it");
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Error creating Permission instance of type '" + this.type + "': " + e);
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException("Error creating Permission instance of type '" + this.type + "': " + e.getTargetException());
        }
        if (!(var3_4 instanceof Permission)) {
            throw new InstantiationException(this.type + " was not a Permission instance");
        }
        Permission permission = (Permission)var3_4;
        return permission;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.print(indention + "<permission type=\"" + XMLUtils.encode(this.type) + "\"");
        if (this.name != null) {
            out.print(" name=\"" + XMLUtils.encode(this.name) + "\"");
        }
        if (this.action != null) {
            out.print(" action=\"" + XMLUtils.encode(this.name) + "\"");
        }
        out.println(" />");
    }
}

