/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.Group;
import com.evermind.security.User;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AbstractUser
implements User,
Serializable {
    private Map properties = new HashMap();
    private static final String NAME = "name";
    private static final String GROUPS = "groups";
    private static final String DESCRIPTION = "description";
    private static final String PASSWORD = "password";
    private static final String LOCALE = "locale";
    private static final String CERT_SERIAL = "certificateSerial";
    private static final String CERT_ISSUER = "certificateIssuerDN";
    private static final String X509_CERT = "X509Certificate";

    private void put(String propName, Object propValue) {
        this.properties.put(propName, propValue);
    }

    private Object get(String propName) {
        return this.properties.get(propName);
    }

    public AbstractUser(String name) {
        this.put(NAME, name);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.put(DESCRIPTION, description);
    }

    public boolean authenticate(String password) {
        String myPassword = this.getPassword();
        boolean result = myPassword == null ? true : myPassword.equals(password);
        return result;
    }

    public Locale getLocale() {
        return (Locale)this.get(LOCALE);
    }

    public void setLocale(Locale locale) {
        this.put(LOCALE, locale);
    }

    public boolean hasPermission(Permission permission) {
        boolean granted = false;
        Iterator groups = this.getGroups().iterator();
        while (groups.hasNext() && !granted) {
            Group group = (Group)groups.next();
            granted = group.hasPermission(permission);
        }
        return granted;
    }

    public boolean isMemberOf(Group group) {
        if (null != group) {
            Iterator iter = this.getGroups().iterator();
            while (iter.hasNext()) {
                Group member = (Group)iter.next();
                if (!member.getName().equals(group.getName())) continue;
                return true;
            }
            if (null != this.getName() && this.getName().equals(group.getName())) {
                return true;
            }
        }
        return false;
    }

    public void setPassword(String password) {
        this.put(PASSWORD, password);
    }

    public String getPassword() {
        return (String)this.get(PASSWORD);
    }

    public BigInteger getCertificateSerial() {
        return (BigInteger)this.get(CERT_SERIAL);
    }

    public String getCertificateIssuerDN() {
        return (String)this.get(CERT_ISSUER);
    }

    public void setCertificate(String issuerDN, BigInteger serial) {
        this.put(CERT_SERIAL, serial);
        this.put(CERT_ISSUER, issuerDN);
    }

    public void setCertificate(X509Certificate cert) {
        this.put(X509_CERT, cert);
    }

    public void addToGroup(Group group) {
        this.getGroups().add(group);
    }

    public void removeFromGroup(Group group) {
        this.getGroups().remove(group);
    }

    public Set getGroups() {
        HashSet groups = (HashSet)this.get(GROUPS);
        if (groups == null) {
            groups = new HashSet();
            this.put(GROUPS, groups);
        }
        return groups;
    }
}

