/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.Group;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class AbstractGroup
implements Group,
Serializable {
    private String description;
    private String name;
    private PermissionCollection permissions;
    private Set permissionSet;

    public AbstractGroup(String name) {
        this.name = name;
    }

    protected PermissionCollection getPermissionCollection() {
        if (this.permissions == null) {
            this.permissions = new Permissions();
        }
        return this.permissions;
    }

    public boolean hasPermission(Permission permission) {
        return this.getPermissionCollection().implies(permission);
    }

    public Set getPermissions() {
        if (this.permissionSet == null) {
            this.permissionSet = new HashSet();
            Enumeration<Permission> permissions = this.getPermissionCollection().elements();
            while (permissions.hasMoreElements()) {
                this.permissionSet.add(permissions.nextElement());
            }
        }
        return this.permissionSet;
    }

    public void addPermission(Permission permission) {
        this.getPermissionCollection().add(permission);
        this.permissionSet = null;
    }

    public void removePermission(Permission permission) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("removePermission not implemented");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }
}

