/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.reflect;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;

public class InterfaceType {
    protected Class[] interfaces;
    private WeakReference weakRefToClassLoader = null;
    private Constructor proxyConstructor;

    public InterfaceType() {
        this(null, null, null);
    }

    public InterfaceType(Class[] interfaces, Constructor proxyConstructor) {
        this(interfaces, null, proxyConstructor);
    }

    public InterfaceType(Class[] interfaces, ClassLoader classLoader, Constructor proxyConstructor) {
        this.interfaces = interfaces;
        this.weakRefToClassLoader = new WeakReference<ClassLoader>(classLoader);
        this.proxyConstructor = proxyConstructor;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public ClassLoader getClassLoader() {
        if (this.weakRefToClassLoader != null) {
            return (ClassLoader)this.weakRefToClassLoader.get();
        }
        return null;
    }

    public Constructor getProxyConstructor() {
        return this.proxyConstructor;
    }

    public void setProxyConstructor(Constructor constructor) {
        this.proxyConstructor = constructor;
    }

    public boolean equals(Object other) {
        if (!(other instanceof InterfaceType)) {
            return false;
        }
        InterfaceType type = (InterfaceType)other;
        if (this.interfaces.length != type.interfaces.length) {
            return false;
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i] == type.interfaces[i]) continue;
            return false;
        }
        return type.getClassLoader() == this.getClassLoader();
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.interfaces.length; ++i) {
            code = (code << 1) + this.interfaces[i].hashCode();
        }
        return code;
    }
}

