/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind.io.IOUtils;
import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.FlatContext;
import com.evermind.naming.RelativeContext;
import com.evermind.naming.archive.ArchiveContext;
import com.evermind.naming.archive.SerializableArchiveContext;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileNamingEnumeration;
import com.evermind.naming.file.SerializableFileContext;
import com.evermind.util.ResourceContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class FileContext
extends FlatContext
implements ResourceContainer,
LastModifiedContainer,
RelativeContext {
    protected File root;
    protected Map environment;
    protected boolean autoCreateDirectories = true;

    public FileContext(File root, Map environment) {
        this.root = root;
        this.environment = environment;
    }

    public void close() {
    }

    public Object addToEnvironment(String name, Object value) {
        return this.environment.put(name, value);
    }

    public Object removeFromEnvironment(String name) {
        return this.environment.remove(name);
    }

    public Hashtable getEnvironment() {
        return new Hashtable(this.environment);
    }

    public void bind(String name, Object value) throws NamingException {
        this.checkDirectoryExistence(name, false);
        this.bind(name, value, this.getFile(name));
    }

    public void bind(String name, Object value, File file) throws NamingException {
        if (file.exists()) {
            throw new NameAlreadyBoundException(file.toString());
        }
        try {
            this.writeObject(file, value);
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }

    public void rebind(String name, Object value) throws NamingException {
        this.checkDirectoryExistence(name, false);
        File file = this.getFile(name);
        file.delete();
        this.bind(name, value, file);
    }

    public boolean contains(String name) {
        return this.getFile(name).exists();
    }

    public void unbind(String name) throws NamingException {
        File file = this.getFile(name);
        if (!file.exists()) {
            throw new NameNotFoundException(name);
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String from, String to) throws NamingException {
        if (from.equals(to)) {
            return;
        }
        try {
            this.checkDirectoryExistence(to, false);
            File fromFile = this.getFile(from);
            File toFile = this.getFile(to);
            if (!fromFile.exists()) {
                throw new NameNotFoundException(fromFile.toString());
            }
            if (toFile.exists()) {
                throw new NameAlreadyBoundException(toFile.toString());
            }
            FileInputStream in = new FileInputStream(fromFile);
            try {
                FileOutputStream out = new FileOutputStream(toFile);
                try {
                    IOUtils.pipe(in, out);
                }
                finally {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {}
                }
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        File file = this.getFile(name);
        if (!file.exists()) {
            throw new NameNotFoundException(name);
        }
        if (!file.isDirectory()) {
            throw new NotContextException(name);
        }
        String[] subFiles = file.list();
        if (subFiles != null && subFiles.length > 0) {
            throw new ContextNotEmptyException(name);
        }
        if (!file.delete()) {
            throw new NamingException("Directory removal failed");
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        File file = this.getFile(name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(name);
        }
        this.checkDirectoryExistence(name, true);
        if (!file.mkdir() && !file.exists()) {
            throw new NamingException("Unable to create directory");
        }
        try {
            return this.createSubContext(file.getCanonicalFile());
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
    }

    public Context createSubContext(File file) {
        return new FileContext(file, this.environment == null ? null : new Hashtable(this.environment));
    }

    public Object lookup(String name) throws NamingException {
        File file = this.getFile(name);
        if (!file.exists()) {
            throw new NameNotFoundException(name);
        }
        if (file.isDirectory()) {
            try {
                return this.createSubContext(file.getCanonicalFile());
            }
            catch (IOException e) {
                throw new NamingException("IO error: " + e.getMessage());
            }
        }
        try {
            return this.getObject(file);
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        File file;
        if (name.equals("")) {
            file = this.root;
        } else {
            file = this.getFile(name);
            if (!file.exists()) {
                throw new NameNotFoundException(name);
            }
            if (!file.isDirectory()) {
                throw new NamingException("Not a directory");
            }
        }
        File[] files = file.listFiles();
        if (files == null) {
            throw new NameNotFoundException("No such context: '" + name + "'");
        }
        return new FileNamingEnumeration(files, this);
    }

    public NamingEnumeration listBindings(String name) {
        throw new UnsupportedOperationException("listBindings() is not supported");
    }

    public Object lookupLink(String name) {
        throw new UnsupportedOperationException("lookupLink() is not supported");
    }

    public File getFile(String name) {
        int colonIndex = name.lastIndexOf(58);
        if (colonIndex >= 0) {
            name = name.substring(colonIndex + 1);
        }
        return new File(this.root.getPath() + File.separatorChar + name.replace('/', File.separatorChar));
    }

    protected void checkDirectoryExistence(String name, boolean directory) throws NamingException {
        File file = new File(this.root.getPath() + File.separator + name);
        if (!file.getParentFile().exists()) {
            if (!this.autoCreateDirectories) {
                throw new NameNotFoundException("Parent directory does not exist: " + name);
            }
            ArrayList<File> files = new ArrayList<File>();
            File currentFile = file.getParentFile();
            while (!currentFile.exists()) {
                files.add(currentFile);
                currentFile = currentFile.getParentFile();
            }
            for (int i = files.size() - 1; i >= 0; --i) {
                ((File)files.get(i)).mkdir();
            }
        }
        if (directory && !file.exists() && !file.mkdir()) {
            if (!this.autoCreateDirectories) {
                throw new NameNotFoundException("Directory does not exist: " + name);
            }
            throw new NamingException("Unable to create directory");
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this.root.getPath();
    }

    protected Object getObject(File file) throws IOException, NamingException {
        return file;
    }

    protected void writeObject(File file, Object object) throws IOException, NamingException {
        if (object instanceof File && ((File)object).isDirectory()) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
    }

    public String toString() {
        return this.root.toString();
    }

    public boolean setLastModified(String path, long lastModified) throws IOException {
        return this.getFile(path).setLastModified(lastModified);
    }

    public long getLastModified(String path) {
        return this.getFile(path).lastModified();
    }

    public long getLength(String path) {
        return this.getFile(path).length();
    }

    public File getFile() {
        return this.root;
    }

    public URL getResource(String path) {
        File file = this.getFile(path);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Enumeration getResources(String path) {
        URL url = this.getResource(path);
        if (url != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(url);
            return Collections.enumeration(urls);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileContext)) {
            return false;
        }
        return ((FileContext)other).root.equals(this.root);
    }

    public int hashCode() {
        return this.root.hashCode() + 8;
    }

    public Context getRelative(String name) throws NamingException {
        if (this.root != null && name.equals(this.root.getName())) {
            throw new NamingException("Relative was myself");
        }
        String fileName = this.root.getPath().substring(0, this.root.getPath().lastIndexOf(File.separator) + 1) + name;
        File newFile = new File(fileName);
        if (!newFile.exists()) {
            throw new NamingException("Relative " + name + " does not exist (" + newFile + ")");
        }
        try {
            newFile = newFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (newFile.isDirectory()) {
            if (this instanceof ContentFileContext) {
                return new ContentFileContext(newFile, null);
            }
            if (this instanceof SerializableFileContext) {
                return new SerializableFileContext(newFile, null);
            }
            return new FileContext(newFile, null);
        }
        if (this instanceof ContentFileContext) {
            try {
                File parent = this.root.getParentFile();
                return ContextUtils.getContext(new ContentFileContext(parent, this.environment), name, false);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (this instanceof SerializableFileContext) {
            return new SerializableArchiveContext(newFile, false);
        }
        return new ArchiveContext(newFile, false);
    }
}

