/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassSerialization;

public class LinkedClassData
extends ClassData {
    public ClassSerialization serialization;
    public LinkedClassData superType;
    public LinkedClassData[] interfaceTypes;
    public LinkedClassData[] allInterfaceTypes;

    public LinkedClassData[] calculateAllInterfaceTypes() {
        if (this.interfaceTypes == null) {
            if (this.superType != null) {
                return this.superType.calculateAllInterfaceTypes();
            }
            return null;
        }
        LinkedClassData[] allInterfaceTypes = new LinkedClassData[4];
        for (int i = 0; i < this.interfaceCount; ++i) {
            allInterfaceTypes = this.interfaceTypes[i].addAllInterfaces(allInterfaceTypes);
        }
        return allInterfaceTypes;
    }

    public LinkedClassData[] addAllInterfaces(LinkedClassData[] existing) {
        int i;
        for (i = 0; i < existing.length && existing[i] != null; ++i) {
            if (existing[i] != this) continue;
            return existing;
        }
        existing = LinkedClassData.add(existing, this);
        if (this.interfaceCount != 0) {
            for (i = 0; i < this.interfaceCount; ++i) {
                existing = this.interfaceTypes[i].addAllInterfaces(existing);
            }
        }
        return existing;
    }

    public static LinkedClassData[] add(LinkedClassData[] input, LinkedClassData element) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != null) continue;
            input[i] = element;
            return input;
        }
        int pos = input.length;
        input = LinkedClassData.grow(input);
        input[pos] = element;
        return input;
    }

    public static LinkedClassData[] grow(LinkedClassData[] input) {
        LinkedClassData[] newInput = new LinkedClassData[input.length * 2];
        System.arraycopy(input, 0, newInput, 0, input.length);
        return newInput;
    }

    public boolean isSuperClass(ClassData other) {
        LinkedClassData current = this;
        do {
            if (current != other) continue;
            return true;
        } while ((current = current.superType) != null);
        return false;
    }
}

