/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient.packets;

import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.attributes.ChapChallengeAttribute;
import net.sourceforge.jradiusclient.attributes.ChapPasswordAttribute;
import net.sourceforge.jradiusclient.attributes.UserNameAttribute;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.util.ChapUtil;

public class ChapAccessRequest
extends RadiusPacket {
    private static final ChapUtil chapUtil = new ChapUtil();
    private boolean initialized = false;

    public ChapAccessRequest(String string, byte[] byArray, byte by, byte[] byArray2) throws InvalidParameterException {
        super(1);
        this.initialize(string, byArray, by, byArray2);
    }

    public ChapAccessRequest(String string, String string2) throws InvalidParameterException {
        this(string, string2.getBytes(), 16);
    }

    public ChapAccessRequest(String string, byte[] byArray) throws InvalidParameterException {
        this(string, byArray, 16);
    }

    public ChapAccessRequest(String string, byte[] byArray, int n) throws InvalidParameterException {
        super(1);
        byte by = chapUtil.getNextChapIdentifier();
        byte[] byArray2 = chapUtil.getNextChapChallenge(n);
        byte[] byArray3 = ChapUtil.chapEncrypt(by, byArray, byArray2);
        this.initialize(string, byArray3, by, byArray2);
    }

    private void initialize(String string, byte[] byArray, byte by, byte[] byArray2) throws InvalidParameterException {
        this.setAttribute(new UserNameAttribute(string));
        this.setAttribute(new ChapPasswordAttribute(by, byArray));
        this.setAttribute(new ChapChallengeAttribute(byArray2));
        this.initialized = true;
    }

    public void validateAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (this.initialized && (radiusAttribute.getType() == 1 || radiusAttribute.getType() == 3 || radiusAttribute.getType() == 60)) {
            throw new InvalidParameterException("Already initialized, cannot reset username, chap password or chap challenge.");
        }
        if (radiusAttribute.getType() == 2) {
            throw new InvalidParameterException("Already initialized, cannot set USER_PASSWORD in a CHAP Access Request.");
        }
    }
}

