/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;

public class RadiusAttribute {
    private static final int HEADER_LENGTH = 2;
    private byte[] packetBytes;

    public RadiusAttribute(int n, byte[] byArray) throws InvalidParameterException {
        if (n > 256) {
            throw new InvalidParameterException("type must be small enough to fit in a byte (i.e. less than 256) and should be chosen from static final constants defined in RadiusValues");
        }
        if (null == byArray) {
            throw new InvalidParameterException("Value cannot be NULL");
        }
        int n2 = 2 + byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        try {
            byteArrayOutputStream.write(n);
            byteArrayOutputStream.write(n2);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new InvalidParameterException("Error constructing RadiusAttribute");
        }
        this.packetBytes = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getType() {
        return this.packetBytes[0];
    }

    public byte[] getValue() {
        int n = this.packetBytes.length - 2;
        byte[] byArray = new byte[n];
        System.arraycopy(this.packetBytes, 2, byArray, 0, n);
        return byArray;
    }

    protected final byte[] getBytes() {
        return this.packetBytes;
    }
}

