/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic.dms;

import oracle.dms.instrument.Sensor;

public class DMSMetric {
    private Sensor sensor = null;
    private String sensorName = null;
    private String statName = null;
    private String statDesc = null;
    private String units = null;
    private int derivation = -1;
    private String highWaterMarkMetricName = null;
    private String lowWaterMarkMetricName = null;
    private String upperBoundMetricName = null;
    private String lowerBoundMetricName = null;
    private String oracleHome = null;
    private String opmnUID = null;
    private String parentName = null;
    private String nounName = null;
    private String shortSensorName = null;
    private String metricName = null;

    public DMSMetric(String _sensorName, String _statName) {
        this.init(_sensorName, -1, _statName, null, null);
    }

    public DMSMetric(String _sensorName, String _statName, String _statDesc, String _units) {
        this.init(_sensorName, -1, _statName, _statDesc, _units);
    }

    public DMSMetric(String _oracleHome, String _opmnUID, String _parentName, String _nounName, String _shortSensorName, String _metricName, String _statName, String _statDesc, String _units) {
        this.oracleHome = _oracleHome;
        this.opmnUID = _opmnUID;
        this.parentName = _parentName;
        this.nounName = _nounName;
        this.shortSensorName = _shortSensorName;
        this.metricName = _metricName;
        String sensorName = null;
        sensorName = this.parentName == null || this.parentName.equals("/") ? "/" + this.nounName + "/" + this.shortSensorName : this.parentName + "/" + this.nounName + "/" + this.shortSensorName;
        this.init(sensorName, -1, _statName, _statDesc, _units);
    }

    public DMSMetric(String _sensorName, int _derivation, String _statName, String _statDesc, String _units) {
        this.init(_sensorName, _derivation, _statName, _statDesc, _units);
    }

    public DMSMetric(String _sensorName) {
        this.init(_sensorName, -1, null, null, null);
    }

    public DMSMetric(String _sensorName, int _derivation, String _statName, String _statDesc, String _units, String _highWaterMarkMetricName, String _lowWaterMarkMetricName, String _upperBoundMetricName, String _lowerBoundMetricName) {
        this.init(_sensorName, _derivation, _statName, _statDesc, _units);
        this.highWaterMarkMetricName = _highWaterMarkMetricName;
        this.lowWaterMarkMetricName = _lowWaterMarkMetricName;
        this.upperBoundMetricName = _upperBoundMetricName;
        this.lowerBoundMetricName = _lowerBoundMetricName;
    }

    public DMSMetric(Sensor _sensor, String _statName, String _statDesc, String _units) {
        if (_sensor != null) {
            this.sensor = _sensor;
            this.sensorName = this.sensor.getParent().toString() + "/" + this.sensor.getName();
            this.init(this.sensorName, -1, _statName, _statDesc, _units);
        }
    }

    public DMSMetric(Sensor _sensor, int _derivation, String _statName, String _statDesc, String _units) {
        if (_sensor != null) {
            this.sensor = _sensor;
            this.sensorName = this.sensor.getParent().toString() + "/" + this.sensor.getName();
            this.init(this.sensorName, _derivation, _statName, _statDesc, _units);
        }
    }

    public DMSMetric(Sensor _sensor, String _statName) {
        if (_sensor != null) {
            this.sensor = _sensor;
            this.sensorName = this.sensor.getParent().toString() + "/" + this.sensor.getName();
            this.init(this.sensorName, -1, _statName, null, null);
        }
    }

    public DMSMetric(Sensor _sensor) {
        if (_sensor != null) {
            this.sensor = _sensor;
            this.sensorName = this.sensor.getParent().toString() + "/" + this.sensor.getName();
        }
    }

    public DMSMetric(Sensor _sensor, int _derivation, String _statName, String _statDesc, String _units, String _highWaterMarkMetricName, String _lowWaterMarkMetricName, String _upperBoundMetricName, String _lowerBoundMetricName) {
        if (_sensor != null) {
            this.sensor = _sensor;
            this.sensorName = this.sensor.getParent().toString() + "/" + this.sensor.getName();
            this.init(this.sensorName, _derivation, _statName, _statDesc, _units);
            this.highWaterMarkMetricName = _highWaterMarkMetricName;
            this.lowWaterMarkMetricName = _lowWaterMarkMetricName;
            this.upperBoundMetricName = _upperBoundMetricName;
            this.lowerBoundMetricName = _lowerBoundMetricName;
        }
    }

    private void init(String _sensorName, int _derivation, String _statName, String _statDesc, String _units) {
        this.sensorName = _sensorName;
        this.derivation = _derivation;
        this.statName = _statName;
        this.statDesc = _statDesc;
        this.units = _units;
        if (this.sensor == null && this.sensorName != null) {
            this.sensor = Sensor.get((String)this.sensorName);
        }
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String getShortSensorName() {
        return this.shortSensorName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getNounName() {
        return this.nounName;
    }

    public String getOpmnUID() {
        return this.opmnUID;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    public String getStatName() {
        return this.statName;
    }

    public String getStatDesc() {
        return this.statDesc;
    }

    public String getUnits() {
        return this.units;
    }

    public int getDerivation() {
        return this.derivation;
    }

    public long getValue() {
        if (this.derivation > 0) {
            return this.getValue(this.derivation);
        }
        return 0L;
    }

    public long getValue(int _derivation) {
        Object val;
        if (_derivation > 0 && this.sensor != null && (val = this.sensor.getValue(_derivation)) != null && val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }

    public String getHighWaterMarkMetricName() {
        return this.highWaterMarkMetricName;
    }

    public String getLowWaterMarkMetricName() {
        return this.lowWaterMarkMetricName;
    }

    public String getUpperBoundMetricName() {
        return this.upperBoundMetricName;
    }

    public String getLowerBoundMetricName() {
        return this.lowerBoundMetricName;
    }
}

