/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.management.j2ee.statistics.CountStatistic;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.shared.statistic.CountStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.StatsImpl;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;

public class OpmnProcessStatsImpl
extends StatsImpl {
    static final long serialVersionUID = 6801603733610820918L;
    private long samplingStartTime_ = 0L;
    private long heapSize_ = 0L;
    private transient OpmnProcess opmnProc_ = null;
    private static final String[] statNames_ = new String[]{"UpTime", "CpuTime", "HeapSize", "MemoryUsed", "PrivateMemory", "SharedMemory"};
    private transient StatsLocalizationHelper statsLocalizationHelper_ = null;

    public OpmnProcessStatsImpl(OpmnProcess opmnProc, Locale loc) {
        this.statsLocalizationHelper_ = new StatsLocalizationHelper(loc);
        this.opmnProc_ = opmnProc;
        try {
            String startTime = opmnProc.getStartTime();
            this.samplingStartTime_ = startTime == null ? 0L : Long.parseLong(startTime);
        }
        catch (Exception e) {
            this.samplingStartTime_ = 0L;
        }
        HashMap<String, CountStatistic> map = new HashMap<String, CountStatistic>();
        map.put(statNames_[0], this.fetchUpTime());
        map.put(statNames_[1], this.fetchCpuTime());
        map.put(statNames_[2], this.fetchHeapSize());
        map.put(statNames_[3], this.fetchMemoryUsed());
        map.put(statNames_[4], this.fetchPrivateMemory());
        map.put(statNames_[5], this.fetchSharedMemory());
        this.init(statNames_, map);
    }

    public final CountStatistic getUpTime() {
        return (CountStatistic)this.getStatistic("UpTime");
    }

    protected CountStatistic fetchUpTime() {
        try {
            long upTimeVal = 0L;
            String upTime = this.opmnProc_.getUpTime();
            if (upTime != null && !"N/A".equalsIgnoreCase(upTime)) {
                upTimeVal = Long.parseLong(upTime);
            }
            long cur = new Date().getTime();
            return new CountStatisticImpl("UpTime", "MILLISECOND", this.statsLocalizationHelper_.getLocalizedMessage("stats_opmprocesstatsimpl_up_time"), this.samplingStartTime_, cur, upTimeVal);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final CountStatistic getCpuTime() {
        return (CountStatistic)this.getStatistic("CpuTime");
    }

    protected CountStatistic fetchCpuTime() {
        try {
            long cpuTimeVal = 0L;
            String cpuTime = this.opmnProc_.getCpuTime();
            if (cpuTime != null && !"N/A".equalsIgnoreCase(cpuTime)) {
                cpuTimeVal = Long.parseLong(cpuTime);
            }
            long cur = new Date().getTime();
            return new CountStatisticImpl("CpuTime", "MILLISECOND", this.statsLocalizationHelper_.getLocalizedMessage("stats_opmprocesstatsimpl_cpu_time"), this.samplingStartTime_, cur, cpuTimeVal);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final CountStatistic getHeapSize() {
        return (CountStatistic)this.getStatistic("HeapSize");
    }

    protected CountStatistic fetchHeapSize() {
        try {
            long val = 0L;
            String sval = this.opmnProc_.getHeapSize();
            if (sval != null && !"N/A".equalsIgnoreCase(sval)) {
                val = Long.parseLong(sval);
            }
            long cur = new Date().getTime();
            return new CountStatisticImpl("HeapSize", "KILO-BYTES", this.statsLocalizationHelper_.getLocalizedMessage("stats_opmprocesstatsimpl_heap_size"), this.samplingStartTime_, cur, val);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final CountStatistic getMemoryUsed() {
        return (CountStatistic)this.getStatistic("MemoryUsed");
    }

    protected CountStatistic fetchMemoryUsed() {
        try {
            long val = 0L;
            String sval = this.opmnProc_.getMemoryUsed();
            if (sval != null && !"N/A".equalsIgnoreCase(sval)) {
                val = Long.parseLong(sval);
            }
            long cur = new Date().getTime();
            return new CountStatisticImpl("MemoryUsed", "KILO-BYTES", this.statsLocalizationHelper_.getLocalizedMessage("stats_opmprocesstatsimpl_memory_used"), this.samplingStartTime_, cur, val);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final CountStatistic getPrivateMemory() {
        return (CountStatistic)this.getStatistic("PrivateMemory");
    }

    protected CountStatistic fetchPrivateMemory() {
        try {
            long val = 0L;
            String sval = this.opmnProc_.getPrivateMemory();
            if (sval != null && !"N/A".equalsIgnoreCase(sval)) {
                val = Long.parseLong(sval);
            }
            long cur = new Date().getTime();
            return new CountStatisticImpl("PrivateMemory", "KILO-BYTES", this.statsLocalizationHelper_.getLocalizedMessage("stats_opmprocesstatsimpl_private_memory"), this.samplingStartTime_, cur, val);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final CountStatistic getSharedMemory() {
        return (CountStatistic)this.getStatistic("SharedMemory");
    }

    protected CountStatistic fetchSharedMemory() {
        try {
            long val = 0L;
            String sval = this.opmnProc_.getSharedMemory();
            if (sval != null && !"N/A".equalsIgnoreCase(sval)) {
                val = Long.parseLong(sval);
            }
            long cur = new Date().getTime();
            return new CountStatisticImpl("SharedMemory", "KILO-BYTES", this.statsLocalizationHelper_.getLocalizedMessage("stats_opmprocesstatsimpl_shared_memory"), this.samplingStartTime_, cur, val);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }
}

