/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared;

import java.io.File;
import java.io.Serializable;
import java.net.URL;

public class WebBinding
implements Serializable {
    static final long serialVersionUID = -5777424399969889047L;
    private String application_ = null;
    private String webModule_ = null;
    private String webSitePath_ = null;
    private String webSiteName_ = null;
    private String rootCtx_ = null;
    private boolean preload_ = false;
    private boolean shared_ = false;
    private String id_ = null;
    private boolean accessLog_ = false;
    private String maxInactivityTime_ = "no shutdown";

    public WebBinding(String application, String webModule, URL webSitePath, String rootCtx, boolean preload, boolean shared) {
        this.application_ = application;
        this.webModule_ = webModule;
        this.rootCtx_ = rootCtx;
        File file = new File(webSitePath.getPath());
        if (webSitePath != null) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.webSitePath_ = path != null ? path : webSitePath.getPath();
        }
        if (this.webSitePath_ != null) {
            this.webSiteName_ = file.getName();
            if (this.webSiteName_ != null && this.webSiteName_.indexOf(46) != -1) {
                this.webSiteName_ = this.webSiteName_.substring(0, this.webSiteName_.indexOf(46));
            }
        }
        this.preload_ = preload;
        this.shared_ = shared;
        this.id_ = application + '_' + webModule + '_' + this.webSiteName_ + '_' + rootCtx;
    }

    public WebBinding(String application, String webModule, URL webSitePath, String rootCtx, boolean preload, boolean shared, boolean accessLog, String maxInactivityTime) {
        this(application, webModule, webSitePath, rootCtx, preload, shared);
        this.accessLog_ = accessLog;
        this.maxInactivityTime_ = maxInactivityTime;
    }

    public final String getApplication() {
        return this.application_;
    }

    public final String getWebModule() {
        return this.webModule_;
    }

    public final String getWebSitePath() {
        return this.webSitePath_;
    }

    public final String getWebSiteName() {
        return this.webSiteName_;
    }

    public final String getRootContext() {
        return this.rootCtx_;
    }

    public final boolean getPreload() {
        return this.preload_;
    }

    public final boolean getShared() {
        return this.shared_;
    }

    public boolean getAccessLog() {
        return this.accessLog_;
    }

    public void setAccessLog(boolean value) {
        this.accessLog_ = value;
    }

    public String getMaxInactivityTime() {
        return this.maxInactivityTime_;
    }

    public void setMaxInactivityTime(String value) {
        this.maxInactivityTime_ = value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Application             : ");
        buf.append("\n");
        buf.append(this.getApplication());
        buf.append("\n");
        buf.append("Web-module              : ");
        buf.append(this.getWebModule());
        buf.append("\n");
        buf.append("Web-site name           : ");
        buf.append(this.getWebSiteName());
        buf.append("\n");
        buf.append("Web-site path           : ");
        buf.append(this.getWebSitePath());
        buf.append("\n");
        buf.append("Root Context            : ");
        buf.append(this.getRootContext());
        buf.append("\n");
        buf.append("Pre-load                : ");
        buf.append(this.getPreload());
        buf.append("\n");
        buf.append("Shared                  : ");
        buf.append(this.getShared());
        buf.append("\n");
        buf.append("access-log              : ");
        buf.append(this.getAccessLog());
        buf.append("\n");
        buf.append("max-inactivity-time     : ");
        buf.append(this.getMaxInactivityTime());
        buf.append("\n");
        return buf.toString();
    }

    public int hashCode() {
        return this.id_.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebBinding)) {
            return false;
        }
        return this.id_.equals(((WebBinding)obj).id_);
    }
}

