/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class UserMBeanServer
implements MBeanServer {
    private Set validDomainNames_ = null;
    private String appDomain_ = null;
    private MBeanServer mbeanServer_ = null;
    private boolean unrestrictedAccess_ = false;

    public UserMBeanServer(String appName, MBeanServer server, Set readDomains) {
        this.validDomainNames_ = readDomains;
        this.appDomain_ = appName;
        if (this.appDomain_ == null) {
            throw new JMXRuntimeException("JMX domain for a user application cannot be null");
        }
        this.validDomainNames_.add(this.appDomain_);
        this.validDomainNames_.add("default");
        this.mbeanServer_ = server;
    }

    public UserMBeanServer(String appName, MBeanServer server) {
        this.validDomainNames_ = new HashSet();
        this.appDomain_ = appName;
        if (this.appDomain_ == null) {
            throw new JMXRuntimeException("JMX domain for a user application cannot be null");
        }
        this.validDomainNames_.add(this.appDomain_);
        this.validDomainNames_.add("default");
        this.mbeanServer_ = server;
    }

    public UserMBeanServer(String appName, MBeanServer server, boolean unrestrictedAccess) {
        this(appName, server);
        this.unrestrictedAccess_ = unrestrictedAccess;
    }

    public final ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ClassLoaderRepository getClassLoaderRepository() {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final Object instantiate(String className) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        ObjectName verifiedName = this.checkNameValidity(name);
        this.mbeanServer_.addNotificationListener(verifiedName, listener, filter, handback);
    }

    public final void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        ObjectName verifiedName = this.checkNameValidity(name);
        this.mbeanServer_.addNotificationListener(verifiedName, listener, filter, handback);
    }

    public final void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        ObjectName verifiedName = this.checkNameValidity(name);
        this.mbeanServer_.removeNotificationListener(verifiedName, listener);
    }

    public final void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        ObjectName verifiedName = this.checkNameValidity(name);
        this.mbeanServer_.removeNotificationListener(verifiedName, listener);
    }

    public final void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        ObjectName verifiedName = this.checkNameValidity(name);
        this.mbeanServer_.removeNotificationListener(verifiedName, listener, filter, handback);
    }

    public final void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        ObjectName verifiedName = this.checkNameValidity(name);
        this.mbeanServer_.removeNotificationListener(verifiedName, listener, filter, handback);
    }

    public final ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null) {
            throw new NotCompliantMBeanException("Cannot register a null MBean instance");
        }
        if (name == null) {
            if (object instanceof MBeanRegistration) {
                MBeanRegistration mbeanInst = (MBeanRegistration)object;
                ObjectName regName = null;
                try {
                    regName = mbeanInst.preRegister(this, null);
                }
                catch (Exception e) {
                    throw new MBeanRegistrationException(e, e.getMessage());
                }
                if (regName == null) {
                    throw new NotCompliantMBeanException("ObjectName returned by preRegister cannot be null");
                }
                ObjectName registrationName = this.checkRegisterAccess(regName);
                return this.mbeanServer_.registerMBean(object, registrationName);
            }
            throw new NotCompliantMBeanException("Cannot register an MBean with a null ObjectName");
        }
        ObjectName registrationName = this.checkRegisterAccess(name);
        return this.mbeanServer_.registerMBean(object, registrationName);
    }

    public final String[] getDomains() {
        String[] res = new String[this.validDomainNames_.size() + 1];
        Iterator it = this.validDomainNames_.iterator();
        int i = 0;
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        res[i] = "oc4j";
        return res;
    }

    public final void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName registrationName = this.checkRegisterAccess(name);
        this.mbeanServer_.unregisterMBean(registrationName);
    }

    public final ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        ObjectName validName = this.checkReadAccess(name);
        return this.mbeanServer_.getObjectInstance(validName);
    }

    public final Set queryMBeans(ObjectName pattern, QueryExp query) {
        Set<ObjectInstance> fullResult = this.mbeanServer_.queryMBeans(pattern, query);
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        Iterator<ObjectInstance> it = fullResult.iterator();
        while (it.hasNext()) {
            ObjectInstance objectInst = it.next();
            ObjectName name = objectInst.getObjectName();
            try {
                ObjectName validName = this.checkReadAccess(name);
                result.add(new ObjectInstance(validName, objectInst.getClassName()));
            }
            catch (SecurityException se) {}
        }
        return result;
    }

    public final Set queryNames(ObjectName pattern, QueryExp query) {
        Set<ObjectName> fullResult = this.mbeanServer_.queryNames(pattern, query);
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        Iterator<ObjectName> it = fullResult.iterator();
        while (it.hasNext()) {
            ObjectName name = it.next();
            try {
                ObjectName validName = this.checkReadAccess(name);
                result.add(validName);
            }
            catch (SecurityException se) {}
        }
        return result;
    }

    public final boolean isRegistered(ObjectName name) {
        ObjectName validName = this.checkReadAccess(name);
        return this.mbeanServer_.isRegistered(validName);
    }

    public final Integer getMBeanCount() {
        Set allMBeans = this.queryNames(null, null);
        return new Integer(allMBeans.size());
    }

    public final Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        ObjectName validName = this.checkReadAccess(name);
        return this.mbeanServer_.getAttribute(validName, attribute);
    }

    public final AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        ObjectName validName = this.checkReadAccess(name);
        return this.mbeanServer_.getAttributes(validName, attributes);
    }

    public final void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ObjectName validName = this.checkWriteAccess(name);
        this.mbeanServer_.setAttribute(validName, attribute);
    }

    public final AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        ObjectName validName = this.checkWriteAccess(name);
        return this.mbeanServer_.setAttributes(validName, attributes);
    }

    public final Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        ObjectName validName = this.checkWriteAccess(name);
        return this.mbeanServer_.invoke(validName, operationName, params, signature);
    }

    public final String getDefaultDomain() {
        return this.appDomain_;
    }

    public final MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        ObjectName validName = this.checkReadAccess(name);
        return this.mbeanServer_.getMBeanInfo(validName);
    }

    public final boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        ObjectName validName = this.checkReadAccess(name);
        return this.mbeanServer_.isInstanceOf(validName, className);
    }

    public final ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public final ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    private ObjectName checkNameValidity(ObjectName name) {
        if (name == null) {
            return name;
        }
        String domain = name.getDomain();
        if (domain == null || "".equals(domain)) {
            String curName = name.toString();
            try {
                return new ObjectName(this.appDomain_ + curName);
            }
            catch (MalformedObjectNameException e) {
                throw new JMXRuntimeException(e);
            }
        }
        return name;
    }

    private ObjectName checkReadAccess(ObjectName name) {
        if (name == null) {
            throw new SecurityException("Null ObjectName for jmx read type operation");
        }
        String domain = name.getDomain();
        if (domain == null || "".equals(domain)) {
            String curName = name.toString();
            try {
                return new ObjectName(this.appDomain_ + curName);
            }
            catch (MalformedObjectNameException e) {
                throw new JMXRuntimeException(e);
            }
        }
        if (this.unrestrictedAccess_) {
            return name;
        }
        if ("oc4j".equals(domain)) {
            String j2eeType = name.getKeyProperty("j2eeType");
            if ("Security".equals(j2eeType)) {
                throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to system MBean: " + name);
            }
            String J2EEApplication = name.getKeyProperty("J2EEApplication");
            if (this.appDomain_.equals(J2EEApplication)) {
                return name;
            }
            String nameprop = name.getKeyProperty("name");
            if ("J2EEApplication".equals(j2eeType) && this.appDomain_.equals(nameprop)) {
                return name;
            }
            throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to system MBean: " + name);
        }
        if (!this.validDomainNames_.contains(domain)) {
            throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to MBean: " + name);
        }
        return name;
    }

    private ObjectName checkWriteAccess(ObjectName name) {
        if (name == null) {
            throw new SecurityException("Null ObjectName for jmx registration operation");
        }
        String domain = name.getDomain();
        if (domain == null || "".equals(domain)) {
            String curName = name.toString();
            try {
                return new ObjectName(this.appDomain_ + curName);
            }
            catch (MalformedObjectNameException e) {
                throw new JMXRuntimeException(e);
            }
        }
        if (this.unrestrictedAccess_) {
            return name;
        }
        if ("oc4j".equals(domain)) {
            String j2eeType = name.getKeyProperty("j2eeType");
            if ("Security".equals(j2eeType)) {
                throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to system MBean: " + name);
            }
            String J2EEApplication = name.getKeyProperty("J2EEApplication");
            if (this.appDomain_.equals(J2EEApplication)) {
                return name;
            }
            String nameprop = name.getKeyProperty("name");
            if ("J2EEApplication".equals(j2eeType) && this.appDomain_.equals(nameprop)) {
                return name;
            }
            throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to system MBean: " + name);
        }
        if ("default".equals(domain)) {
            return name;
        }
        if (!this.appDomain_.equals(domain)) {
            throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to MBean: " + name);
        }
        return name;
    }

    private ObjectName checkRegisterAccess(ObjectName name) {
        if (name == null) {
            throw new SecurityException("Null ObjectName for jmx registration operation");
        }
        String domain = name.getDomain();
        if (domain == null || "".equals(domain)) {
            String curName = name.toString();
            try {
                return new ObjectName(this.appDomain_ + curName);
            }
            catch (MalformedObjectNameException e) {
                throw new JMXRuntimeException(e);
            }
        }
        if (this.unrestrictedAccess_) {
            return name;
        }
        if ("default".equals(domain)) {
            return name;
        }
        if (!this.appDomain_.equals(domain)) {
            throw new SecurityException("Unauthorized access from application: " + this.appDomain_ + " to MBean: " + name);
        }
        return name;
    }
}

