/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.XAQueueConnectionFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.naming.InitialContext;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jDomain;
import oracle.oc4j.admin.jmx.shared.JMSiASDomain;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;

public class MBeanServerConnectionListener
implements NotificationListener {
    private QueueSender sender_ = null;
    private QueueConnection connection_ = null;
    private QueueSession session_ = null;
    private RemoteListenerId listenerId_ = null;
    private Domain domain_ = null;
    private Logger jmsLogger_ = null;

    public MBeanServerConnectionListener(RemoteListenerId listenerId, Queue replyToQueue, Domain domain, Logger jmsLogger) {
        try {
            this.jmsLogger_ = jmsLogger;
            this.listenerId_ = listenerId;
            this.domain_ = domain;
            String queueCFStr = null;
            queueCFStr = this.domain_ instanceof JMSiASDomain ? ((JMSiASDomain)this.domain_).getQueueConnectionFactory() : ((JMSOc4jDomain)this.domain_).getQueueConnectionFactory();
            InitialContext ctx = new InitialContext();
            XAQueueConnectionFactory queueCF = (XAQueueConnectionFactory)ctx.lookup(queueCFStr);
            this.connection_ = queueCF.createQueueConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
            this.session_ = this.connection_.createQueueSession(false, 1);
            this.sender_ = this.session_.createSender(replyToQueue);
            this.connection_.start();
        }
        catch (Exception e) {
            this.jmsLogger_.log(Level.WARNING, "JMS Connector: <MBeanServerConnectionListener> Caught Exception " + e, e);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            Serializable[] msgObject = new Serializable[]{this.listenerId_, notification, (Serializable)handback};
            ObjectMessage msg = this.session_.createObjectMessage((Serializable)msgObject);
            this.sender_.send((Message)msg);
        }
        catch (Exception e) {
            this.jmsLogger_.log(Level.WARNING, "JMS Connector: <MBeanServerConnectionListener> Caught Exception " + e, e);
        }
    }

    public void releaseResources() {
        try {
            this.connection_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

