/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Session;
import javax.jms.TopicPublisher;
import javax.management.MBeanServer;
import javax.naming.Context;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jDomain;
import oracle.oc4j.admin.jmx.shared.JMSRemoteObject;
import oracle.oc4j.admin.jmx.shared.JMSiASDomain;

public class MBeanServerConnectionCaller
implements Serializable {
    private Domain domain_ = null;
    private String methodName_ = null;
    private String[] signature_ = null;
    private Object[] arguments_ = null;
    private boolean useLocalVersion_ = false;
    private MBeanServer mbeanServer_ = null;
    private boolean localeHasBeenSet_ = false;
    private transient Logger jmsLogger_ = null;

    public MBeanServerConnectionCaller(Domain domain, String methodName, String[] signature, Object[] arguments, Logger logger, boolean useLocalVersion) {
        this.init(domain, methodName, signature, arguments, logger, useLocalVersion);
    }

    public MBeanServerConnectionCaller(Domain domain, String methodName, String[] signature, Object[] arguments, Logger logger) {
        this.init(domain, methodName, signature, arguments, logger, false);
    }

    public Domain getDomain() {
        return this.domain_;
    }

    public String getMethodName() {
        return this.methodName_;
    }

    public String[] getSignature() {
        return this.signature_;
    }

    public Object[] getArguments() {
        return this.arguments_;
    }

    public boolean getUseLocalVersion() {
        return this.useLocalVersion_;
    }

    private void init(Domain domain, String methodName, String[] signature, Object[] arguments, Logger logger, boolean useLocalVersion) {
        this.domain_ = domain;
        this.methodName_ = methodName;
        this.signature_ = signature;
        this.useLocalVersion_ = useLocalVersion;
        this.arguments_ = this.checkParametersAreSerializable(arguments);
        this.jmsLogger_ = logger;
    }

    private final Serializable[] checkParametersAreSerializable(Object[] params) {
        if (params == null) {
            return null;
        }
        Serializable[] s = new Serializable[params.length];
        for (int i = 0; i < params.length; ++i) {
            try {
                s[i] = (Serializable)params[i];
                continue;
            }
            catch (ClassCastException ce) {
                throw new ClassCastException("Parameter number: " + i + " of type: " + params[i].getClass() + " does not implement the Serializable interface");
            }
        }
        return s;
    }

    public JMSRemoteObject remoteExecute(Context ctx, Queue replyToQueue, QueueReceiver queueReceiver, MessageProducer jmsMsgProducer, Session jmsSession) {
        try {
            if (this.domain_ instanceof JMSiASDomain) {
                ObjectMessage msg = jmsSession.createObjectMessage((Serializable)this);
                msg.setJMSReplyTo((Destination)replyToQueue);
                ((TopicPublisher)jmsMsgProducer).publish((Message)msg);
                Message response = queueReceiver.receive(((JMSiASDomain)this.domain_).getMaxMsgWaitTime());
                if (response != null && response instanceof ObjectMessage) {
                    return (JMSRemoteObject)((ObjectMessage)response).getObject();
                }
            } else if (this.domain_ instanceof JMSOc4jDomain) {
                ObjectMessage msg = jmsSession.createObjectMessage((Serializable)this);
                msg.setJMSReplyTo((Destination)replyToQueue);
                msg.setStringProperty("OC4JID", Integer.toString(((JMSOc4jDomain)this.domain_).getOc4jId(), 10));
                jmsMsgProducer.send((Message)msg);
                Message response = queueReceiver.receive(((JMSOc4jDomain)this.domain_).getMaxMsgWaitTime());
                if (response != null && response instanceof ObjectMessage) {
                    return (JMSRemoteObject)((ObjectMessage)response).getObject();
                }
            }
        }
        catch (Exception e) {
            this.jmsLogger_.log(Level.WARNING, "JMS Connector: <MBeanServerConnectionCaller> Caught Exception " + e, e);
        }
        return null;
    }
}

