/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import oracle.oc4j.admin.jmx.client.ListenerIdManager;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;

public class JMSreplyToQueueListener
implements MessageListener {
    private Domain domain_ = null;
    private Logger jmsLogger_ = null;

    public JMSreplyToQueueListener(Domain domain, Logger jmsLogger) {
        this.domain_ = domain;
        this.jmsLogger_ = jmsLogger;
    }

    public void onMessage(Message message) {
        ObjectMessage msg = null;
        try {
            Serializable[] msgObject;
            if (message instanceof ObjectMessage && (msgObject = (Serializable[])(msg = (ObjectMessage)message).getObject()) != null && msgObject.length == 3) {
                RemoteListenerId listenerId = (RemoteListenerId)msgObject[0];
                Notification notification = (Notification)msgObject[1];
                Serializable handback = msgObject[2];
                if (this.jmsLogger_.isLoggable(Level.FINE)) {
                    this.jmsLogger_.log(Level.FINE, "JMS Connector: <JMSreplyToQueueListener> message received");
                }
                if (listenerId != null) {
                    NotificationListener listener;
                    if (this.jmsLogger_.isLoggable(Level.FINE)) {
                        this.jmsLogger_.log(Level.FINE, "JMS Connector: <JMSreplyToQueueListener> Forwarding notification to client listener");
                    }
                    if ((listener = ListenerIdManager.getNotificationListener(listenerId, this.domain_)) != null) {
                        listener.handleNotification(notification, handback);
                    }
                }
            }
        }
        catch (Exception e) {
            this.jmsLogger_.log(Level.WARNING, "JMS Connector: <JMSreplyToQueueListener> Caught Exception " + e, e);
        }
    }
}

