/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.client.JMSreplyToQueueListener;
import oracle.oc4j.admin.jmx.client.ListenerIdManager;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jDomain;
import oracle.oc4j.admin.jmx.shared.JMSRemoteObject;
import oracle.oc4j.admin.jmx.shared.JMSiASDomain;
import oracle.oc4j.admin.jmx.shared.MBeanServerConnectionCaller;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;

public class JMSRemoteMBeanServer
implements Connector {
    private JMXConnector jmxConnector_ = null;
    private static String lifeCycleLock_ = "JMSRemoteMBeanServer Life cycle Lock";
    private static String jmsListenerLifeCycleLock_ = "JMSRemoteMBeanServer JMS Listener Life cycle Lock";
    private static Hashtable domainToJMSRemoteMBeanServerAssociation_ = new Hashtable();
    private static Hashtable domainToJMSRemoteMBeanServerAssociationRefCount_ = new Hashtable();
    private static int jmsListenerRefCount_ = 0;
    private Domain domain_ = null;
    private static final String application_client_xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE application-client PUBLIC '-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN' 'http://java.sun.com/dtd/application-client_1_3.dtd'>\n\n<application-client>\n<display-name>JMX 1.2 application client</display-name>\n<description>Provide a naming context to access JMS destinations</description>\n\n<resource-ref>\n<res-ref-name>jms/XAQueueConnectionFactory</res-ref-name>\n<res-type>javax.jms.XAQueueConnectionFactory</res-type>\n<res-auth>Container</res-auth>\n</resource-ref>\n<resource-ref>\n<res-ref-name>jms/XATopicConnectionFactory</res-ref-name>\n<res-type>javax.jms.XATopicConnectionFactory</res-type>\n<res-auth>Container</res-auth>\n</resource-ref>\n<resource-env-ref>\n<resource-env-ref-name>jms/oc4jDomain</resource-env-ref-name>\n<resource-env-ref-type>javax.jms.Queue</resource-env-ref-type>\n</resource-env-ref>\n</application-client>";
    private Context remoteOc4jContext_ = null;
    private JMSreplyToQueueListener jmsListener = null;
    private Queue jmsListenerReplyToQueue = null;
    private Queue replyToQueue = null;
    private QueueReceiver queueReceiver = null;
    private Destination jmsDestination = null;
    private TopicConnection topicConnection = null;
    private QueueConnection queueConnection = null;
    private MessageProducer jmsMsgProducer = null;
    private Session jmsSession = null;
    private QueueConnection jmsListenerQC = null;
    private QueueReceiver jmsListenerConsumer = null;
    private static Logger jmsLogger_ = null;

    private JMSRemoteMBeanServer(Domain domain) {
        try {
            jmsLogger_ = Logger.getLogger("oracle.j2ee.jmx.remote.jms");
            this.domain_ = domain;
            if (jmsLogger_.isLoggable(Level.FINE)) {
                jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> Creating JMS based JMX Connector " + this + " for domain " + this.domain_);
            }
            this.setUpEnvironment();
            domainToJMSRemoteMBeanServerAssociation_.put(this.domain_, this);
            domainToJMSRemoteMBeanServerAssociationRefCount_.put(this.domain_, new Integer(1));
            String queueCFStr = null;
            String topicCFStr = null;
            if (this.domain_ instanceof JMSiASDomain) {
                queueCFStr = ((JMSiASDomain)this.domain_).getQueueConnectionFactory();
                topicCFStr = ((JMSiASDomain)this.domain_).getTopicConnectionFactory();
            } else if (this.domain_ instanceof JMSOc4jDomain) {
                queueCFStr = ((JMSOc4jDomain)this.domain_).getQueueConnectionFactory();
                topicCFStr = ((JMSOc4jDomain)this.domain_).getTopicConnectionFactory();
            }
            XAQueueConnectionFactory queueCF = (XAQueueConnectionFactory)this.remoteOc4jContext_.lookup(queueCFStr);
            XATopicConnectionFactory topicCF = (XATopicConnectionFactory)this.remoteOc4jContext_.lookup(topicCFStr);
            this.jmsListenerQC = queueCF.createQueueConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
            QueueSession jmsListenerQS = this.jmsListenerQC.createQueueSession(false, 1);
            this.jmsListenerReplyToQueue = jmsListenerQS.createTemporaryQueue();
            this.jmsListenerConsumer = jmsListenerQS.createReceiver(this.jmsListenerReplyToQueue);
            this.jmsListener = new JMSreplyToQueueListener(this.domain_, jmsLogger_);
            this.jmsListenerConsumer.setMessageListener((MessageListener)this.jmsListener);
            this.jmsListenerQC.start();
            if (this.domain_ instanceof JMSiASDomain) {
                this.jmsDestination = (Topic)this.remoteOc4jContext_.lookup(((JMSiASDomain)this.domain_).getIASDomainTopic());
                this.topicConnection = topicCF.createTopicConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
                this.queueConnection = queueCF.createQueueConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
                this.jmsSession = this.topicConnection.createTopicSession(false, 1);
                this.jmsMsgProducer = ((TopicSession)this.jmsSession).createPublisher((Topic)this.jmsDestination);
                this.jmsMsgProducer.setDeliveryMode(2);
                QueueSession iasQueueSession = this.queueConnection.createQueueSession(false, 1);
                this.replyToQueue = iasQueueSession.createTemporaryQueue();
                this.queueReceiver = iasQueueSession.createReceiver(this.replyToQueue);
                this.topicConnection.start();
                this.queueConnection.start();
            } else if (this.domain_ instanceof JMSOc4jDomain) {
                this.queueConnection = queueCF.createQueueConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
                this.jmsDestination = (Queue)this.remoteOc4jContext_.lookup(((JMSOc4jDomain)this.domain_).getOc4jDomainQueue());
                this.jmsSession = this.queueConnection.createQueueSession(false, 1);
                this.jmsMsgProducer = ((QueueSession)this.jmsSession).createSender((Queue)this.jmsDestination);
                this.replyToQueue = this.jmsSession.createTemporaryQueue();
                this.queueReceiver = ((QueueSession)this.jmsSession).createReceiver(this.replyToQueue);
                this.queueConnection.start();
            }
            if (jmsLogger_.isLoggable(Level.FINE)) {
                jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> JMS listener started");
                jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> JMS based JMX Connector has been created");
            }
        }
        catch (Throwable e) {
            jmsLogger_.log(Level.WARNING, "JMS Connector: <JMSRemoteMBeanServer> Caught Exception " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteListenerId registerJMSListener(NotificationListener listener) {
        String string = jmsListenerLifeCycleLock_;
        synchronized (string) {
            try {
                ++jmsListenerRefCount_;
                if (jmsLogger_.isLoggable(Level.FINE)) {
                    jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> JMS listener reference count = " + jmsListenerRefCount_);
                }
                RemoteListenerId listenerId = ListenerIdManager.registerListener(listener, this.getDomain());
                return listenerId;
            }
            catch (Throwable e) {
                jmsLogger_.log(Level.WARNING, "JMS Connector: <JMSRemoteMBeanServer> Caught Exception " + e, e);
            }
        }
        return null;
    }

    private RemoteListenerId getListenerId(NotificationListener listener) {
        return ListenerIdManager.getListenerId(listener, this.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterJMSListener(NotificationListener listener) {
        String string = jmsListenerLifeCycleLock_;
        synchronized (string) {
            try {
                if (listener != null) {
                    ListenerIdManager.unregisterListener(listener, this.getDomain());
                    if (jmsListenerRefCount_ > 0) {
                        --jmsListenerRefCount_;
                    }
                    if (jmsLogger_.isLoggable(Level.FINE)) {
                        jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> Unregistering JMS listener, reference count = " + jmsListenerRefCount_);
                    }
                }
            }
            catch (Throwable e) {
                jmsLogger_.log(Level.WARNING, "JMS Connector: <JMSRemoteMBeanServer> Caught Exception " + e, e);
            }
        }
    }

    private void setUpEnvironment() {
        if (jmsLogger_.isLoggable(Level.FINE)) {
            jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> Getting remote JMS context for domain " + this.domain_);
        }
        Hashtable<String, String> environment = new Hashtable<String, String>();
        String url = "ormi://" + this.domain_.getHost() + ':' + this.domain_.getPort();
        environment.put("java.naming.provider.url", url);
        if (this.domain_.getPrincipal() != null && this.domain_.getCredential() != null) {
            environment.put("java.naming.security.principal", this.domain_.getPrincipal());
            environment.put("java.naming.security.credentials", this.domain_.getCredential());
        }
        environment.put("java.naming.factory.initial", "com.evermind.server.ApplicationClientInitialContextFactory");
        environment.put("application-client.xml", application_client_xml);
        try {
            this.remoteOc4jContext_ = new InitialContext(environment);
        }
        catch (Throwable e) {
            jmsLogger_.log(Level.WARNING, "JMS Connector: <JMSRemoteMBeanServer> Error while creating Initial Context for JMS destination lookup. Caught Exception " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connector getMBeanServer(Domain domain) {
        String string = lifeCycleLock_;
        synchronized (string) {
            JMSRemoteMBeanServer server = (JMSRemoteMBeanServer)domainToJMSRemoteMBeanServerAssociation_.get(domain);
            if (server == null) {
                server = new JMSRemoteMBeanServer(domain);
            } else {
                Integer refCount = (Integer)domainToJMSRemoteMBeanServerAssociationRefCount_.get(domain);
                domainToJMSRemoteMBeanServerAssociationRefCount_.put(domain, new Integer(refCount + 1));
                if (jmsLogger_.isLoggable(Level.FINE)) {
                    jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> Get JMSRemoteMBeanServer for domain " + domain + " Ref count is now: " + (refCount + 1));
                }
            }
            return server;
        }
    }

    public final Domain getDomain() {
        return this.domain_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        String string = lifeCycleLock_;
        synchronized (string) {
            Integer refCount = (Integer)domainToJMSRemoteMBeanServerAssociationRefCount_.get(this.domain_);
            if (jmsLogger_.isLoggable(Level.FINE)) {
                jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> Release call on JMSRemoteMBeanServer: " + this + " for domain " + this.domain_ + " Ref count is " + refCount);
            }
            if (refCount == 1) {
                domainToJMSRemoteMBeanServerAssociation_.remove(this.domain_);
                domainToJMSRemoteMBeanServerAssociationRefCount_.remove(this.domain_);
                try {
                    String methodName = "release";
                    MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, null, null, jmsLogger_, true);
                    JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
                    if (this.remoteOc4jContext_ != null) {
                        if (jmsLogger_.isLoggable(Level.FINE)) {
                            jmsLogger_.log(Level.FINE, "JMS Connector: <JMSRemoteMBeanServer> Call close on JMS Context");
                        }
                        this.remoteOc4jContext_.close();
                        this.remoteOc4jContext_ = null;
                    }
                }
                catch (Throwable e) {
                    jmsLogger_.log(Level.WARNING, "JMS Connector: <JMSRemoteMBeanServer> Caught Exception " + e, e);
                }
            } else {
                domainToJMSRemoteMBeanServerAssociationRefCount_.put(this.domain_, new Integer(refCount - 1));
            }
        }
    }

    public boolean supportDisconnectedMode() {
        return true;
    }

    public final void setJMXConnector(JMXConnector jmxcon) {
        this.jmxConnector_ = jmxcon;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature_, Locale locale) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            String methodName = "invoke";
            Object[] arguments = new Object[]{name, operationName, params, signature_, locale};
            String[] signature = new String[]{"javax.management.ObjectName", "java.lang.String", "[Ljava.lang.Object;", "[Ljava.lang.String;", "java.util.Locale"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof MBeanException) {
                        throw new MBeanException((MBeanException)returnException);
                    }
                    if (returnException instanceof ReflectionException) {
                        throw new ReflectionException((ReflectionException)returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (MBeanException e2) {
            throw new MBeanException(e2);
        }
        catch (ReflectionException e3) {
            throw new ReflectionException(e3);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Object getAttribute(ObjectName name, String attribute, Locale locale) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            String methodName = "getAttribute";
            Object[] arguments = new Object[]{name, attribute, locale};
            String[] signature = new String[]{"javax.management.ObjectName", "java.lang.String", "java.util.Locale"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof MBeanException) {
                        throw new MBeanException((MBeanException)returnException);
                    }
                    if (returnException instanceof ReflectionException) {
                        throw new ReflectionException((ReflectionException)returnException);
                    }
                    if (returnException instanceof AttributeNotFoundException) {
                        throw new AttributeNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (MBeanException e2) {
            throw new MBeanException(e2);
        }
        catch (ReflectionException e3) {
            throw new ReflectionException(e3);
        }
        catch (AttributeNotFoundException e4) {
            throw (AttributeNotFoundException)new AttributeNotFoundException().initCause(e4);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes, Locale locale) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            String methodName = "getAttributes";
            Object[] arguments = new Object[]{name, attributes, locale};
            String[] signature = new String[]{"javax.management.ObjectName", "[Ljava.lang.String;", "java.util.Locale"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof ReflectionException) {
                        throw new ReflectionException((ReflectionException)returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (AttributeList)returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (ReflectionException e2) {
            throw new ReflectionException(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void setLocale(Locale locale) throws IOException {
        try {
            String methodName = "setLocale";
            Object[] arguments = new Object[]{locale};
            String[] signature = new String[]{"java.util.Locale"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Locale getLocale() throws IOException {
        try {
            String methodName = "getLocale";
            Object[] arguments = new Object[]{};
            String[] signature = new String[]{};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (Locale)returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            RemoteListenerId listenerId = this.registerJMSListener(listener);
            String methodName = "addNotificationListener";
            Object[] arguments = new Object[]{name, listenerId, filter, handback, this.jmsListenerReplyToQueue};
            String[] signature = new String[]{"javax.management.ObjectName", "oracle.oc4j.admin.jmx.shared.RemoteListenerId", "javax.management.NotificationFilter", "java.lang.Object", "javax.jms.Queue"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            String methodName = "addNotificationListener";
            Object[] arguments = new Object[]{name, listener, filter, handback};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.ObjectName", "javax.management.NotificationFilter", "java.lang.Object"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("This part of the API is not supported");
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.getAttribute(name, attribute, this.domain_.getLocale());
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.getAttributes(name, attributes, this.domain_.getLocale());
    }

    public String getDefaultDomain() throws IOException {
        try {
            String methodName = "getDefaultDomain";
            Object[] arguments = new Object[]{};
            String[] signature = new String[]{};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (String)returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String[] getDomains() throws IOException {
        try {
            String methodName = "getDomains";
            Object[] arguments = new Object[]{};
            String[] signature = new String[]{};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (String[])returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Integer getMBeanCount() throws IOException {
        try {
            String methodName = "getMBeanCount";
            Object[] arguments = new Object[]{};
            String[] signature = new String[]{};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (Integer)returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            String methodName = "getMBeanInfo";
            Object[] arguments = new Object[]{name};
            String[] signature = new String[]{"javax.management.ObjectName"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof IntrospectionException) {
                        throw new IntrospectionException().initCause(returnException);
                    }
                    if (returnException instanceof ReflectionException) {
                        throw new ReflectionException((ReflectionException)returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (MBeanInfo)returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (IntrospectionException e2) {
            throw (IntrospectionException)new IntrospectionException().initCause(e2);
        }
        catch (ReflectionException e3) {
            throw new ReflectionException(e3);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        try {
            String methodName = "getObjectInstance";
            Object[] arguments = new Object[]{name};
            String[] signature = new String[]{"javax.management.ObjectName"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (ObjectInstance)returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature_) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.invoke(name, operationName, params, signature_, this.domain_.getLocale());
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        try {
            String methodName = "isInstanceOf";
            Object[] arguments = new Object[]{name, className};
            String[] signature = new String[]{"javax.management.ObjectName", "java.lang.String"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (Boolean)returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        try {
            String methodName = "isRegistered";
            Object[] arguments = new Object[]{name};
            String[] signature = new String[]{"javax.management.ObjectName"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (Boolean)returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        try {
            String methodName = "queryMBeans";
            Object[] arguments = new Object[]{name, query};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.QueryExp"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (Set)returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        try {
            String methodName = "queryNames";
            Object[] arguments = new Object[]{name, query};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.QueryExp"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (Set)returnValue;
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            RemoteListenerId listenerId = this.getListenerId(listener);
            String methodName = "removeNotificationListener";
            Object[] arguments = new Object[]{name, listenerId};
            String[] signature = new String[]{"javax.management.ObjectName", "oracle.oc4j.admin.jmx.shared.RemoteListenerId"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof ListenerNotFoundException) {
                        throw new ListenerNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
            this.unregisterJMSListener(listener);
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (ListenerNotFoundException e2) {
            throw (ListenerNotFoundException)new ListenerNotFoundException().initCause(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            String methodName = "removeNotificationListener";
            Object[] arguments = new Object[]{name, listener};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.ObjectName"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof ListenerNotFoundException) {
                        throw new ListenerNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (ListenerNotFoundException e2) {
            throw (ListenerNotFoundException)new ListenerNotFoundException().initCause(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            RemoteListenerId listenerId = this.getListenerId(listener);
            String methodName = "removeNotificationListener";
            Object[] arguments = new Object[]{name, listenerId, filter, handback};
            String[] signature = new String[]{"javax.management.ObjectName", "oracle.oc4j.admin.jmx.shared.RemoteListenerId", "javax.management.NotificationFilter", "java.lang.Object"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_, true);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof ListenerNotFoundException) {
                        throw new ListenerNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
            this.unregisterJMSListener(listener);
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (ListenerNotFoundException e2) {
            throw (ListenerNotFoundException)new ListenerNotFoundException().initCause(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            String methodName = "removeNotificationListener";
            Object[] arguments = new Object[]{name, listener, filter, handback};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.ObjectName", "javax.management.NotificationFilter", "java.lang.Object"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof ListenerNotFoundException) {
                        throw new ListenerNotFoundException().initCause(returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (ListenerNotFoundException e2) {
            throw (ListenerNotFoundException)new ListenerNotFoundException().initCause(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            String methodName = "setAttribute";
            Object[] arguments = new Object[]{name, attribute};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.Attribute"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof AttributeNotFoundException) {
                        throw new AttributeNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof InvalidAttributeValueException) {
                        throw new InvalidAttributeValueException().initCause(returnException);
                    }
                    if (returnException instanceof MBeanException) {
                        throw new MBeanException((MBeanException)returnException);
                    }
                    if (returnException instanceof ReflectionException) {
                        throw new ReflectionException((ReflectionException)returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (AttributeNotFoundException e2) {
            throw (AttributeNotFoundException)new AttributeNotFoundException().initCause(e2);
        }
        catch (InvalidAttributeValueException e3) {
            throw (InvalidAttributeValueException)new InvalidAttributeValueException().initCause(e3);
        }
        catch (MBeanException e4) {
            throw new MBeanException(e4);
        }
        catch (ReflectionException e5) {
            throw new ReflectionException(e5);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            String methodName = "setAttributes";
            Object[] arguments = new Object[]{name, attributes};
            String[] signature = new String[]{"javax.management.ObjectName", "javax.management.AttributeList"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            Object returnValue = null;
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof ReflectionException) {
                        throw new ReflectionException((ReflectionException)returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
                returnValue = remoteObject.getReturnValue();
            }
            return (AttributeList)returnValue;
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (ReflectionException e2) {
            throw new ReflectionException(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            String methodName = "unregisterMBean";
            Object[] arguments = new Object[]{name};
            String[] signature = new String[]{"javax.management.ObjectName"};
            MBeanServerConnectionCaller mbeanServerMethod = new MBeanServerConnectionCaller(this.domain_, methodName, signature, arguments, jmsLogger_);
            JMSRemoteObject remoteObject = mbeanServerMethod.remoteExecute(this.remoteOc4jContext_, this.replyToQueue, this.queueReceiver, this.jmsMsgProducer, this.jmsSession);
            if (remoteObject != null) {
                Throwable internalException = remoteObject.getInternalException();
                Throwable returnException = remoteObject.getReturnException();
                if (internalException != null) {
                    throw new IOException().initCause(internalException);
                }
                if (returnException != null) {
                    if (returnException instanceof InstanceNotFoundException) {
                        throw new InstanceNotFoundException().initCause(returnException);
                    }
                    if (returnException instanceof MBeanRegistrationException) {
                        throw new MBeanRegistrationException((MBeanRegistrationException)returnException);
                    }
                    throw new IOException().initCause(returnException);
                }
            }
        }
        catch (InstanceNotFoundException e1) {
            throw (InstanceNotFoundException)new InstanceNotFoundException().initCause(e1);
        }
        catch (MBeanRegistrationException e2) {
            throw new MBeanRegistrationException(e2);
        }
        catch (Throwable e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

