/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodsConfigType;

public class SignatureMethodsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SignatureMethodsConfigType _bean;
    private static final String ADD_SIGNATURE_METHOD_MENU_STRING = "Add Signature Method";
    private static final String REMOVE_SIGNATURE_METHODS_MENU_STRING = "Remove Signature Methods";
    private JMenuItem _addSignatureMethodMenuItem;
    private JMenuItem _removeSignatureMethodsMenuItem;

    public SignatureMethodsTreeNode(ConfigTreeNode rootNode, SignatureMethodsConfigType signatureMethods) {
        super(signatureMethods);
        this.setRootNode(rootNode);
        this._bean = signatureMethods;
        this._addSignatureMethodMenuItem = new JMenuItem(ADD_SIGNATURE_METHOD_MENU_STRING);
        this._addSignatureMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSignatureMethodMenuItem.setFont(SignatureMethodsTreeNode.getFont());
        this._addSignatureMethodMenuItem.addActionListener(this);
        this._removeSignatureMethodsMenuItem = new JMenuItem(REMOVE_SIGNATURE_METHODS_MENU_STRING);
        this._removeSignatureMethodsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSignatureMethodsMenuItem.setFont(SignatureMethodsTreeNode.getFont());
        this._removeSignatureMethodsMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addSignatureMethodMenuItem);
        this._popup.add(this._removeSignatureMethodsMenuItem);
    }

    public String viewHeaderString() {
        return "Signature Methods";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        SignatureMethodConfigType[] signatureMethods = this._bean.getSignatureMethods();
        if (signatureMethods != null) {
            for (int i = 0; i < signatureMethods.length; ++i) {
                SignatureMethodConfigType signatureMethod = signatureMethods[i];
                if (signatureMethod == null) continue;
                SignatureMethodTreeNode signatureMethodTreeNode = new SignatureMethodTreeNode(this.getRootNode(), signatureMethod);
                this.addChild(signatureMethodTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SIGNATURE_METHOD_MENU_STRING)) {
                SignatureMethodConfigType newSignatureMethod = new SignatureMethodConfigType(this._bean);
                if (this.showAddDialog(newSignatureMethod, ADD_SIGNATURE_METHOD_MENU_STRING)) {
                    this._bean.addSignatureMethod(newSignatureMethod);
                    SignatureMethodTreeNode newNode = new SignatureMethodTreeNode(this, newSignatureMethod);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_SIGNATURE_METHODS_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SignatureMethodTreeNode) {
            SignatureMethodConfigType signatureMethod = (SignatureMethodConfigType)node.getConfigBeanNode();
            this._bean.removeSignatureMethod(signatureMethod);
            this.removeNode(node);
        }
    }
}

