/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.IntegerType;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackerType;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionTrackingType
extends ConfigBeanNode {
    SessionTrackerType[] _sessionTrackers = null;
    BooleanType _autoJoinSession = null;
    BooleanType _oldAutoJoinSession = null;
    String _cookieDomain = null;
    String _cookiePath = null;
    IntegerType _cookieMaxAge = null;
    IntegerType _oldCookieMaxAge = null;
    StringType _cookies = null;
    StringType _oldCookies = null;
    BooleanType _setSecure = null;
    BooleanType _oldSetSecure = null;
    BooleanType _urlRewriting = null;
    BooleanType _oldURLRewriting = null;

    public SessionTrackingType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public SessionTrackingType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setAutoJoinSession(BooleanType autoJoinSession) throws ConfigurationException {
        this._autoJoinSession = autoJoinSession;
        this.firePropertyChange("autoJoinSession", this._oldAutoJoinSession, this._autoJoinSession);
        if (this._autoJoinSession != null) {
            if (this._oldAutoJoinSession == null) {
                this._oldAutoJoinSession = this.defaultAutoJoinSession();
            }
            this._oldAutoJoinSession.setValue(this._autoJoinSession.getValue());
        } else {
            this._oldAutoJoinSession = null;
        }
    }

    public BooleanType getAutoJoinSession() {
        return this._autoJoinSession;
    }

    public BooleanType defaultAutoJoinSession() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setCookieDomain(String cookieDomain) throws ConfigurationException {
        String oldValue = this._cookieDomain;
        this._cookieDomain = cookieDomain;
        this.firePropertyChange("cookieDomain", oldValue, this._cookieDomain);
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public String defaultCookieDomain() {
        return "";
    }

    public void setCookiePath(String cookiePath) throws ConfigurationException {
        String oldValue = this._cookiePath;
        this._cookiePath = cookiePath;
        this.firePropertyChange("cookiePath", oldValue, this._cookiePath);
    }

    public String getCookiePath() {
        return this._cookiePath;
    }

    public String defaultCookiePath() {
        return "";
    }

    public void setCookieMaxAge(IntegerType cookieMaxAge) throws ConfigurationException {
        this._cookieMaxAge = cookieMaxAge;
        this.firePropertyChange("cookieMaxAge", this._oldCookieMaxAge, this._cookieMaxAge);
        if (this._cookieMaxAge != null) {
            if (this._oldCookieMaxAge == null) {
                this._oldCookieMaxAge = this.defaultCookieMaxAge();
            }
            this._oldCookieMaxAge.setValue(this._cookieMaxAge.getValue());
        } else {
            this._oldCookieMaxAge = null;
        }
    }

    public IntegerType getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public IntegerType defaultCookieMaxAge() {
        try {
            return new IntegerType(this, "0");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setCookies(StringType cookies) throws ConfigurationException {
        this._cookies = cookies;
        this.firePropertyChange("cookies", this._oldCookies, this._cookies);
        if (this._cookies != null) {
            if (this._oldCookies == null) {
                this._oldCookies = this.defaultCookies();
            }
            this._oldCookies.setValue(this._cookies.getValue());
        } else {
            this._oldCookies = null;
        }
    }

    public StringType getCookies() {
        return this._cookies;
    }

    public StringType defaultCookies() {
        String[] tags = new String[]{"enabled", "disabled"};
        return new StringType(this, tags, "enabled");
    }

    public void setSessionTrackers(SessionTrackerType[] sessionTrackers) throws ConfigurationException {
        SessionTrackerType[] oldValue = this._sessionTrackers;
        this._sessionTrackers = sessionTrackers;
        this.firePropertyChange("sessionTrackers", oldValue, this._sessionTrackers);
    }

    public SessionTrackerType[] getSessionTrackers() {
        return this._sessionTrackers;
    }

    public SessionTrackerType[] defaultSessionTrackers() {
        return new SessionTrackerType[0];
    }

    public void addSessionTrackers() throws ConfigurationException {
        if (this._sessionTrackers != null) {
            return;
        }
        SessionTrackerType[] sessionTrackers = new SessionTrackerType[]{new SessionTrackerType(this, null)};
        this.setSessionTrackers(sessionTrackers);
    }

    public void removeSessionTrackers() throws ConfigurationException {
        if (this._sessionTrackers == null) {
            return;
        }
        this.setSessionTrackers(null);
    }

    public void addSessionTracker(SessionTrackerType sessionTracker) throws ConfigurationException {
        sessionTracker.setParent(this);
        int existingSessionTrackersCnt = 0;
        if (this._sessionTrackers != null) {
            existingSessionTrackersCnt = this._sessionTrackers.length;
        }
        SessionTrackerType[] newSessionTrackers = new SessionTrackerType[existingSessionTrackersCnt + 1];
        for (int n = 0; n < existingSessionTrackersCnt; ++n) {
            newSessionTrackers[n] = this._sessionTrackers[n];
        }
        newSessionTrackers[existingSessionTrackersCnt] = sessionTracker;
        SessionTrackerType[] oldValue = this._sessionTrackers;
        this._sessionTrackers = newSessionTrackers;
        this.firePropertyChange("sessionTrackers", oldValue, this._sessionTrackers);
    }

    public void removeSessionTracker(SessionTrackerType sessionTracker) throws ConfigurationException {
        int existingSessionTrackersCnt = 0;
        if (this._sessionTrackers != null) {
            existingSessionTrackersCnt = this._sessionTrackers.length;
        }
        SessionTrackerType[] newSessionTrackers = new SessionTrackerType[existingSessionTrackersCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingSessionTrackersCnt; ++n) {
            if (sessionTracker.equals(this._sessionTrackers[n])) continue;
            newSessionTrackers[newIndex++] = this._sessionTrackers[n];
        }
        if (newSessionTrackers.length == 0) {
            newSessionTrackers = null;
        }
        SessionTrackerType[] oldValue = this._sessionTrackers;
        this._sessionTrackers = newSessionTrackers;
        this.firePropertyChange("sessionTrackers", oldValue, this._sessionTrackers);
    }

    public void setSetSecure(BooleanType setSecure) throws ConfigurationException {
        this._setSecure = setSecure;
        this.firePropertyChange("setSecure", this._oldSetSecure, this._setSecure);
        if (this._setSecure != null) {
            if (this._oldSetSecure == null) {
                this._oldSetSecure = this.defaultSetSecure();
            }
            this._oldSetSecure.setValue(this._setSecure.getValue());
        } else {
            this._oldSetSecure = null;
        }
    }

    public BooleanType getSetSecure() {
        return this._setSecure;
    }

    public BooleanType defaultSetSecure() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setURLRewriting(BooleanType urlRewriting) throws ConfigurationException {
        this._urlRewriting = urlRewriting;
        this.firePropertyChange("urlRewriting", this._oldURLRewriting, this._urlRewriting);
        if (this._urlRewriting != null) {
            if (this._oldURLRewriting == null) {
                this._oldURLRewriting = this.defaultURLRewriting();
            }
            this._oldURLRewriting.setValue(this._urlRewriting.getValue());
        } else {
            this._oldURLRewriting = null;
        }
    }

    public BooleanType getURLRewriting() {
        return this._urlRewriting;
    }

    public BooleanType defaultURLRewriting() {
        try {
            return new BooleanType(this, "true");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "session-tracking");
        XMLUtils.writeAttribute(out, indentation, "autojoin-session", this._autoJoinSession);
        XMLUtils.writeAttribute(out, indentation, "cookie-domain", this._cookieDomain);
        XMLUtils.writeAttribute(out, indentation, "cookie-path", this._cookiePath);
        XMLUtils.writeAttribute(out, indentation, "cookie-max-age", this._cookieMaxAge);
        XMLUtils.writeAttribute(out, indentation, "cookies", this._cookies);
        XMLUtils.writeAttribute(out, indentation, "set-secure", this._setSecure);
        XMLUtils.writeAttribute(out, indentation, "url-rewriting", this._urlRewriting);
        XMLUtils.writeTagAttributeEnd(out, indentation, "session-tracking");
        SessionTrackingType.writeXML(out, indentation + "\t", this._sessionTrackers);
        XMLUtils.writeTagEnd(out, indentation, "session-tracking");
    }

    private void init() throws ConfigurationException {
        this.setXpath("session-tracking");
        Vector<SessionTrackerType> sessionTrackers = new Vector<SessionTrackerType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "autojoin-session");
            if (val != null && !val.trim().equals("")) {
                BooleanType autoJoinSession = this.defaultAutoJoinSession();
                autoJoinSession.setValue(val);
                this.setAutoJoinSession(autoJoinSession);
            }
            if ((val = XMLUtils.getAttribute(node, "cookie-domain")) != null && !val.trim().equals("")) {
                this.setCookieDomain(val);
            }
            if ((val = XMLUtils.getAttribute(node, "cookie-path")) != null && !val.trim().equals("")) {
                this.setCookiePath(val);
            }
            if ((val = XMLUtils.getAttribute(node, "cookie-max-age")) != null && !val.trim().equals("")) {
                IntegerType cookieMaxAge = this.defaultCookieMaxAge();
                cookieMaxAge.setValue(val);
                this.setCookieMaxAge(cookieMaxAge);
            }
            if ((val = XMLUtils.getAttribute(node, "cookies")) != null && !val.trim().equals("")) {
                StringType cookies = this.defaultCookies();
                cookies.setValue(val);
                this.setCookies(cookies);
            }
            if ((val = XMLUtils.getAttribute(node, "set-secure")) != null && !val.trim().equals("")) {
                BooleanType setSecure = this.defaultSetSecure();
                setSecure.setValue(val);
                this.setSetSecure(setSecure);
            }
            if ((val = XMLUtils.getAttribute(node, "url-rewriting")) != null && !val.trim().equals("")) {
                BooleanType urlRewriting = this.defaultURLRewriting();
                urlRewriting.setValue(val);
                this.setURLRewriting(urlRewriting);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("session-tracker")) continue;
                SessionTrackerType configBean = new SessionTrackerType(this, node);
                sessionTrackers.add(configBean);
            }
        }
        if (sessionTrackers.size() > 0) {
            this.setSessionTrackers(sessionTrackers.toArray(new SessionTrackerType[0]));
        }
    }

    public void writeSessionTrackersXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        SessionTrackingType.writeXML(out, indentation, this._sessionTrackers);
    }
}

