/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackersTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackingType;

public class SessionTrackingTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SessionTrackingType _bean;
    private static final String REMOVE_SESSION_TRACKING_MENU_STRING = "Remove Session Tracking";
    private JMenuItem _removeSessionTrackingMenuItem;

    public SessionTrackingTreeNode(ConfigTreeNode rootNode, SessionTrackingType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._removeSessionTrackingMenuItem = new JMenuItem(REMOVE_SESSION_TRACKING_MENU_STRING);
        this._removeSessionTrackingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSessionTrackingMenuItem.setFont(SessionTrackingTreeNode.getFont());
        this._removeSessionTrackingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeSessionTrackingMenuItem);
    }

    public String viewHeaderString() {
        return "Session Tracking";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = SessionTrackingType.class.getMethod("writeSessionTrackersXML", PrintWriter.class, String.class);
            SessionTrackersTreeNode sessionTrackersTreeNode = new SessionTrackersTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(sessionTrackersTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_SESSION_TRACKING_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

