/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackerTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackerType;

public class SessionTrackersTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_SESSION_TRACKER_MENU_STRING = "Add Session Tracker";
    private JMenuItem _addSessionTrackerMenuItem;
    private SessionTrackerType[] sessionTrackerType = new SessionTrackerType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public SessionTrackersTreeNode(ConfigTreeNode rootNode, MultipleType sessionTrackers) {
        super(sessionTrackers);
        this.setRootNode(rootNode);
        this._parentBean = sessionTrackers.getConfigParent();
        this._addSessionTrackerMenuItem = new JMenuItem(ADD_SESSION_TRACKER_MENU_STRING);
        this._addSessionTrackerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSessionTrackerMenuItem.setFont(SessionTrackersTreeNode.getFont());
        this._addSessionTrackerMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addSessionTrackerMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getSessionTrackers", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addSessionTracker", SessionTrackerType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeSessionTracker", SessionTrackerType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Session Trackers";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            SessionTrackerType[] sessionTrackers = (SessionTrackerType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (sessionTrackers != null) {
                for (int i = 0; i < sessionTrackers.length; ++i) {
                    SessionTrackerType sessionTracker = sessionTrackers[i];
                    if (sessionTracker == null) continue;
                    SessionTrackerTreeNode sessionTrackerTreeNode = new SessionTrackerTreeNode(this.getRootNode(), sessionTracker);
                    this.addChild(sessionTrackerTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            SessionTrackerType newsessionTracker;
            if (event.getActionCommand().equals(ADD_SESSION_TRACKER_MENU_STRING) && this.showAddDialog(newsessionTracker = new SessionTrackerType(this._parentBean), ADD_SESSION_TRACKER_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newsessionTracker);
                SessionTrackerTreeNode newNode = new SessionTrackerTreeNode(this, newsessionTracker);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SessionTrackerTreeNode) {
            try {
                SessionTrackerType sessionTracker = (SessionTrackerType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, sessionTracker);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

