/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.model.xml.SessionBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.DeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.IntegerType;
import oracle.oc4j.admin.deploy.spi.xml.IorSecurityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SessionMappingsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionDeploymentConfigBean
extends DeploymentConfigBean {
    IntegerType _timeout = null;
    IntegerType _oldTimeout = null;
    IntegerType _idleTime = null;
    IntegerType _oldIdleTime = null;
    IntegerType _memoryThreshold = null;
    IntegerType _oldMemoryThreshold = null;
    IntegerType _maxInstancesThreshold = null;
    IntegerType _oldMaxInstancesThreshold = null;
    IntegerType _resourceCheckInterval = null;
    IntegerType _oldResourceCheckInterval = null;
    IntegerType _passivateCount = null;
    IntegerType _oldPassivateCount = null;
    String _persistenceFilename = null;
    StringType _replication = null;
    StringType _oldReplication = null;
    IorSecurityConfigType[] _iorSecurityConfigs = null;
    StringType _interceptorType = null;
    StringType _oldInterceptorType = null;
    IntegerType transactionTimeout_ = null;
    IntegerType oldTransactionTimeout_ = null;

    public SessionDeploymentConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public SessionDeploymentConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setTimeout(IntegerType timeout) throws ConfigurationException {
        this._timeout = timeout;
        this.firePropertyChange("timeout", this._oldTimeout, this._timeout);
        if (this._timeout != null) {
            if (this._oldTimeout == null) {
                this._oldTimeout = this.defaultTimeout();
            }
            this._oldTimeout.setValue(this._timeout.getValue());
        } else {
            this._oldTimeout = null;
        }
    }

    public IntegerType getTimeout() {
        return this._timeout;
    }

    public IntegerType defaultTimeout() {
        try {
            return new IntegerType(this, "1800");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setIdleTime(IntegerType idleTime) throws ConfigurationException {
        this._idleTime = idleTime;
        this.firePropertyChange("idleTime", this._oldIdleTime, this._idleTime);
        if (this._idleTime != null) {
            if (this._oldIdleTime == null) {
                this._oldIdleTime = this.defaultIdleTime();
            }
            this._oldIdleTime.setValue(this._idleTime.getValue());
        } else {
            this._oldIdleTime = null;
        }
    }

    public IntegerType getIdleTime() {
        return this._idleTime;
    }

    public IntegerType defaultIdleTime() {
        try {
            return new IntegerType(this, "300");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setMemoryThreshold(IntegerType memoryThreshold) throws ConfigurationException {
        this._memoryThreshold = memoryThreshold;
        this.firePropertyChange("memoryThreshold", this._oldMemoryThreshold, this._memoryThreshold);
        if (this._memoryThreshold != null) {
            if (this._oldMemoryThreshold == null) {
                this._oldMemoryThreshold = this.defaultMemoryThreshold();
            }
            this._oldMemoryThreshold.setValue(this._memoryThreshold.getValue());
        } else {
            this._oldMemoryThreshold = null;
        }
    }

    public IntegerType getMemoryThreshold() {
        return this._memoryThreshold;
    }

    public IntegerType defaultMemoryThreshold() {
        try {
            return new IntegerType(this, "80");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setMaxInstancesThreshold(IntegerType maxInstancesThreshold) throws ConfigurationException {
        this._maxInstancesThreshold = maxInstancesThreshold;
        this.firePropertyChange("maxInstancesThreshold", this._oldMaxInstancesThreshold, this._maxInstancesThreshold);
        if (this._maxInstancesThreshold != null) {
            if (this._oldMaxInstancesThreshold == null) {
                this._oldMaxInstancesThreshold = this.defaultMaxInstancesThreshold();
            }
            this._oldMaxInstancesThreshold.setValue(this._maxInstancesThreshold.getValue());
        } else {
            this._oldMaxInstancesThreshold = null;
        }
    }

    public IntegerType getMaxInstancesThreshold() {
        return this._maxInstancesThreshold;
    }

    public IntegerType defaultMaxInstancesThreshold() {
        try {
            return new IntegerType(this, "90");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setResourceCheckInterval(IntegerType resourceCheckInterval) throws ConfigurationException {
        this._resourceCheckInterval = resourceCheckInterval;
        this.firePropertyChange("resourceCheckInterval", this._oldResourceCheckInterval, this._resourceCheckInterval);
        if (this._resourceCheckInterval != null) {
            if (this._oldResourceCheckInterval == null) {
                this._oldResourceCheckInterval = this.defaultResourceCheckInterval();
            }
            this._oldResourceCheckInterval.setValue(this._resourceCheckInterval.getValue());
        } else {
            this._oldResourceCheckInterval = null;
        }
    }

    public IntegerType getResourceCheckInterval() {
        return this._resourceCheckInterval;
    }

    public IntegerType defaultResourceCheckInterval() {
        try {
            return new IntegerType(this, "180");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setPassivateCount(IntegerType passivateCount) throws ConfigurationException {
        this._passivateCount = passivateCount;
        this.firePropertyChange("passivateCount", this._oldPassivateCount, this._passivateCount);
        if (this._passivateCount != null) {
            if (this._oldPassivateCount == null) {
                this._oldPassivateCount = this.defaultPassivateCount();
            }
            this._oldPassivateCount.setValue(this._passivateCount.getValue());
        } else {
            this._oldPassivateCount = null;
        }
    }

    public IntegerType getPassivateCount() {
        return this._passivateCount;
    }

    public IntegerType defaultPassivateCount() {
        try {
            return new IntegerType(this, "-1");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setPersistenceFilename(String persistenceFilename) throws ConfigurationException {
        String oldValue = this._persistenceFilename;
        this._persistenceFilename = persistenceFilename;
        this.firePropertyChange("persistenceFilename", oldValue, this._persistenceFilename);
    }

    public String getPersistenceFilename() {
        return this._persistenceFilename;
    }

    public String defaultPersistenceFilename() {
        return "";
    }

    public void setReplication(StringType replication) throws ConfigurationException {
        this._replication = replication;
        this.firePropertyChange("replication", this._oldReplication, this._replication);
        if (this._replication != null) {
            if (this._oldReplication == null) {
                this._oldReplication = this.defaultReplication();
            }
            this._oldReplication.setValue(this._replication.getValue());
        } else {
            this._oldReplication = null;
        }
    }

    public StringType getReplication() {
        return this._replication;
    }

    public StringType defaultReplication() {
        String[] tags = new String[]{"onRequestEnd", "onShutdown", "none"};
        return new StringType(this, tags, "none");
    }

    public void setInterceptorType(StringType interceptorType) throws ConfigurationException {
        this._interceptorType = interceptorType;
        this.firePropertyChange("interceptorType", this._oldInterceptorType, this._interceptorType);
        if (this._interceptorType != null) {
            if (this._oldInterceptorType == null) {
                this._oldInterceptorType = this.defaultInterceptorType();
            }
            this._oldInterceptorType.setValue(this._interceptorType.getValue());
        } else {
            this._oldInterceptorType = null;
        }
    }

    public StringType getInterceptorType() {
        return this._interceptorType;
    }

    public StringType defaultInterceptorType() {
        String[] tags = new String[]{"bean", "singleton", ""};
        return new StringType(this, tags, "");
    }

    public void setTransactionTimeout(IntegerType transactionTimeout) throws ConfigurationException {
        this.transactionTimeout_ = transactionTimeout;
        this.firePropertyChange("transaction-timeout", this.oldTransactionTimeout_, this.transactionTimeout_);
        if (this.transactionTimeout_ != null) {
            if (this.oldTransactionTimeout_ == null) {
                this.oldTransactionTimeout_ = this.defaultTransactionTimeout();
            }
            this.oldTransactionTimeout_.setValue(this.transactionTimeout_.getValue());
        } else {
            this.oldTransactionTimeout_ = null;
        }
    }

    public IntegerType getTransactionTimeout() {
        return this.transactionTimeout_;
    }

    public IntegerType defaultTransactionTimeout() {
        try {
            return new IntegerType(this, "-1");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        boolean stateful = true;
        DDBean stdBean = this.getDDBean();
        if (stdBean != null && stdBean instanceof SessionBean && !"Stateful".equals(((SessionBean)stdBean).getSessionType())) {
            stateful = false;
        }
        XMLUtils.writeTagAttributeStart(out, indentation, "session-deployment");
        XMLUtils.writeAttribute(out, indentation, "pool-cache-timeout", this._poolCacheTimeout);
        XMLUtils.writeAttribute(out, indentation, "call-timeout", this._callTimeout);
        XMLUtils.writeAttribute(out, indentation, "copy-by-value", this._copyByValue);
        XMLUtils.writeAttribute(out, indentation, "transaction-timeout", this.transactionTimeout_);
        XMLUtils.writeAttribute(out, indentation, "location", this._location);
        XMLUtils.writeAttribute(out, indentation, "local-location", this._localLocation);
        XMLUtils.writeAttribute(out, indentation, "max-instances", this._maxInstances);
        XMLUtils.writeAttribute(out, indentation, "min-instances", this._minInstances);
        XMLUtils.writeAttribute(out, indentation, "max-tx-retries", this._maxTxRetries);
        XMLUtils.writeAttribute(out, indentation, "tx-retry-wait", this._txRetryWait);
        XMLUtils.writeAttribute(out, indentation, "name", this._name);
        if (stateful) {
            XMLUtils.writeAttribute(out, indentation, "timeout", this._timeout);
        }
        if (stateful) {
            XMLUtils.writeAttribute(out, indentation, "idletime", this._idleTime);
        }
        if (stateful) {
            XMLUtils.writeAttribute(out, indentation, "memory-threshold", this._memoryThreshold);
        }
        if (stateful) {
            XMLUtils.writeAttribute(out, indentation, "max-instances-threshold", this._maxInstancesThreshold);
        }
        if (stateful) {
            XMLUtils.writeAttribute(out, indentation, "resource-check-interval", this._resourceCheckInterval);
        }
        if (stateful) {
            XMLUtils.writeAttribute(out, indentation, "passivate-count", this._passivateCount);
        }
        XMLUtils.writeAttribute(out, indentation, "persistence-filename", this._persistenceFilename);
        XMLUtils.writeAttribute(out, indentation, "replication", this._replication);
        XMLUtils.writeAttribute(out, indentation, "interceptor-type", this._interceptorType);
        XMLUtils.writeTagAttributeEnd(out, indentation, "session-deployment");
        IorSecurityConfigType.writeXML(out, indentation + "\t", this._iorSecurityConfigs);
        SessionDeploymentConfigBean.writeAll(this.getChildBean("env-entry-mapping"), out, indentation + "\t");
        SessionDeploymentConfigBean.writeAll(this.getChildBean("ejb-ref-mapping"), out, indentation + "\t");
        SessionDeploymentConfigBean.writeAll(this.getChildBean("service-ref-mapping"), out, indentation + "\t");
        SessionDeploymentConfigBean.writeAll(this.getChildBean("resource-ref-mapping"), out, indentation + "\t");
        SessionDeploymentConfigBean.writeAll(this.getChildBean("resource-env-ref-mapping"), out, indentation + "\t");
        SessionDeploymentConfigBean.writeAll(this.getChildBean("message-destination-ref-mapping"), out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "session-deployment");
    }

    public void writeIorSecurityConfigsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        IorSecurityConfigType.writeXML(out, indentation, this._iorSecurityConfigs);
    }

    public String thisXpath() {
        this._xpaths = new String[7];
        this._xpaths[0] = "resource-ref";
        this._xpaths[1] = "resource-env-ref";
        this._xpaths[2] = "ejb-ref";
        this._xpaths[3] = "ejb-local-ref";
        this._xpaths[4] = "env-entry";
        this._xpaths[5] = "service-ref";
        this._xpaths[6] = "message-destination-ref";
        this._configXpaths = new String[7];
        this._configXpaths[0] = "resource-ref-mapping";
        this._configXpaths[1] = "resource-env-ref-mapping";
        this._configXpaths[2] = "ejb-ref-mapping";
        this._configXpaths[3] = "ejb-ref-mapping";
        this._configXpaths[4] = "env-entry-mapping";
        this._configXpaths[5] = "service-ref-mapping";
        this._configXpaths[6] = "message-destination-ref-mapping";
        return "enterprise-beans/session-deployment";
    }

    private void init() throws ConfigurationException {
        Vector<IorSecurityConfigType> iorSecurityConfigs = new Vector<IorSecurityConfigType>();
        if (this.getNode() != null) {
            String val = null;
            Object intVal = null;
            Object longVal = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "timeout");
            if (val != null && !val.trim().equals("")) {
                IntegerType timeout = this.defaultTimeout();
                if (val.equalsIgnoreCase("never")) {
                    timeout.setValue("-1");
                } else {
                    timeout.setValue(val);
                }
                this.setTimeout(timeout);
            }
            if ((val = XMLUtils.getAttribute(node, "idletime")) != null && !val.trim().equals("")) {
                IntegerType idleTime = this.defaultIdleTime();
                if (val.equalsIgnoreCase("never")) {
                    idleTime.setValue("-1");
                } else {
                    idleTime.setValue(val);
                }
                this.setIdleTime(idleTime);
            }
            if ((val = XMLUtils.getAttribute(node, "memory-threshold")) != null && !val.trim().equals("")) {
                IntegerType memoryThreshold = this.defaultMemoryThreshold();
                if (val.equalsIgnoreCase("never")) {
                    memoryThreshold.setValue("-1");
                } else {
                    memoryThreshold.setValue(val);
                }
                this.setMemoryThreshold(memoryThreshold);
            }
            if ((val = XMLUtils.getAttribute(node, "max-instances-threshold")) != null && !val.trim().equals("")) {
                IntegerType maxInstancesThreshold = this.defaultMaxInstancesThreshold();
                if (val.equalsIgnoreCase("never")) {
                    maxInstancesThreshold.setValue("-1");
                } else {
                    maxInstancesThreshold.setValue(val);
                }
                this.setMaxInstancesThreshold(maxInstancesThreshold);
            }
            if (!(val = XMLUtils.getAttribute(node, "transaction-timeout")).equals("")) {
                IntegerType transactionTimeout = this.defaultTransactionTimeout();
                if (val.equalsIgnoreCase("never")) {
                    transactionTimeout.setValue("-1");
                } else {
                    transactionTimeout.setValue(val);
                }
                this.setTransactionTimeout(transactionTimeout);
            }
            if ((val = XMLUtils.getAttribute(node, "resource-check-interval")) != null && !val.trim().equals("")) {
                IntegerType resourceCheckInterval = this.defaultResourceCheckInterval();
                if (val.equalsIgnoreCase("never")) {
                    resourceCheckInterval.setValue("-1");
                } else {
                    resourceCheckInterval.setValue(val);
                }
                this.setResourceCheckInterval(resourceCheckInterval);
            }
            if ((val = XMLUtils.getAttribute(node, "passivate-count")) != null && !val.trim().equals("")) {
                IntegerType passivateCount = this.defaultPassivateCount();
                if (val.equalsIgnoreCase("never")) {
                    passivateCount.setValue("-1");
                } else {
                    passivateCount.setValue(val);
                }
                this.setPassivateCount(passivateCount);
            }
            if ((val = XMLUtils.getAttribute(node, "persistence-filename")) != null && !val.trim().equals("")) {
                this.setPersistenceFilename(val);
            }
            if ((val = XMLUtils.getAttribute(node, "replication")) != null && !val.trim().equals("")) {
                StringType replication = this.defaultReplication();
                if ("VMTermination".equals(val)) {
                    val = "onShutdown";
                } else if ("EndOfCall".equals(val)) {
                    val = "onRequestEnd";
                }
                replication.setValue(val);
                this.setReplication(replication);
            }
            if ((val = XMLUtils.getAttribute(node, "interceptor-type")) != null && !val.trim().equals("")) {
                StringType interceptorType = this.defaultInterceptorType();
                interceptorType.setValue(val);
                this.setInterceptorType(interceptorType);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("ior-security-config")) continue;
                IorSecurityConfigType iorSecurityConfig = new IorSecurityConfigType(this, node);
                iorSecurityConfigs.add(iorSecurityConfig);
            }
        }
        if (iorSecurityConfigs.size() > 0) {
            this.setIorSecurityConfigs(iorSecurityConfigs.toArray(new IorSecurityConfigType[0]));
        }
    }

    public ViewableJTree[] subTrees() {
        SessionMappingsTreeNode treeNode = new SessionMappingsTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public void setIorSecurityConfigs(IorSecurityConfigType[] iorSecurityConfigs) throws ConfigurationException {
        IorSecurityConfigType[] oldValue = this._iorSecurityConfigs;
        this._iorSecurityConfigs = iorSecurityConfigs;
        this.firePropertyChange("iorSecurityConfigs", oldValue, this._iorSecurityConfigs);
    }

    public IorSecurityConfigType[] getIorSecurityConfigs() {
        return this._iorSecurityConfigs;
    }

    public IorSecurityConfigType[] defaultIorSecurityConfigs() {
        try {
            return new IorSecurityConfigType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addIorSecurityConfigs() throws ConfigurationException {
        if (this._iorSecurityConfigs != null) {
            return;
        }
        IorSecurityConfigType[] iorSecurityConfigs = new IorSecurityConfigType[]{new IorSecurityConfigType(this, null)};
        this.setIorSecurityConfigs(iorSecurityConfigs);
    }

    public void removeIorSecurityConfigs() throws ConfigurationException {
        if (this._iorSecurityConfigs == null) {
            return;
        }
        this.setIorSecurityConfigs(null);
    }

    public void addIorSecurityConfig(IorSecurityConfigType iorSecurityConfig) throws ConfigurationException {
        iorSecurityConfig.setParent(this);
        int existingIorSecurityConfigsCnt = 0;
        if (this._iorSecurityConfigs != null) {
            existingIorSecurityConfigsCnt = this._iorSecurityConfigs.length;
        }
        IorSecurityConfigType[] newIorSecurityConfigs = new IorSecurityConfigType[existingIorSecurityConfigsCnt + 1];
        for (int n = 0; n < existingIorSecurityConfigsCnt; ++n) {
            newIorSecurityConfigs[n] = this._iorSecurityConfigs[n];
        }
        newIorSecurityConfigs[existingIorSecurityConfigsCnt] = iorSecurityConfig;
        IorSecurityConfigType[] oldValue = this._iorSecurityConfigs;
        this._iorSecurityConfigs = newIorSecurityConfigs;
        this.firePropertyChange("iorSecurityConfigs", oldValue, this._iorSecurityConfigs);
    }

    public void removeIorSecurityConfig(IorSecurityConfigType iorSecurityConfig) throws ConfigurationException {
        int existingIorSecurityConfigsCnt = 0;
        if (this._iorSecurityConfigs != null) {
            existingIorSecurityConfigsCnt = this._iorSecurityConfigs.length;
        }
        IorSecurityConfigType[] newIorSecurityConfigs = new IorSecurityConfigType[existingIorSecurityConfigsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingIorSecurityConfigsCnt; ++n) {
            if (iorSecurityConfig.equals(this._iorSecurityConfigs[n])) continue;
            newIorSecurityConfigs[newIndex++] = this._iorSecurityConfigs[n];
        }
        if (newIorSecurityConfigs.length == 0) {
            newIorSecurityConfigs = null;
        }
        IorSecurityConfigType[] oldValue = this._iorSecurityConfigs;
        this._iorSecurityConfigs = newIorSecurityConfigs;
        this.firePropertyChange("iorSecurityConfigs", oldValue, this._iorSecurityConfigs);
    }
}

