/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServerOperationRuntimeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServerOperationRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ServerOperationType;

public class ServerOperationTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ServerOperationType _bean;
    private static final String ADD_RUNTIME_MENU_STRING = "Add Runtime";
    private static final String REMOVE_SERVER_OPERATION_MENU_STRING = "Remove Server Operation";
    private JMenuItem _addRuntimeMenuItem;
    private JMenuItem _removeServerOperationMenuItem;

    public ServerOperationTreeNode(ConfigTreeNode rootNode, ServerOperationType serverOperation) {
        super(serverOperation);
        this.setRootNode(rootNode);
        this._bean = serverOperation;
        this._addRuntimeMenuItem = new JMenuItem(ADD_RUNTIME_MENU_STRING);
        this._addRuntimeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRuntimeMenuItem.setFont(ServerOperationTreeNode.getFont());
        this._addRuntimeMenuItem.addActionListener(this);
        if (this._bean.getRuntime() != null) {
            this._addRuntimeMenuItem.setEnabled(false);
        }
        this._removeServerOperationMenuItem = new JMenuItem(REMOVE_SERVER_OPERATION_MENU_STRING);
        this._removeServerOperationMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeServerOperationMenuItem.setFont(ServerOperationTreeNode.getFont());
        this._removeServerOperationMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRuntimeMenuItem);
        this._popup.add(this._removeServerOperationMenuItem);
    }

    public String viewHeaderString() {
        return "Server Operation";
    }

    public String toString() {
        return this._bean.getName();
    }

    protected void buildChildJTree() {
        ServerOperationRuntimeType runtime = this._bean.getRuntime();
        if (runtime != null) {
            ServerOperationRuntimeTreeNode serverOperationRuntimeTreeNode = new ServerOperationRuntimeTreeNode(this.getRootNode(), runtime);
            this.addChild(serverOperationRuntimeTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_RUNTIME_MENU_STRING)) {
                if (this._bean.getRuntime() == null) {
                    this._bean.addRuntime();
                    ServerOperationRuntimeTreeNode newNode = new ServerOperationRuntimeTreeNode(this, this._bean.getRuntime());
                    this.insertNode(newNode);
                    this._addRuntimeMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_SERVER_OPERATION_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ServerOperationRuntimeTreeNode) {
            this._bean.removeRuntime();
            this.removeNode(node);
            this._addRuntimeMenuItem.setEnabled(true);
        }
    }
}

