/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaasModuleTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaasModuleType;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingEntriesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingEntriesType;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingInterfaceTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PrincipalMappingInterfaceType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigType;

public class SecurityConfigTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SecurityConfigType _bean;
    private static final String ADD_JAAS_MODULE_MENU_STRING = "Add Jaas Module";
    private static final String ADD_PRINCIPAL_MAPPING_INTERFACE_MENU_STRING = "Add Principal Mapping Interface";
    private static final String ADD_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING = "Add Principal Mapping Entries";
    private static final String REMOVE_SECURITY_CONFIG_MENU_STRING = "Remove Security Config";
    private JMenuItem _addJaasModuleMenuItem;
    private JMenuItem _addPrincipalMappingInterfaceMenuItem;
    private JMenuItem _addPrincipalMappingEntriesMenuItem;
    private JMenuItem _removeSecurityConfigMenuItem;

    public SecurityConfigTreeNode(ConfigTreeNode rootNode, SecurityConfigType securityConfig) {
        super(securityConfig);
        this.setRootNode(rootNode);
        this._bean = securityConfig;
        this._addJaasModuleMenuItem = new JMenuItem(ADD_JAAS_MODULE_MENU_STRING);
        this._addJaasModuleMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJaasModuleMenuItem.setFont(SecurityConfigTreeNode.getFont());
        this._addJaasModuleMenuItem.addActionListener(this);
        if (this._bean.getJaasModule() != null) {
            this._addJaasModuleMenuItem.setEnabled(false);
        } else if (this._bean.getPrincipalMappingEntries() != null || this._bean.getPrincipalMappingInterface() != null) {
            this._addJaasModuleMenuItem.setEnabled(false);
        }
        this._addPrincipalMappingInterfaceMenuItem = new JMenuItem(ADD_PRINCIPAL_MAPPING_INTERFACE_MENU_STRING);
        this._addPrincipalMappingInterfaceMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPrincipalMappingInterfaceMenuItem.setFont(SecurityConfigTreeNode.getFont());
        this._addPrincipalMappingInterfaceMenuItem.addActionListener(this);
        if (this._bean.getPrincipalMappingInterface() != null) {
            this._addPrincipalMappingInterfaceMenuItem.setEnabled(false);
        } else if (this._bean.getPrincipalMappingEntries() != null || this._bean.getJaasModule() != null) {
            this._addPrincipalMappingInterfaceMenuItem.setEnabled(false);
        }
        this._addPrincipalMappingEntriesMenuItem = new JMenuItem(ADD_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING);
        this._addPrincipalMappingEntriesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPrincipalMappingEntriesMenuItem.setFont(SecurityConfigTreeNode.getFont());
        this._addPrincipalMappingEntriesMenuItem.addActionListener(this);
        if (this._bean.getPrincipalMappingEntries() != null) {
            this._addPrincipalMappingEntriesMenuItem.setEnabled(false);
        } else if (this._bean.getPrincipalMappingInterface() != null || this._bean.getJaasModule() != null) {
            this._addPrincipalMappingEntriesMenuItem.setEnabled(false);
        }
        this._removeSecurityConfigMenuItem = new JMenuItem(REMOVE_SECURITY_CONFIG_MENU_STRING);
        this._removeSecurityConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSecurityConfigMenuItem.setFont(SecurityConfigTreeNode.getFont());
        this._removeSecurityConfigMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addJaasModuleMenuItem);
        this._popup.add(this._addPrincipalMappingInterfaceMenuItem);
        this._popup.add(this._addPrincipalMappingEntriesMenuItem);
        this._popup.add(this._removeSecurityConfigMenuItem);
    }

    public String viewHeaderString() {
        return "Security Config";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PrincipalMappingEntriesType principalMappingEntries;
        PrincipalMappingInterfaceType principalMappingInterface;
        JaasModuleType jaasModule = this._bean.getJaasModule();
        if (jaasModule != null) {
            JaasModuleTreeNode jaasModuleTreeNode = new JaasModuleTreeNode(this.getRootNode(), jaasModule);
            this.addChild(jaasModuleTreeNode);
        }
        if ((principalMappingInterface = this._bean.getPrincipalMappingInterface()) != null) {
            PrincipalMappingInterfaceTreeNode principalMappingInterfaceTreeNode = new PrincipalMappingInterfaceTreeNode(this.getRootNode(), principalMappingInterface);
            this.addChild(principalMappingInterfaceTreeNode);
        }
        if ((principalMappingEntries = this._bean.getPrincipalMappingEntries()) != null) {
            PrincipalMappingEntriesTreeNode principalMappingEntriesTreeNode = new PrincipalMappingEntriesTreeNode(this.getRootNode(), principalMappingEntries);
            this.addChild(principalMappingEntriesTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_JAAS_MODULE_MENU_STRING)) {
                JaasModuleType newJaasModule = this._bean.defaultJaasModule();
                if (this.showAddDialog(newJaasModule, ADD_JAAS_MODULE_MENU_STRING)) {
                    this._bean.setJaasModule(newJaasModule);
                    JaasModuleTreeNode newNode = new JaasModuleTreeNode(this, newJaasModule);
                    this.insertNode(newNode);
                    this._addJaasModuleMenuItem.setEnabled(false);
                    this._addPrincipalMappingEntriesMenuItem.setEnabled(false);
                    this._addPrincipalMappingInterfaceMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PRINCIPAL_MAPPING_INTERFACE_MENU_STRING)) {
                PrincipalMappingInterfaceType newPrincipalMappingInterface = this._bean.defaultPrincipalMappingInterface();
                if (this.showAddDialog(newPrincipalMappingInterface, ADD_PRINCIPAL_MAPPING_INTERFACE_MENU_STRING)) {
                    this._bean.setPrincipalMappingInterface(newPrincipalMappingInterface);
                    PrincipalMappingInterfaceTreeNode newNode = new PrincipalMappingInterfaceTreeNode(this, newPrincipalMappingInterface);
                    this.insertNode(newNode);
                    this._addJaasModuleMenuItem.setEnabled(false);
                    this._addPrincipalMappingEntriesMenuItem.setEnabled(false);
                    this._addPrincipalMappingInterfaceMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING)) {
                PrincipalMappingEntriesType newPrincipalMappingEntries = this._bean.defaultPrincipalMappingEntries();
                if (this.showAddDialog(newPrincipalMappingEntries, ADD_PRINCIPAL_MAPPING_ENTRIES_MENU_STRING)) {
                    this._bean.setPrincipalMappingEntries(newPrincipalMappingEntries);
                    PrincipalMappingEntriesTreeNode newNode = new PrincipalMappingEntriesTreeNode(this, newPrincipalMappingEntries);
                    this.insertNode(newNode);
                    this._addJaasModuleMenuItem.setEnabled(false);
                    this._addPrincipalMappingEntriesMenuItem.setEnabled(false);
                    this._addPrincipalMappingInterfaceMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_SECURITY_CONFIG_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof JaasModuleTreeNode) {
            this._bean.removeJaasModule();
            this.removeNode(node);
            if (this._bean.getPrincipalMappingEntries() == null && this._bean.getPrincipalMappingInterface() == null) {
                this._addJaasModuleMenuItem.setEnabled(true);
                this._addPrincipalMappingEntriesMenuItem.setEnabled(true);
                this._addPrincipalMappingInterfaceMenuItem.setEnabled(true);
            }
        } else if (node instanceof PrincipalMappingInterfaceTreeNode) {
            this._bean.removePrincipalMappingInterface();
            this.removeNode(node);
            if (this._bean.getPrincipalMappingEntries() == null && this._bean.getJaasModule() == null) {
                this._addJaasModuleMenuItem.setEnabled(true);
                this._addPrincipalMappingEntriesMenuItem.setEnabled(true);
                this._addPrincipalMappingInterfaceMenuItem.setEnabled(true);
            }
        } else if (node instanceof PrincipalMappingEntriesTreeNode) {
            this._bean.removePrincipalMappingEntries();
            this.removeNode(node);
            if (this._bean.getPrincipalMappingInterface() == null && this._bean.getJaasModule() == null) {
                this._addJaasModuleMenuItem.setEnabled(true);
                this._addPrincipalMappingEntriesMenuItem.setEnabled(true);
                this._addPrincipalMappingInterfaceMenuItem.setEnabled(true);
            }
        }
    }
}

