/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.InboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyStoreType;
import oracle.oc4j.admin.deploy.spi.xml.NonceConfigType;
import oracle.oc4j.admin.deploy.spi.xml.OutboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityConfigPortType
extends ConfigBeanNode {
    KeyStoreType _keyStore = null;
    KeyConfigType _signatureKey = null;
    KeyConfigType _encryptionKey = null;
    NonceConfigType _nonceConfig = null;
    InboundConfigType _inbound = null;
    OutboundConfigType _outbound = null;
    PropertyConfigBean[] _properties = null;

    public SecurityConfigPortType(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public SecurityConfigPortType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "security");
        XMLUtils.writeTagAttributeEnd(out, indentation, "security");
        if (this._keyStore != null) {
            this._keyStore.writeXML(out, indentation + "\t");
        }
        if (this._signatureKey != null) {
            this._signatureKey.writeXML(out, indentation + "\t");
        }
        if (this._encryptionKey != null) {
            this._encryptionKey.writeXML(out, indentation + "\t");
        }
        if (this._nonceConfig != null) {
            this._nonceConfig.writeXML(out, indentation + "\t");
        }
        if (this._inbound != null) {
            this._inbound.writeXML(out, indentation + "\t");
        }
        if (this._outbound != null) {
            this._outbound.writeXML(out, indentation + "\t");
        }
        SecurityConfigPortType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "security");
    }

    private void init() throws ConfigurationException {
        this.setXpath("security");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("key-store")) {
                    KeyStoreType keyStore = new KeyStoreType(this, node);
                    this.setKeyStore(keyStore);
                    continue;
                }
                if (name.equals("signature-key")) {
                    KeyConfigType signatureKey = new KeyConfigType(this, "signature-key", node);
                    this.setSignatureKey(signatureKey);
                    continue;
                }
                if (name.equals("encryption-key")) {
                    KeyConfigType encryptionKey = new KeyConfigType(this, "encryption-key", node);
                    this.setEncryptionKey(encryptionKey);
                    continue;
                }
                if (name.equals("nonce-config")) {
                    NonceConfigType nonceConfig = new NonceConfigType(this, node);
                    this.setNonceConfig(nonceConfig);
                    continue;
                }
                if (name.equals("inbound")) {
                    InboundConfigType inbound = new InboundConfigType(this, node);
                    this.setInbound(inbound);
                    continue;
                }
                if (name.equals("outbound")) {
                    OutboundConfigType outbound = new OutboundConfigType(this, node);
                    this.setOutbound(outbound);
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }

    public void setKeyStore(KeyStoreType keyStore) throws ConfigurationException {
        KeyStoreType oldValue = this._keyStore;
        this._keyStore = keyStore;
        this.firePropertyChange("keyStore", oldValue, this._keyStore);
    }

    public KeyStoreType getKeyStore() {
        return this._keyStore;
    }

    public KeyStoreType defaultKeyStore() throws ConfigurationException {
        try {
            return new KeyStoreType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addKeyStore() throws ConfigurationException {
        if (this._keyStore != null) {
            return;
        }
        KeyStoreType keyStore = new KeyStoreType(this, null);
        this.setKeyStore(keyStore);
    }

    public void removeKeyStore() throws ConfigurationException {
        if (this._keyStore == null) {
            return;
        }
        this.setKeyStore(null);
    }

    public void setSignatureKey(KeyConfigType signatureKey) throws ConfigurationException {
        KeyConfigType oldValue = this._signatureKey;
        this._signatureKey = signatureKey;
        this.firePropertyChange("signatureKey", oldValue, this._signatureKey);
    }

    public KeyConfigType getSignatureKey() {
        return this._signatureKey;
    }

    public KeyConfigType defaultSignatureKey() throws ConfigurationException {
        try {
            return new KeyConfigType(this, "signature-key", null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addSignatureKey() throws ConfigurationException {
        if (this._signatureKey != null) {
            return;
        }
        KeyConfigType signatureKey = new KeyConfigType(this, "signature-key", null);
        this.setSignatureKey(signatureKey);
    }

    public void removeSignatureKey() throws ConfigurationException {
        if (this._signatureKey == null) {
            return;
        }
        this.setSignatureKey(null);
    }

    public void setEncryptionKey(KeyConfigType encryptionKey) throws ConfigurationException {
        KeyConfigType oldValue = this._encryptionKey;
        this._encryptionKey = encryptionKey;
        this.firePropertyChange("encryptionKey", oldValue, this._encryptionKey);
    }

    public KeyConfigType getEncryptionKey() {
        return this._encryptionKey;
    }

    public KeyConfigType defaultEncryptionKey() throws ConfigurationException {
        try {
            return new KeyConfigType(this, "encryption-key", null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addEncryptionKey() throws ConfigurationException {
        if (this._encryptionKey != null) {
            return;
        }
        KeyConfigType encryptionKey = new KeyConfigType(this, "encryption-key", null);
        this.setEncryptionKey(encryptionKey);
    }

    public void removeEncryptionKey() throws ConfigurationException {
        if (this._encryptionKey == null) {
            return;
        }
        this.setEncryptionKey(null);
    }

    public void setNonceConfig(NonceConfigType nonceConfig) throws ConfigurationException {
        NonceConfigType oldValue = this._nonceConfig;
        this._nonceConfig = nonceConfig;
        this.firePropertyChange("nonceConfig", oldValue, this._nonceConfig);
    }

    public NonceConfigType getNonceConfig() {
        return this._nonceConfig;
    }

    public NonceConfigType defaultNonceConfig() throws ConfigurationException {
        try {
            return new NonceConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addNonceConfig() throws ConfigurationException {
        if (this._nonceConfig != null) {
            return;
        }
        NonceConfigType nonceConfig = new NonceConfigType(this, null);
        this.setNonceConfig(nonceConfig);
    }

    public void removeNonceConfig() throws ConfigurationException {
        if (this._nonceConfig == null) {
            return;
        }
        this.setNonceConfig(null);
    }

    public void setInbound(InboundConfigType inbound) throws ConfigurationException {
        InboundConfigType oldValue = this._inbound;
        this._inbound = inbound;
        this.firePropertyChange("inbound", oldValue, this._inbound);
    }

    public InboundConfigType getInbound() {
        return this._inbound;
    }

    public InboundConfigType defaultInbound() throws ConfigurationException {
        try {
            return new InboundConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addInbound() throws ConfigurationException {
        if (this._inbound != null) {
            return;
        }
        InboundConfigType inbound = new InboundConfigType(this, null);
        this.setInbound(inbound);
    }

    public void removeInbound() throws ConfigurationException {
        if (this._inbound == null) {
            return;
        }
        this.setInbound(null);
    }

    public void setOutbound(OutboundConfigType outbound) throws ConfigurationException {
        OutboundConfigType oldValue = this._outbound;
        this._outbound = outbound;
        this.firePropertyChange("outbound", oldValue, this._outbound);
    }

    public OutboundConfigType getOutbound() {
        return this._outbound;
    }

    public OutboundConfigType defaultOutbound() throws ConfigurationException {
        try {
            return new OutboundConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addOutbound() throws ConfigurationException {
        if (this._outbound != null) {
            return;
        }
        OutboundConfigType outbound = new OutboundConfigType(this, null);
        this.setOutbound(outbound);
    }

    public void removeOutbound() throws ConfigurationException {
        if (this._outbound == null) {
            return;
        }
        this.setOutbound(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }
}

