/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.StringTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;

public class RoleNamesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_ROLE_NAME_MENU_STRING = "Add Role Name";
    private JMenuItem _addRoleNameMenuItem;
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public RoleNamesTreeNode(ConfigTreeNode rootNode, MultipleType roleNames) {
        super(roleNames);
        this.setRootNode(rootNode);
        this._parentBean = roleNames.getConfigParent();
        this._addRoleNameMenuItem = new JMenuItem(ADD_ROLE_NAME_MENU_STRING);
        this._addRoleNameMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRoleNameMenuItem.setFont(RoleNamesTreeNode.getFont());
        this._addRoleNameMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRoleNameMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getRoleNames", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addRoleName", StringType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeRoleName", StringType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Role Names";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            StringType[] roleNames = (StringType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (roleNames != null) {
                for (int i = 0; i < roleNames.length; ++i) {
                    StringType roleName = roleNames[i];
                    if (roleName == null) continue;
                    StringTreeNode stringTreeNode = new StringTreeNode(this.getRootNode(), roleName);
                    this.addChild(stringTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_ROLE_NAME_MENU_STRING)) {
                StringType newRoleName = new StringType(this._parentBean);
                newRoleName.putXpath("role-name");
                if (this.showAddDialog(newRoleName, ADD_ROLE_NAME_MENU_STRING)) {
                    this._addMethod.invoke((Object)this._parentBean, newRoleName);
                    StringTreeNode newNode = new StringTreeNode(this, newRoleName);
                    this.insertNode(newNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof StringTreeNode) {
            try {
                StringType roleName = (StringType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, roleName);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

