/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.LongType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPropertyType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProviderPortType
extends ConfigBeanNode {
    protected String _providerName = null;
    protected String _wsdlPort = null;
    protected BooleanType _exposeWsdl = null;
    protected BooleanType _oldExposeWsdl = null;
    protected BooleanType _exposeTestpage = null;
    protected BooleanType _oldExposeTestpage = null;
    protected String _implementationClass = null;
    protected String _servletLink = null;
    protected ProviderPropertyType[] _properties = null;
    protected LongType _maxRequestSize = null;
    protected LongType _oldMaxRequestSize = null;

    public ProviderPortType(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public ProviderPortType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setProviderName(String providerName) throws ConfigurationException {
        String oldValue = this._providerName;
        this._providerName = providerName;
        this.firePropertyChange("providerName", oldValue, this._providerName);
    }

    public String getProviderName() {
        return this._providerName;
    }

    public String defaultProviderName() {
        return "";
    }

    public void setWsdlPort(String wsdlPort) throws ConfigurationException {
        String oldValue = this._wsdlPort;
        this._wsdlPort = wsdlPort;
        this.firePropertyChange("wsdlPort", oldValue, this._wsdlPort);
    }

    public String getWsdlPort() {
        return this._wsdlPort;
    }

    public String defaultWsdlPort() {
        return "";
    }

    public void setExposeWsdl(BooleanType exposeWsdl) throws ConfigurationException {
        this._exposeWsdl = exposeWsdl;
        this.firePropertyChange("exposeWsdl", this._oldExposeWsdl, this._exposeWsdl);
        if (this._exposeWsdl != null) {
            if (this._oldExposeWsdl == null) {
                this._oldExposeWsdl = this.defaultExposeWsdl();
            }
            this._oldExposeWsdl.setValue(this._exposeWsdl.getValue());
        } else {
            this._oldExposeWsdl = null;
        }
    }

    public BooleanType getExposeWsdl() {
        return this._exposeWsdl;
    }

    public BooleanType defaultExposeWsdl() {
        try {
            return new BooleanType(this, "true");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setExposeTestpage(BooleanType exposeTestpage) throws ConfigurationException {
        this._exposeTestpage = exposeTestpage;
        this.firePropertyChange("exposeTestpage", this._oldExposeTestpage, this._exposeTestpage);
        if (this._exposeTestpage != null) {
            if (this._oldExposeTestpage == null) {
                this._oldExposeTestpage = this.defaultExposeTestpage();
            }
            this._oldExposeTestpage.setValue(this._exposeTestpage.getValue());
        } else {
            this._oldExposeTestpage = null;
        }
    }

    public BooleanType getExposeTestpage() {
        return this._exposeTestpage;
    }

    public BooleanType defaultExposeTestpage() {
        try {
            return new BooleanType(this, "true");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setImplementationClass(String implementationClass) throws ConfigurationException {
        String oldValue = this._implementationClass;
        this._implementationClass = implementationClass;
        this.firePropertyChange("implementationClass", oldValue, this._implementationClass);
    }

    public String getImplementationClass() {
        return this._implementationClass;
    }

    public String defaultImplementationClass() {
        return "";
    }

    public void setServletLink(String servletLink) throws ConfigurationException {
        String oldValue = this._servletLink;
        this._servletLink = servletLink;
        this.firePropertyChange("servletLink", oldValue, this._servletLink);
    }

    public String getServletLink() {
        return this._servletLink;
    }

    public String defaultServletLink() {
        return "";
    }

    public void setProperties(ProviderPropertyType[] properties) throws ConfigurationException {
        ProviderPropertyType[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public ProviderPropertyType[] getProperties() {
        return this._properties;
    }

    public ProviderPropertyType[] defaultProperties() {
        return new ProviderPropertyType[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        ProviderPropertyType[] properties = new ProviderPropertyType[]{new ProviderPropertyType(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(ProviderPropertyType property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        ProviderPropertyType[] newProperties = new ProviderPropertyType[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        ProviderPropertyType[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(ProviderPropertyType property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        ProviderPropertyType[] newProperties = new ProviderPropertyType[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        ProviderPropertyType[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void setMaxRequestSize(LongType maxRequestSize) throws ConfigurationException {
        this._maxRequestSize = maxRequestSize;
        this.firePropertyChange("maxRequestSize", this._oldMaxRequestSize, this._maxRequestSize);
        if (this._maxRequestSize != null) {
            if (this._oldMaxRequestSize == null) {
                this._oldMaxRequestSize = this.defaultMaxRequestSize();
            }
            this._oldMaxRequestSize.setValue(this._maxRequestSize.getValue());
        } else {
            this._oldMaxRequestSize = null;
        }
    }

    public LongType getMaxRequestSize() {
        return this._maxRequestSize;
    }

    public LongType defaultMaxRequestSize() {
        try {
            return new LongType(this, "-1");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "provider-port");
        XMLUtils.writeTagAttributeEnd(out, indentation, "provider-port");
        if (this._providerName != null && this._providerName.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "provider-name", this._providerName);
        }
        if (this._wsdlPort != null && this._wsdlPort.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "wsdl-port", this._wsdlPort);
        }
        if (this._exposeWsdl != null) {
            XMLUtils.writeTag(out, indentation + "\t", "expose-wsdl", this._exposeWsdl);
        }
        if (this._exposeTestpage != null) {
            XMLUtils.writeTag(out, indentation + "\t", "expose-testpage", this._exposeTestpage);
        }
        if (this._implementationClass != null && this._implementationClass.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "implementation-class", this._implementationClass);
        }
        if (this._servletLink != null && this._servletLink.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "servlet-link", this._servletLink);
        }
        if (this._maxRequestSize != null) {
            XMLUtils.writeTag(out, indentation + "\t", "max-request-size", this._maxRequestSize);
        }
        ProviderPortType.writeXML(out, indentation + "\t\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "provider-port");
    }

    public void writePropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ProviderPropertyType.writeXML(out, indentation, this._properties);
    }

    private void init() throws ConfigurationException {
        this.setXpath("provider-port");
        Vector<ProviderPropertyType> properties = new Vector<ProviderPropertyType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("provider-name")) {
                    this.setProviderName(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("wsdl-port")) {
                    this.setWsdlPort(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("expose-wsdl")) {
                    val = XMLUtils.getValue(node);
                    BooleanType exposeWsdl = this.defaultExposeWsdl();
                    exposeWsdl.setValue(val);
                    this.setExposeWsdl(exposeWsdl);
                    continue;
                }
                if (name.equals("expose-testpage")) {
                    val = XMLUtils.getValue(node);
                    BooleanType exposeTestpage = this.defaultExposeTestpage();
                    exposeTestpage.setValue(val);
                    this.setExposeTestpage(exposeTestpage);
                    continue;
                }
                if (name.equals("implementation-class")) {
                    this.setImplementationClass(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("servlet-link")) {
                    this.setServletLink(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("max-request-size")) {
                    val = XMLUtils.getValue(node);
                    LongType maxRequestSize = this.defaultMaxRequestSize();
                    maxRequestSize.setValue(val);
                    this.setMaxRequestSize(maxRequestSize);
                    continue;
                }
                if (!name.equals("property")) continue;
                ProviderPropertyType configBean = new ProviderPropertyType(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new ProviderPropertyType[0]));
        }
    }
}

