/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceResourceType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceAccessType
extends ConfigBeanNode {
    protected NamespaceResourceType _namespaceReadAccess = null;
    protected NamespaceResourceType _namespaceWriteAccess = null;

    public NamespaceAccessType(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public NamespaceAccessType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setNamespaceReadAccess(NamespaceResourceType namespaceReadAccess) throws ConfigurationException {
        NamespaceResourceType oldValue = this._namespaceReadAccess;
        this._namespaceReadAccess = namespaceReadAccess;
        this.firePropertyChange("namespaceReadAccess", oldValue, this._namespaceReadAccess);
    }

    public NamespaceResourceType getNamespaceReadAccess() {
        return this._namespaceReadAccess;
    }

    public NamespaceResourceType defaultNamespaceReadAccess() {
        try {
            return new NamespaceResourceType(this, null, "Read");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addNamespaceReadAccess() throws ConfigurationException {
        if (this._namespaceReadAccess != null) {
            return;
        }
        NamespaceResourceType namespaceReadAccess = new NamespaceResourceType(this, null, "Read");
        this.setNamespaceReadAccess(namespaceReadAccess);
    }

    public void removeNamespaceReadAccess() throws ConfigurationException {
        if (this._namespaceReadAccess == null) {
            return;
        }
        this.setNamespaceReadAccess(null);
    }

    public void setNamespaceWriteAccess(NamespaceResourceType namespaceWriteAccess) throws ConfigurationException {
        NamespaceResourceType oldValue = this._namespaceWriteAccess;
        this._namespaceWriteAccess = namespaceWriteAccess;
        this.firePropertyChange("namespaceWriteAccess", oldValue, this._namespaceWriteAccess);
    }

    public NamespaceResourceType getNamespaceWriteAccess() {
        return this._namespaceWriteAccess;
    }

    public NamespaceResourceType defaultNamespaceWriteAccess() {
        try {
            return new NamespaceResourceType(this, null, "Write");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addNamespaceWriteAccess() throws ConfigurationException {
        if (this._namespaceWriteAccess != null) {
            return;
        }
        NamespaceResourceType namespaceWriteAccess = new NamespaceResourceType(this, null, "Write");
        this.setNamespaceWriteAccess(namespaceWriteAccess);
    }

    public void removeNamespaceWriteAccess() throws ConfigurationException {
        if (this._namespaceWriteAccess == null) {
            return;
        }
        this.setNamespaceWriteAccess(null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "namespace-access");
        XMLUtils.writeTagStart(out, indentation + "\t", "read-access");
        if (this._namespaceReadAccess != null) {
            this._namespaceReadAccess.writeXML(out, indentation + "\t\t");
        }
        XMLUtils.writeTagEnd(out, indentation + "\t", "read-access");
        XMLUtils.writeTagStart(out, indentation + "\t", "write-access");
        if (this._namespaceWriteAccess != null) {
            this._namespaceWriteAccess.writeXML(out, indentation + "\t\t");
        }
        XMLUtils.writeTagEnd(out, indentation + "\t", "write-access");
        XMLUtils.writeTagEnd(out, indentation, "namespace-access");
    }

    private void init() throws ConfigurationException {
        this.setXpath("namespace-access");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("read-access")) {
                    this.setNamespaceReadAccess(new NamespaceResourceType(this, node, "Read"));
                }
                if (!name.equals("write-access")) continue;
                this.setNamespaceWriteAccess(new NamespaceResourceType(this, node, "Write"));
            }
        }
    }
}

