/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.CmpFieldMappingType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.MapKeyMappingType;
import oracle.oc4j.admin.deploy.spi.xml.ValueMappingType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapMappingType
extends ConfigBeanNode {
    String _table = null;
    CmpFieldMappingType _primkeyMapping = null;
    protected MapKeyMappingType _mapKeyMapping = null;
    protected ValueMappingType _valueMapping = null;

    public MapMappingType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public MapMappingType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setTable(String table) throws ConfigurationException {
        String oldValue = this._table;
        this._table = table;
        this.firePropertyChange("table", oldValue, this._table);
    }

    public String getTable() {
        return this._table;
    }

    public String defaultTable() {
        return "";
    }

    public CmpFieldMappingType getPrimkeyMapping() {
        return this._primkeyMapping;
    }

    public void setPrimkeyMapping(CmpFieldMappingType primkeyMapping) throws ConfigurationException {
        CmpFieldMappingType oldValue = this._primkeyMapping;
        this._primkeyMapping = primkeyMapping;
        if (this._primkeyMapping != null) {
            this._primkeyMapping.primkey();
        }
        this.firePropertyChange("primkeyMapping", oldValue, this._primkeyMapping);
    }

    public void addPrimkeyMapping() throws ConfigurationException {
        if (this._primkeyMapping != null) {
            return;
        }
        CmpFieldMappingType primkeyMapping = new CmpFieldMappingType(this, null);
        this.setPrimkeyMapping(primkeyMapping);
    }

    public void removePrimkeyMapping() throws ConfigurationException {
        if (this._primkeyMapping == null) {
            return;
        }
        this.setPrimkeyMapping(null);
    }

    public CmpFieldMappingType defaultPrimkeyMapping() {
        try {
            CmpFieldMappingType ret = new CmpFieldMappingType(this, null);
            ret.primkey();
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public MapKeyMappingType getMapKeyMapping() {
        return this._mapKeyMapping;
    }

    public void setMapKeyMapping(MapKeyMappingType mapKeyMapping) throws ConfigurationException {
        MapKeyMappingType oldValue = this._mapKeyMapping;
        this._mapKeyMapping = mapKeyMapping;
        this.firePropertyChange("mapKeyMapping", oldValue, this._mapKeyMapping);
    }

    public void addMapKeyMapping() throws ConfigurationException {
        if (this._mapKeyMapping != null) {
            return;
        }
        MapKeyMappingType mapKeyMapping = new MapKeyMappingType(this, null);
        this.setMapKeyMapping(mapKeyMapping);
    }

    public void removeMapKeyMapping() throws ConfigurationException {
        if (this._mapKeyMapping == null) {
            return;
        }
        this.setMapKeyMapping(null);
    }

    public MapKeyMappingType defaultMapKeyMapping() {
        try {
            return new MapKeyMappingType(this);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public ValueMappingType getValueMapping() {
        return this._valueMapping;
    }

    public void setValueMapping(ValueMappingType valueMapping) throws ConfigurationException {
        ValueMappingType oldValue = this._valueMapping;
        this._valueMapping = valueMapping;
        this.firePropertyChange("valueMapping", oldValue, this._valueMapping);
    }

    public void addValueMapping() throws ConfigurationException {
        if (this._valueMapping != null) {
            return;
        }
        ValueMappingType valueMapping = new ValueMappingType(this, null);
        this.setValueMapping(valueMapping);
    }

    public void removeValueMapping() throws ConfigurationException {
        if (this._valueMapping == null) {
            return;
        }
        this.setValueMapping(null);
    }

    public ValueMappingType defaultValueMapping() {
        try {
            return new ValueMappingType(this);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "map-mapping");
        XMLUtils.writeAttribute(out, indentation, "table", this._table);
        XMLUtils.writeTagAttributeEnd(out, indentation, "map-mapping");
        if (this._primkeyMapping != null) {
            XMLUtils.writeTagAttributeStart(out, indentation + "\t", "primkey-mapping");
            XMLUtils.writeTagAttributeEnd(out, indentation + "\t", "primkey-mapping");
            this._primkeyMapping.writeXML(out, indentation + "\t\t");
            XMLUtils.writeTagEnd(out, indentation + "\t", "primkey-mapping");
        }
        if (this._mapKeyMapping != null) {
            this._mapKeyMapping.writeXML(out, indentation + "\t");
        }
        if (this._valueMapping != null) {
            this._valueMapping.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "map-mapping");
    }

    private void init() throws ConfigurationException {
        this.setXpath("map-mapping");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "table");
            if (val != null && !val.trim().equals("")) {
                this.setTable(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("primkey-mapping")) {
                    NodeList primkeyNodes = node.getChildNodes();
                    for (int p = 0; p < primkeyNodes.getLength(); ++p) {
                        Node primkeyNode = primkeyNodes.item(p);
                        name = primkeyNode.getNodeName();
                        if (!name.equals("cmp-field-mapping")) continue;
                        CmpFieldMappingType primkeyMapping = new CmpFieldMappingType(this, primkeyNode);
                        primkeyMapping.setName(XMLUtils.getAttribute(primkeyNode, "name"));
                        this.setPrimkeyMapping(primkeyMapping);
                    }
                    continue;
                }
                if (name.equals("map-key-mapping")) {
                    this.setMapKeyMapping(new MapKeyMappingType(this, node));
                    continue;
                }
                if (!name.equals("value-mapping")) continue;
                this.setValueMapping(new ValueMappingType(this, node));
            }
        }
        if (this._primkeyMapping == null) {
            this.addPrimkeyMapping();
        }
        if (this._mapKeyMapping == null) {
            this.addMapKeyMapping();
        }
        if (this._valueMapping == null) {
            this.addValueMapping();
        }
    }
}

