/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingAttributeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingAttributeType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class LoggingAttributesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_ATTRIBUTE_MENU_STRING = "Add Attribute";
    private JMenuItem _addLoggingAttributeMenuItem;
    private LoggingAttributeType[] loggingAttributesType = new LoggingAttributeType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public LoggingAttributesTreeNode(ConfigTreeNode rootNode, MultipleType loggingAttributes) {
        super(loggingAttributes);
        this.setRootNode(rootNode);
        this._parentBean = loggingAttributes.getConfigParent();
        this._addLoggingAttributeMenuItem = new JMenuItem(ADD_ATTRIBUTE_MENU_STRING);
        this._addLoggingAttributeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addLoggingAttributeMenuItem.setFont(LoggingAttributesTreeNode.getFont());
        this._addLoggingAttributeMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addLoggingAttributeMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getAttributes", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addAttribute", LoggingAttributeType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeAttribute", LoggingAttributeType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Attributes";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            LoggingAttributeType[] loggingAttributes = (LoggingAttributeType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (loggingAttributes != null) {
                for (int i = 0; i < loggingAttributes.length; ++i) {
                    LoggingAttributeType loggingAttribute = loggingAttributes[i];
                    if (loggingAttribute == null) continue;
                    LoggingAttributeTreeNode loggingAttributeTreeNode = new LoggingAttributeTreeNode(this.getRootNode(), loggingAttribute);
                    this.addChild(loggingAttributeTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            LoggingAttributeType newLoggingAttribute;
            if (event.getActionCommand().equals(ADD_ATTRIBUTE_MENU_STRING) && this.showAddDialog(newLoggingAttribute = new LoggingAttributeType(this._parentBean), ADD_ATTRIBUTE_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newLoggingAttribute);
                LoggingAttributeTreeNode newNode = new LoggingAttributeTreeNode(this, newLoggingAttribute);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof LoggingAttributeTreeNode) {
            try {
                LoggingAttributeType loggingAttribute = (LoggingAttributeType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, loggingAttribute);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

