/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.LocaleEncodingMappingType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocaleEncodingMappingListType
extends ConfigBeanNode {
    LocaleEncodingMappingType[] localeEncodingMappings;

    public LocaleEncodingMappingListType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("locale-encoding-mapping-list");
        Node node = this.getNode();
        ArrayList<LocaleEncodingMappingType> vec = new ArrayList<LocaleEncodingMappingType>();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (!nodeName.equals("locale-encoding-mapping")) continue;
                vec.add(new LocaleEncodingMappingType(this, childNodes.item(i)));
            }
        }
        if (vec.size() != 0) {
            this.localeEncodingMappings = vec.toArray(new LocaleEncodingMappingType[0]);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this.localeEncodingMappings != null && this.localeEncodingMappings.length != 0) {
            XMLUtils.writeTagStart(out, indentation, "locale-encoding-mapping-list");
            for (int i = 0; i < this.localeEncodingMappings.length; ++i) {
                this.localeEncodingMappings[i].writeXML(out, indentation);
            }
            XMLUtils.writeTagEnd(out, indentation + "\t", "locale-encoding-mapping-list");
        }
    }

    public LocaleEncodingMappingType[] getLocaleEncodingMappings() {
        return this.localeEncodingMappings;
    }
}

