/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LibraryTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LibraryType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class LibrariesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_LIBRARY_MENU_STRING = "Add Library";
    private JMenuItem _addLibraryMenuItem;
    private LibraryType[] librariesType = new LibraryType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public LibrariesTreeNode(ConfigTreeNode rootNode, MultipleType libraries) {
        super(libraries);
        this.setRootNode(rootNode);
        this._parentBean = libraries.getConfigParent();
        this._addLibraryMenuItem = new JMenuItem(ADD_LIBRARY_MENU_STRING);
        this._addLibraryMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addLibraryMenuItem.setFont(LibrariesTreeNode.getFont());
        this._addLibraryMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addLibraryMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getLibraries", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addLibrary", LibraryType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeLibrary", LibraryType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Libraries";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            LibraryType[] libraries = (LibraryType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (libraries != null) {
                for (int i = 0; i < libraries.length; ++i) {
                    LibraryType library = libraries[i];
                    if (library == null) continue;
                    LibraryTreeNode libraryTreeNode = new LibraryTreeNode(this.getRootNode(), library);
                    this.addChild(libraryTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            LibraryType newLibrary;
            if (event.getActionCommand().equals(ADD_LIBRARY_MENU_STRING) && this.showAddDialog(newLibrary = new LibraryType(this._parentBean), ADD_LIBRARY_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newLibrary);
                LibraryTreeNode newNode = new LibraryTreeNode(this, newLibrary);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof LibraryTreeNode) {
            try {
                LibraryType library = (LibraryType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, library);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

