/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.JMSInfo;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringTypeBase;

public class JmsQueueLocationType
extends StringTypeBase {
    public JmsQueueLocationType() {
        this((ConfigBeanNode)null);
    }

    public JmsQueueLocationType(ConfigBeanNode parent) {
        super(parent);
    }

    public String[] getTags() {
        JMSInfo[] jmsInfo = this.getJmsInfo();
        if (jmsInfo != null) {
            String[] tags = new String[jmsInfo.length];
            for (int n = 0; n < tags.length; ++n) {
                tags[n] = new String(jmsInfo[n].getLocation());
            }
            super.setTags(tags);
        }
        return super.getTags();
    }

    private JMSInfo[] getJmsInfo() {
        ProprietaryTarget target = this.getProprietaryTarget();
        if (target != null) {
            JMSInfo[] info = target.getJMSResources();
            if (info == null) {
                return null;
            }
            int queueCnt = 0;
            for (int n = 0; n < info.length; ++n) {
                if (!info[n].isQueue()) continue;
                ++queueCnt;
            }
            if (queueCnt == info.length) {
                return info;
            }
            JMSInfo[] newInfo = new JMSInfo[queueCnt];
            int n2 = 0;
            for (int n = 0; n < info.length; ++n) {
                if (!info[n].isQueue()) continue;
                newInfo[n2++] = info[n];
            }
            return newInfo;
        }
        return null;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
    }
}

