/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DecryptConfigType;
import oracle.oc4j.admin.deploy.spi.xml.DecryptTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.InboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.VerifySamlTokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.VerifySamlTokenTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.VerifySignatureConfigType;
import oracle.oc4j.admin.deploy.spi.xml.VerifySignatureTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.VerifyUsernameTokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.VerifyUsernameTokenTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.VerifyX509TokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.VerifyX509TokenTreeNode;

public class InboundTreeNode
extends ConfigTreeNode
implements ActionListener {
    private InboundConfigType _bean;
    private static final String ADD_VERIFY_USERNAME_TOKEN_MENU_STRING = "Add Verify Username Token";
    private static final String ADD_VERIFY_X509_TOKEN_MENU_STRING = "Add Verify X509 Token";
    private static final String ADD_VERIFY_SAML_TOKEN_MENU_STRING = "Add Verify Saml Token";
    private static final String ADD_VERIFY_SIGNATURE_MENU_STRING = "Add Verify Signature";
    private static final String ADD_DECRYPT_MENU_STRING = "Add Decrypt";
    private static final String REMOVE_INBOUND_MENU_STRING = "Remove Inbound";
    private JMenuItem _addVerifyUsernameTokenMenuItem;
    private JMenuItem _addVerifyX509TokenMenuItem;
    private JMenuItem _addVerifySamlTokenMenuItem;
    private JMenuItem _addVerifySignatureMenuItem;
    private JMenuItem _addDecryptMenuItem;
    private JMenuItem _removeInboundMenuItem;

    public InboundTreeNode(ConfigTreeNode rootNode, InboundConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addVerifyUsernameTokenMenuItem = new JMenuItem(ADD_VERIFY_USERNAME_TOKEN_MENU_STRING);
        this._addVerifyUsernameTokenMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addVerifyUsernameTokenMenuItem.setFont(InboundTreeNode.getFont());
        this._addVerifyUsernameTokenMenuItem.addActionListener(this);
        if (this._bean.getVerifyUsernameToken() != null) {
            this._addVerifyUsernameTokenMenuItem.setEnabled(false);
        }
        this._addVerifyX509TokenMenuItem = new JMenuItem(ADD_VERIFY_X509_TOKEN_MENU_STRING);
        this._addVerifyX509TokenMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addVerifyX509TokenMenuItem.setFont(InboundTreeNode.getFont());
        this._addVerifyX509TokenMenuItem.addActionListener(this);
        if (this._bean.getVerifyX509Token() != null) {
            this._addVerifyX509TokenMenuItem.setEnabled(false);
        }
        this._addVerifySamlTokenMenuItem = new JMenuItem(ADD_VERIFY_SAML_TOKEN_MENU_STRING);
        this._addVerifySamlTokenMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addVerifySamlTokenMenuItem.setFont(InboundTreeNode.getFont());
        this._addVerifySamlTokenMenuItem.addActionListener(this);
        if (this._bean.getVerifySamlToken() != null) {
            this._addVerifySamlTokenMenuItem.setEnabled(false);
        }
        this._addVerifySignatureMenuItem = new JMenuItem(ADD_VERIFY_SIGNATURE_MENU_STRING);
        this._addVerifySignatureMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addVerifySignatureMenuItem.setFont(InboundTreeNode.getFont());
        this._addVerifySignatureMenuItem.addActionListener(this);
        if (this._bean.getVerifySignature() != null) {
            this._addVerifySignatureMenuItem.setEnabled(false);
        }
        this._addDecryptMenuItem = new JMenuItem(ADD_DECRYPT_MENU_STRING);
        this._addDecryptMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addDecryptMenuItem.setFont(InboundTreeNode.getFont());
        this._addDecryptMenuItem.addActionListener(this);
        if (this._bean.getDecrypt() != null) {
            this._addDecryptMenuItem.setEnabled(false);
        }
        this._removeInboundMenuItem = new JMenuItem(REMOVE_INBOUND_MENU_STRING);
        this._removeInboundMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeInboundMenuItem.setFont(InboundTreeNode.getFont());
        this._removeInboundMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addVerifyUsernameTokenMenuItem);
        this._popup.add(this._addVerifyX509TokenMenuItem);
        this._popup.add(this._addVerifySamlTokenMenuItem);
        this._popup.add(this._addVerifySignatureMenuItem);
        this._popup.add(this._addDecryptMenuItem);
        this._popup.add(this._removeInboundMenuItem);
    }

    public String viewHeaderString() {
        return "Inbound";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        DecryptConfigType decrypt;
        VerifySignatureConfigType verifySignature;
        VerifySamlTokenConfigType verifySamlToken;
        VerifyX509TokenConfigType verifyX509Token;
        VerifyUsernameTokenConfigType verifyUsernameToken = this._bean.getVerifyUsernameToken();
        if (verifyUsernameToken != null) {
            VerifyUsernameTokenTreeNode verifyUsernameTokenTreeNode = new VerifyUsernameTokenTreeNode(this.getRootNode(), verifyUsernameToken);
            this.addChild(verifyUsernameTokenTreeNode);
        }
        if ((verifyX509Token = this._bean.getVerifyX509Token()) != null) {
            VerifyX509TokenTreeNode verifyX509TokenTreeNode = new VerifyX509TokenTreeNode(this.getRootNode(), verifyX509Token);
            this.addChild(verifyX509TokenTreeNode);
        }
        if ((verifySamlToken = this._bean.getVerifySamlToken()) != null) {
            VerifySamlTokenTreeNode verifySamlTokenTreeNode = new VerifySamlTokenTreeNode(this.getRootNode(), verifySamlToken);
            this.addChild(verifySamlTokenTreeNode);
        }
        if ((verifySignature = this._bean.getVerifySignature()) != null) {
            VerifySignatureTreeNode verifySignatureTreeNode = new VerifySignatureTreeNode(this.getRootNode(), verifySignature);
            this.addChild(verifySignatureTreeNode);
        }
        if ((decrypt = this._bean.getDecrypt()) != null) {
            DecryptTreeNode decryptTreeNode = new DecryptTreeNode(this.getRootNode(), decrypt);
            this.addChild(decryptTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_VERIFY_USERNAME_TOKEN_MENU_STRING)) {
                VerifyUsernameTokenConfigType newVerifyUsernameToken = this._bean.defaultVerifyUsernameToken();
                if (this.showAddDialog(newVerifyUsernameToken, ADD_VERIFY_USERNAME_TOKEN_MENU_STRING)) {
                    this._bean.setVerifyUsernameToken(newVerifyUsernameToken);
                    VerifyUsernameTokenTreeNode newNode = new VerifyUsernameTokenTreeNode(this, newVerifyUsernameToken);
                    this.insertNode(newNode);
                    this._addVerifyUsernameTokenMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_VERIFY_X509_TOKEN_MENU_STRING)) {
                VerifyX509TokenConfigType newVerifyX509Token = this._bean.defaultVerifyX509Token();
                if (this.showAddDialog(newVerifyX509Token, ADD_VERIFY_X509_TOKEN_MENU_STRING)) {
                    this._bean.setVerifyX509Token(newVerifyX509Token);
                    VerifyX509TokenTreeNode newNode = new VerifyX509TokenTreeNode(this, newVerifyX509Token);
                    this.insertNode(newNode);
                    this._addVerifyX509TokenMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_VERIFY_SAML_TOKEN_MENU_STRING)) {
                if (this._bean.getVerifySamlToken() == null) {
                    this._bean.addVerifySamlToken();
                    VerifySamlTokenTreeNode newNode = new VerifySamlTokenTreeNode(this, this._bean.getVerifySamlToken());
                    this.insertNode(newNode);
                    this._addVerifySamlTokenMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_VERIFY_SIGNATURE_MENU_STRING)) {
                if (this._bean.getVerifySignature() == null) {
                    this._bean.addVerifySignature();
                    VerifySignatureTreeNode newNode = new VerifySignatureTreeNode(this, this._bean.getVerifySignature());
                    this.insertNode(newNode);
                    this._addVerifySignatureMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_DECRYPT_MENU_STRING)) {
                if (this._bean.getDecrypt() == null) {
                    this._bean.addDecrypt();
                    DecryptTreeNode newNode = new DecryptTreeNode(this, this._bean.getDecrypt());
                    this.insertNode(newNode);
                    this._addDecryptMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_INBOUND_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof VerifyUsernameTokenTreeNode) {
            this._bean.removeVerifyUsernameToken();
            this.removeNode(node);
            this._addVerifyUsernameTokenMenuItem.setEnabled(true);
        } else if (node instanceof VerifyX509TokenTreeNode) {
            this._bean.removeVerifyX509Token();
            this.removeNode(node);
            this._addVerifyX509TokenMenuItem.setEnabled(true);
        } else if (node instanceof VerifySamlTokenTreeNode) {
            this._bean.removeVerifySamlToken();
            this.removeNode(node);
            this._addVerifySamlTokenMenuItem.setEnabled(true);
        } else if (node instanceof VerifySignatureTreeNode) {
            this._bean.removeVerifySignature();
            this.removeNode(node);
            this._addVerifySignatureMenuItem.setEnabled(true);
        } else if (node instanceof DecryptTreeNode) {
            this._bean.removeDecrypt();
            this.removeNode(node);
            this._addDecryptMenuItem.setEnabled(true);
        }
    }
}

