/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ImportType;
import oracle.oc4j.admin.deploy.spi.xml.RemoveType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportOrRemoveType
extends ConfigBeanNode {
    ImportType _import = null;
    RemoveType _remove = null;

    public ImportOrRemoveType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public ImportOrRemoveType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setImport(ImportType imprt) throws ConfigurationException {
        if (imprt != null && this._remove != null) {
            throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("onlyOneAllowed", new String[]{"import/remove"}));
        }
        ImportType oldValue = this._import;
        this._import = imprt;
        this.firePropertyChange("import", oldValue, this._import);
    }

    public ImportType getImport() {
        return this._import;
    }

    public ImportType defaultImport() {
        try {
            return new ImportType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addImport() throws ConfigurationException {
        if (this._import != null) {
            return;
        }
        ImportType imprt = new ImportType(this, null);
        this.setImport(imprt);
    }

    public void removeImport() throws ConfigurationException {
        if (this._import == null) {
            return;
        }
        this.setImport(null);
    }

    public void setRemove(RemoveType remove) throws ConfigurationException {
        if (remove != null && this._import != null) {
            throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("onlyOneAllowed", new String[]{"import/remove"}));
        }
        RemoveType oldValue = this._remove;
        this._remove = remove;
        this.firePropertyChange("remove", oldValue, this._remove);
    }

    public RemoveType getRemove() {
        return this._remove;
    }

    public RemoveType defaultRemove() {
        try {
            return new RemoveType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addRemove() throws ConfigurationException {
        if (this._remove != null) {
            return;
        }
        RemoveType remove = new RemoveType(this, null);
        this.setRemove(remove);
    }

    public void removeRemove() throws ConfigurationException {
        if (this._remove == null) {
            return;
        }
        this.setRemove(null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._import != null) {
            this._import.writeXML(out, indentation);
        }
        if (this._remove != null) {
            this._remove.writeXML(out, indentation);
        }
    }

    private void init() throws ConfigurationException {
        this.setXpath("");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ConfigBeanNode configBean;
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("import-shared-library")) {
                    configBean = new ImportType(this, node);
                    this.setImport((ImportType)configBean);
                    continue;
                }
                if (!name.equals("remove-inherited")) continue;
                configBean = new RemoveType(this, node);
                this.setRemove((RemoveType)configBean);
            }
        }
    }
}

