/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterMappingType
extends ConfigBeanNode {
    String filterName;
    String urlPattern;
    String servletName;
    String[] dispatchers;

    public FilterMappingType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("filter-mapping");
        ArrayList<String> dispatcherList = new ArrayList<String>();
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("filter-name")) {
                    this.filterName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("url-pattern")) {
                    this.urlPattern = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("servlet-name")) {
                    this.servletName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("dispatcher")) continue;
                dispatcherList.add(XMLUtils.getValue(childNodes.item(i)));
            }
        }
        if (!dispatcherList.isEmpty()) {
            this.dispatchers = dispatcherList.toArray(new String[0]);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "filter-mapping");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "filter-name", this.filterName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "url-pattern", this.urlPattern);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "servlet-name", this.servletName);
        if (this.getDispatchers().length != 0) {
            for (int i = 0; i < this.getDispatchers().length; ++i) {
                XMLUtils.writeTagWithValue(out, indentation + "\t", "dispatcher", this.getDispatchers()[i]);
            }
        }
        XMLUtils.writeTagEnd(out, indentation, "filter-mapping");
    }

    public String[] getDispatchers() {
        return this.dispatchers;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }
}

