/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;

public class EncryptTreeNode
extends ConfigTreeNode
implements ActionListener {
    private EncryptConfigType _bean;
    private static final String RECIPIENT_KEY_TEXT = "Recipient Key";
    private static final String ADD_RECIPIENT_KEY_MENU_STRING = "Add Recipient Key";
    private static final String ADD_ENCRYPTION_METHOD_MENU_STRING = "Add Encryption Method";
    private static final String ADD_KEY_TRANSPORT_METHOD_MENU_STRING = "Add Key Transport Method";
    private static final String ADD_TBE_ELEMENTS_MENU_STRING = "Add Tbe Elements";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_ENCRYPT_MENU_STRING = "Remove Encrypt";
    private JMenuItem _addRecipientKeyMenuItem;
    private JMenuItem _addEncryptionMethodMenuItem;
    private JMenuItem _addKeyTransportMethodMenuItem;
    private JMenuItem _addTbeElementsMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeEncryptMenuItem;

    public EncryptTreeNode(ConfigTreeNode rootNode, EncryptConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addRecipientKeyMenuItem = new JMenuItem(ADD_RECIPIENT_KEY_MENU_STRING);
        this._addRecipientKeyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRecipientKeyMenuItem.setFont(EncryptTreeNode.getFont());
        this._addRecipientKeyMenuItem.addActionListener(this);
        if (this._bean.getRecipientKey() != null) {
            this._addRecipientKeyMenuItem.setEnabled(false);
        }
        this._addEncryptionMethodMenuItem = new JMenuItem(ADD_ENCRYPTION_METHOD_MENU_STRING);
        this._addEncryptionMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEncryptionMethodMenuItem.setFont(EncryptTreeNode.getFont());
        this._addEncryptionMethodMenuItem.addActionListener(this);
        if (this._bean.getEncryptionMethod() != null) {
            this._addEncryptionMethodMenuItem.setEnabled(false);
        }
        this._addKeyTransportMethodMenuItem = new JMenuItem(ADD_KEY_TRANSPORT_METHOD_MENU_STRING);
        this._addKeyTransportMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addKeyTransportMethodMenuItem.setFont(EncryptTreeNode.getFont());
        this._addKeyTransportMethodMenuItem.addActionListener(this);
        if (this._bean.getKeyTransportMethod() != null) {
            this._addKeyTransportMethodMenuItem.setEnabled(false);
        }
        this._addTbeElementsMenuItem = new JMenuItem(ADD_TBE_ELEMENTS_MENU_STRING);
        this._addTbeElementsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTbeElementsMenuItem.setFont(EncryptTreeNode.getFont());
        this._addTbeElementsMenuItem.addActionListener(this);
        if (this._bean.getTbeElements() != null) {
            this._addTbeElementsMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(EncryptTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeEncryptMenuItem = new JMenuItem(REMOVE_ENCRYPT_MENU_STRING);
        this._removeEncryptMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeEncryptMenuItem.setFont(EncryptTreeNode.getFont());
        this._removeEncryptMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRecipientKeyMenuItem);
        this._popup.add(this._addEncryptionMethodMenuItem);
        this._popup.add(this._addKeyTransportMethodMenuItem);
        this._popup.add(this._addTbeElementsMenuItem);
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeEncryptMenuItem);
    }

    public String viewHeaderString() {
        return "Encrypt";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties;
        EncryptElementsConfigType tbeElements;
        KeyTransportMethodConfigType keyTransportMethod;
        EncryptionMethodConfigType encryptionMethod;
        KeyConfigType recipientKey = this._bean.getRecipientKey();
        if (recipientKey != null) {
            KeyConfigTreeNode recipientKeyTreeNode = new KeyConfigTreeNode(this.getRootNode(), recipientKey, RECIPIENT_KEY_TEXT);
            this.addChild(recipientKeyTreeNode);
        }
        if ((encryptionMethod = this._bean.getEncryptionMethod()) != null) {
            EncryptionMethodTreeNode encryptionMethodTreeNode = new EncryptionMethodTreeNode(this.getRootNode(), encryptionMethod);
            this.addChild(encryptionMethodTreeNode);
        }
        if ((keyTransportMethod = this._bean.getKeyTransportMethod()) != null) {
            KeyTransportMethodTreeNode keyTransportMethodTreeNode = new KeyTransportMethodTreeNode(this.getRootNode(), keyTransportMethod);
            this.addChild(keyTransportMethodTreeNode);
        }
        if ((tbeElements = this._bean.getTbeElements()) != null) {
            EncryptElementsTreeNode tbeElementsTreeNode = new EncryptElementsTreeNode(this.getRootNode(), tbeElements);
            this.addChild(tbeElementsTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_RECIPIENT_KEY_MENU_STRING)) {
                KeyConfigType newRecipientKey;
                if (this._bean.getRecipientKey() == null && this.showAddDialog(newRecipientKey = this._bean.defaultRecipientKey(), ADD_RECIPIENT_KEY_MENU_STRING)) {
                    this._bean.setRecipientKey(newRecipientKey);
                    KeyConfigTreeNode newNode = new KeyConfigTreeNode(this, newRecipientKey, RECIPIENT_KEY_TEXT);
                    this.insertNode(newNode);
                    this._addRecipientKeyMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_ENCRYPTION_METHOD_MENU_STRING)) {
                EncryptionMethodConfigType newEncryptionMethod = new EncryptionMethodConfigType(this._bean);
                if (this.showAddDialog(newEncryptionMethod, ADD_ENCRYPTION_METHOD_MENU_STRING)) {
                    this._bean.setEncryptionMethod(newEncryptionMethod);
                    EncryptionMethodTreeNode newNode = new EncryptionMethodTreeNode(this, newEncryptionMethod);
                    this.insertNode(newNode);
                    this._addEncryptionMethodMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_KEY_TRANSPORT_METHOD_MENU_STRING)) {
                KeyTransportMethodConfigType newKeyTransportMethod = new KeyTransportMethodConfigType(this._bean);
                if (this.showAddDialog(newKeyTransportMethod, ADD_KEY_TRANSPORT_METHOD_MENU_STRING)) {
                    this._bean.setKeyTransportMethod(newKeyTransportMethod);
                    KeyTransportMethodTreeNode newNode = new KeyTransportMethodTreeNode(this, newKeyTransportMethod);
                    this.insertNode(newNode);
                    this._addKeyTransportMethodMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_TBE_ELEMENTS_MENU_STRING)) {
                if (this._bean.getTbeElements() == null) {
                    this._bean.addTbeElements();
                    EncryptElementsTreeNode newNode = new EncryptElementsTreeNode(this, this._bean.getTbeElements());
                    this.insertNode(newNode);
                    this._addTbeElementsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_ENCRYPT_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof KeyConfigTreeNode) {
            KeyConfigTreeNode keyConfigTreeNode = (KeyConfigTreeNode)node;
            if (RECIPIENT_KEY_TEXT.equals(keyConfigTreeNode.getDisplayText())) {
                this._bean.removeRecipientKey();
                this.removeNode(node);
                this._addRecipientKeyMenuItem.setEnabled(true);
            }
        } else if (node instanceof EncryptionMethodTreeNode) {
            this._bean.removeEncryptionMethod();
            this.removeNode(node);
            this._addEncryptionMethodMenuItem.setEnabled(true);
        } else if (node instanceof KeyTransportMethodTreeNode) {
            this._bean.removeKeyTransportMethod();
            this.removeNode(node);
            this._addKeyTransportMethodMenuItem.setEnabled(true);
        } else if (node instanceof EncryptElementsTreeNode) {
            this._bean.removeTbeElements();
            this.removeNode(node);
            this._addTbeElementsMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

