/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbTransportSecurityConstraintType
extends ConfigBeanNode {
    String _wsdlUrl = null;
    String _soapPort = null;
    StringType[] _roleNames = null;
    StringType _transportGuarantee = null;
    StringType _oldTransportGuarantee = null;

    public EjbTransportSecurityConstraintType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public EjbTransportSecurityConstraintType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setWsdlUrl(String wsdlUrl) throws ConfigurationException {
        String oldValue = this._wsdlUrl;
        this._wsdlUrl = wsdlUrl;
        this.firePropertyChange("wsdlUrl", oldValue, this._wsdlUrl);
    }

    public String getWsdlUrl() {
        return this._wsdlUrl;
    }

    public String defaultWsdlUrl() {
        return "";
    }

    public void setSoapPort(String soapPort) throws ConfigurationException {
        String oldValue = this._soapPort;
        this._soapPort = soapPort;
        this.firePropertyChange("soapPort", oldValue, this._soapPort);
    }

    public String getSoapPort() {
        return this._soapPort;
    }

    public String defaultSoapPort() {
        return "";
    }

    public void setRoleNames(StringType[] roleNames) {
        this._roleNames = roleNames;
    }

    public StringType[] getRoleNames() {
        return this._roleNames;
    }

    public StringType[] defaultRoleNames() {
        return new StringType[0];
    }

    public void addRoleNames() {
        if (this._roleNames != null) {
            return;
        }
        StringType[] roleNames = new StringType[]{new StringType(this)};
        roleNames[0].putXpath("role-name");
        this.setRoleNames(roleNames);
    }

    public void removeRoleNames() {
        if (this._roleNames == null) {
            return;
        }
        this.setRoleNames(null);
    }

    public void addRoleName(StringType roleName) {
        roleName.putXpath("role-name");
        roleName.setValue(roleName.getValue());
        int existingRoleNamesCnt = 0;
        if (this._roleNames != null) {
            existingRoleNamesCnt = this._roleNames.length;
        }
        StringType[] newRoleNames = new StringType[existingRoleNamesCnt + 1];
        for (int n = 0; n < existingRoleNamesCnt; ++n) {
            newRoleNames[n] = this._roleNames[n];
        }
        newRoleNames[existingRoleNamesCnt] = roleName;
        StringType[] oldValue = this._roleNames;
        this._roleNames = newRoleNames;
        this.firePropertyChange("roleNames", oldValue, this._roleNames);
    }

    public void removeRoleName(StringType roleName) {
        int existingRoleNamesCnt = 0;
        if (this._roleNames != null) {
            existingRoleNamesCnt = this._roleNames.length;
        }
        StringType[] newRoleNames = new StringType[existingRoleNamesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingRoleNamesCnt; ++n) {
            if (roleName.equals(this._roleNames[n])) continue;
            newRoleNames[newIndex++] = this._roleNames[n];
        }
        StringType[] oldValue = this._roleNames;
        this._roleNames = newRoleNames;
        this.firePropertyChange("roleNames", oldValue, this._roleNames);
    }

    public void setTransportGuarantee(StringType transportGuarantee) throws ConfigurationException {
        this._transportGuarantee = transportGuarantee;
        this.firePropertyChange("transportGuarantee", this._oldTransportGuarantee, this._transportGuarantee);
        if (this._transportGuarantee != null) {
            if (this._oldTransportGuarantee == null) {
                this._oldTransportGuarantee = this.defaultTransportGuarantee();
            }
            this._oldTransportGuarantee.setValue(this._transportGuarantee.getValue());
        } else {
            this._oldTransportGuarantee = null;
        }
    }

    public StringType getTransportGuarantee() {
        return this._transportGuarantee;
    }

    public StringType defaultTransportGuarantee() {
        String[] tags = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
        return new StringType(this, tags, "NONE");
    }

    public void writeRoleNamesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._roleNames != null) {
            for (int n = 0; n < this._roleNames.length; ++n) {
                if (this._roleNames[n].getValue() == null || this._roleNames[n].getValue().length() <= 0) continue;
                XMLUtils.writeTag(out, indentation + "\t", "role-name", this._roleNames[n]);
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "ejb-transport-security-constraint");
        XMLUtils.writeTagAttributeEnd(out, indentation, "ejb-transport-security-constraint");
        if (this._wsdlUrl != null && this._wsdlUrl.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "wsdl-url", this._wsdlUrl);
        }
        if (this._soapPort != null && this._soapPort.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "soap-port", this._soapPort);
        }
        this.writeRoleNamesXML(out, indentation);
        if (this._transportGuarantee != null && this._transportGuarantee.getValue() != null && this._transportGuarantee.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "transport-guarantee", this._transportGuarantee);
        }
        XMLUtils.writeTagEnd(out, indentation, "ejb-transport-security-constraint");
    }

    private void init() throws ConfigurationException {
        this.setXpath("ejb-transport-security-constraint");
        Vector<StringType> roleNames = new Vector<StringType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("wsdl-url")) {
                    this.setWsdlUrl(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("soap-port")) {
                    this.setSoapPort(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("role-name")) {
                    StringType roleName = new StringType(this);
                    roleName.putXpath("role-name");
                    roleName.setValue(XMLUtils.getValue(node));
                    roleNames.add(roleName);
                    continue;
                }
                if (!name.equals("transport-guarantee")) continue;
                StringType transportGuarantee = this.defaultTransportGuarantee();
                transportGuarantee.setValue(XMLUtils.getValue(node));
                this.setTransportGuarantee(transportGuarantee);
            }
        }
        if (roleNames.size() > 0) {
            this._roleNames = roleNames.toArray(new StringType[0]);
        }
    }
}

