/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.DecryptConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptionMethodsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;

public class DecryptTreeNode
extends ConfigTreeNode
implements ActionListener {
    private DecryptConfigType _bean;
    private static final String ADD_ENCRYPTION_METHODS_MENU_STRING = "Add Encryption Methods";
    private static final String ADD_KEY_TRANSPORT_METHODS_MENU_STRING = "Add Key Transport Methods";
    private static final String ADD_TBE_ELEMENTS_MENU_STRING = "Add Tbe Elements";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_DECRYPT_MENU_STRING = "Remove Decrypt";
    private JMenuItem _addEncryptionMethodsMenuItem;
    private JMenuItem _addKeyTransportMethodsMenuItem;
    private JMenuItem _addTbeElementsMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeDecryptMenuItem;

    public DecryptTreeNode(ConfigTreeNode rootNode, DecryptConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addEncryptionMethodsMenuItem = new JMenuItem(ADD_ENCRYPTION_METHODS_MENU_STRING);
        this._addEncryptionMethodsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEncryptionMethodsMenuItem.setFont(DecryptTreeNode.getFont());
        this._addEncryptionMethodsMenuItem.addActionListener(this);
        if (this._bean.getEncryptionMethods() != null) {
            this._addEncryptionMethodsMenuItem.setEnabled(false);
        }
        this._addKeyTransportMethodsMenuItem = new JMenuItem(ADD_KEY_TRANSPORT_METHODS_MENU_STRING);
        this._addKeyTransportMethodsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addKeyTransportMethodsMenuItem.setFont(DecryptTreeNode.getFont());
        this._addKeyTransportMethodsMenuItem.addActionListener(this);
        if (this._bean.getKeyTransportMethods() != null) {
            this._addKeyTransportMethodsMenuItem.setEnabled(false);
        }
        this._addTbeElementsMenuItem = new JMenuItem(ADD_TBE_ELEMENTS_MENU_STRING);
        this._addTbeElementsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTbeElementsMenuItem.setFont(DecryptTreeNode.getFont());
        this._addTbeElementsMenuItem.addActionListener(this);
        if (this._bean.getTbeElements() != null) {
            this._addTbeElementsMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(DecryptTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeDecryptMenuItem = new JMenuItem(REMOVE_DECRYPT_MENU_STRING);
        this._removeDecryptMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeDecryptMenuItem.setFont(DecryptTreeNode.getFont());
        this._removeDecryptMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addEncryptionMethodsMenuItem);
        this._popup.add(this._addKeyTransportMethodsMenuItem);
        this._popup.add(this._addTbeElementsMenuItem);
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeDecryptMenuItem);
    }

    public String viewHeaderString() {
        return "Decrypt";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties;
        EncryptElementsConfigType tbeElements;
        KeyTransportMethodsConfigType keyTransportMethods;
        EncryptionMethodsConfigType encryptionMethods = this._bean.getEncryptionMethods();
        if (encryptionMethods != null) {
            EncryptionMethodsTreeNode encryptionMethodsTreeNode = new EncryptionMethodsTreeNode(this.getRootNode(), encryptionMethods);
            this.addChild(encryptionMethodsTreeNode);
        }
        if ((keyTransportMethods = this._bean.getKeyTransportMethods()) != null) {
            KeyTransportMethodsTreeNode keyTransportMethodsTreeNode = new KeyTransportMethodsTreeNode(this.getRootNode(), keyTransportMethods);
            this.addChild(keyTransportMethodsTreeNode);
        }
        if ((tbeElements = this._bean.getTbeElements()) != null) {
            EncryptElementsTreeNode tbeElementsTreeNode = new EncryptElementsTreeNode(this.getRootNode(), tbeElements);
            this.addChild(tbeElementsTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_ENCRYPTION_METHODS_MENU_STRING)) {
                if (this._bean.getEncryptionMethods() == null) {
                    this._bean.addEncryptionMethods();
                    EncryptionMethodsTreeNode newNode = new EncryptionMethodsTreeNode(this, this._bean.getEncryptionMethods());
                    this.insertNode(newNode);
                    this._addEncryptionMethodsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_KEY_TRANSPORT_METHODS_MENU_STRING)) {
                if (this._bean.getKeyTransportMethods() == null) {
                    this._bean.addKeyTransportMethods();
                    KeyTransportMethodsTreeNode newNode = new KeyTransportMethodsTreeNode(this, this._bean.getKeyTransportMethods());
                    this.insertNode(newNode);
                    this._addKeyTransportMethodsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_TBE_ELEMENTS_MENU_STRING)) {
                if (this._bean.getTbeElements() == null) {
                    this._bean.addTbeElements();
                    EncryptElementsTreeNode newNode = new EncryptElementsTreeNode(this, this._bean.getTbeElements());
                    this.insertNode(newNode);
                    this._addTbeElementsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_DECRYPT_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof EncryptionMethodsTreeNode) {
            this._bean.removeEncryptionMethods();
            this.removeNode(node);
            this._addEncryptionMethodsMenuItem.setEnabled(true);
        } else if (node instanceof KeyTransportMethodsTreeNode) {
            this._bean.removeKeyTransportMethods();
            this.removeNode(node);
            this._addKeyTransportMethodsMenuItem.setEnabled(true);
        } else if (node instanceof EncryptElementsTreeNode) {
            this._bean.removeTbeElements();
            this.removeNode(node);
            this._addTbeElementsMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

