/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextParamType
extends ConfigBeanNode {
    String name;
    String value;
    String description;

    public ContextParamType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("context-param");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("param-name")) {
                    this.name = XMLUtils.getValue(childNode);
                    continue;
                }
                if (nodeName.equals("param-value")) {
                    this.value = XMLUtils.getValue(childNode);
                    continue;
                }
                if (!nodeName.equals("description")) continue;
                this.description = XMLUtils.getValue(childNode);
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "context-param");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "param-name", this.name);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "param-value", this.value);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagEnd(out, indentation + "\t", "context-param");
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }
}

