/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigPropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConnectionPoolingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConnectionPoolingType;
import oracle.oc4j.admin.deploy.spi.xml.ConnectorFactoryType;
import oracle.oc4j.admin.deploy.spi.xml.FileTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.FileType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.XaRecoveryConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.XaRecoveryConfigType;

public class ConnectorFactoryTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConnectorFactoryType _bean;
    private static final String ADD_CONNECTION_POOLING_MENU_STRING = "Add Connection Pooling";
    private static final String ADD_LOG_MENU_STRING = "Add Log File";
    private static final String ADD_SECURITY_CONFIG_MENU_STRING = "Add Security Config";
    private static final String ADD_XA_RECOVERY_CONFIG_MENU_STRING = "Add XA Recovery Config";
    private static final String REMOVE_CONNECTOR_FACTORY_MENU_STRING = "Remove Connector Factory";
    private JMenuItem _addConnectionPoolingMenuItem;
    private JMenuItem _addLogMenuItem;
    private JMenuItem _addSecurityConfigMenuItem;
    private JMenuItem _addXaRecoveryConfigMenuItem;
    private JMenuItem _removeConnectorFactoryMenuItem;

    public ConnectorFactoryTreeNode(ConfigTreeNode rootNode, ConnectorFactoryType connectorFactory) {
        super(connectorFactory);
        this.setRootNode(rootNode);
        this._bean = connectorFactory;
        this._addConnectionPoolingMenuItem = new JMenuItem(ADD_CONNECTION_POOLING_MENU_STRING);
        this._addConnectionPoolingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addConnectionPoolingMenuItem.setFont(ConnectorFactoryTreeNode.getFont());
        this._addConnectionPoolingMenuItem.addActionListener(this);
        if (this._bean.getConnectionPooling() != null) {
            this._addConnectionPoolingMenuItem.setEnabled(false);
        }
        this._addLogMenuItem = new JMenuItem(ADD_LOG_MENU_STRING);
        this._addLogMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addLogMenuItem.setFont(ConnectorFactoryTreeNode.getFont());
        this._addLogMenuItem.addActionListener(this);
        if (this._bean.getLog() != null) {
            this._addLogMenuItem.setEnabled(false);
        }
        this._addSecurityConfigMenuItem = new JMenuItem(ADD_SECURITY_CONFIG_MENU_STRING);
        this._addSecurityConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSecurityConfigMenuItem.setFont(ConnectorFactoryTreeNode.getFont());
        this._addSecurityConfigMenuItem.addActionListener(this);
        if (this._bean.getSecurityConfig() != null) {
            this._addSecurityConfigMenuItem.setEnabled(false);
        }
        this._addXaRecoveryConfigMenuItem = new JMenuItem(ADD_XA_RECOVERY_CONFIG_MENU_STRING);
        this._addXaRecoveryConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addXaRecoveryConfigMenuItem.setFont(ConnectorFactoryTreeNode.getFont());
        this._addXaRecoveryConfigMenuItem.addActionListener(this);
        if (this._bean.getXaRecoveryConfig() != null) {
            this._addXaRecoveryConfigMenuItem.setEnabled(false);
        }
        this._removeConnectorFactoryMenuItem = new JMenuItem(REMOVE_CONNECTOR_FACTORY_MENU_STRING);
        this._removeConnectorFactoryMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeConnectorFactoryMenuItem.setFont(ConnectorFactoryTreeNode.getFont());
        this._removeConnectorFactoryMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addConnectionPoolingMenuItem);
        this._popup.add(this._addLogMenuItem);
        this._popup.add(this._addSecurityConfigMenuItem);
        this._popup.add(this._addXaRecoveryConfigMenuItem);
        this._popup.add(this._removeConnectorFactoryMenuItem);
    }

    public String viewHeaderString() {
        return "Connector Factory";
    }

    public String toString() {
        return this._bean.getConnectorName();
    }

    protected void buildChildJTree() {
        XaRecoveryConfigType xaRecoveryConfig;
        SecurityConfigType securityConfig;
        FileType log;
        try {
            Method xmlMethod = ConnectorFactoryType.class.getMethod("writeConfigPropertiesXML", PrintWriter.class, String.class);
            ConfigPropertiesTreeNode configPropertiesTreeNode = new ConfigPropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(configPropertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        ConnectionPoolingType connectionPooling = this._bean.getConnectionPooling();
        if (connectionPooling != null) {
            ConnectionPoolingTreeNode connectionPoolingTreeNode = new ConnectionPoolingTreeNode(this.getRootNode(), connectionPooling);
            this.addChild(connectionPoolingTreeNode);
        }
        if ((log = this._bean.getLog()) != null) {
            FileTreeNode fileTreeNode = new FileTreeNode(this.getRootNode(), log);
            this.addChild(fileTreeNode);
        }
        if ((securityConfig = this._bean.getSecurityConfig()) != null) {
            SecurityConfigTreeNode securityConfigTreeNode = new SecurityConfigTreeNode(this.getRootNode(), securityConfig);
            this.addChild(securityConfigTreeNode);
        }
        if ((xaRecoveryConfig = this._bean.getXaRecoveryConfig()) != null) {
            XaRecoveryConfigTreeNode xaRecoveryConfigTreeNode = new XaRecoveryConfigTreeNode(this.getRootNode(), xaRecoveryConfig);
            this.addChild(xaRecoveryConfigTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_CONNECTION_POOLING_MENU_STRING)) {
                ConnectionPoolingType newConnectionPooling = this._bean.defaultConnectionPooling();
                if (this.showAddDialog(newConnectionPooling, ADD_CONNECTION_POOLING_MENU_STRING)) {
                    this._bean.setConnectionPooling(newConnectionPooling);
                    ConnectionPoolingTreeNode newNode = new ConnectionPoolingTreeNode(this, newConnectionPooling);
                    this.insertNode(newNode);
                    this._addConnectionPoolingMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_LOG_MENU_STRING)) {
                FileType newLog = this._bean.defaultLog();
                if (this.showAddDialog(newLog, ADD_LOG_MENU_STRING)) {
                    this._bean.setLog(newLog);
                    FileTreeNode newNode = new FileTreeNode(this, newLog);
                    this.insertNode(newNode);
                    this._addLogMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SECURITY_CONFIG_MENU_STRING)) {
                SecurityConfigType newSecurityConfig = this._bean.defaultSecurityConfig();
                if (this.showAddDialog(newSecurityConfig, ADD_SECURITY_CONFIG_MENU_STRING)) {
                    this._bean.setSecurityConfig(newSecurityConfig);
                    SecurityConfigTreeNode newNode = new SecurityConfigTreeNode(this, newSecurityConfig);
                    this.insertNode(newNode);
                    this._addSecurityConfigMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_XA_RECOVERY_CONFIG_MENU_STRING)) {
                XaRecoveryConfigType newXaRecoveryConfig = this._bean.defaultXaRecoveryConfig();
                if (this.confirm(ADD_XA_RECOVERY_CONFIG_MENU_STRING)) {
                    this._bean.setXaRecoveryConfig(newXaRecoveryConfig);
                    XaRecoveryConfigTreeNode newNode = new XaRecoveryConfigTreeNode(this, newXaRecoveryConfig);
                    this.insertNode(newNode);
                    this._addXaRecoveryConfigMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_CONNECTOR_FACTORY_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ConnectionPoolingTreeNode) {
            this._bean.removeConnectionPooling();
            this.removeNode(node);
            this._addConnectionPoolingMenuItem.setEnabled(true);
        } else if (node instanceof FileTreeNode) {
            this._bean.removeLog();
            this.removeNode(node);
            this._addLogMenuItem.setEnabled(true);
        } else if (node instanceof SecurityConfigTreeNode) {
            this._bean.removeSecurityConfig();
            this.removeNode(node);
            this._addSecurityConfigMenuItem.setEnabled(true);
        } else if (node instanceof XaRecoveryConfigTreeNode) {
            this._bean.removeXaRecoveryConfig();
            this.removeNode(node);
            this._addXaRecoveryConfigMenuItem.setEnabled(true);
        }
    }
}

