/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.NonCmrFieldType;
import oracle.oc4j.admin.deploy.spi.xml.OcaFieldMappingType;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommitOptionType
extends ConfigBeanNode {
    StringType _mode = null;
    StringType _oldMode = null;
    String _numberOfBuckets = null;
    String _ttl = null;
    OcaFieldMappingType _ocaFieldMapping = null;
    NonCmrFieldType _nonCmrField = null;

    public CommitOptionType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public CommitOptionType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setMode(StringType mode) throws ConfigurationException {
        this._mode = mode;
        this.firePropertyChange("mode", this._oldMode, this._mode);
        if (this._mode != null) {
            if (this._oldMode == null) {
                this._oldMode = this.defaultMode();
            }
            this._oldMode.setValue(this._mode.getValue());
        } else {
            this._oldMode = null;
        }
    }

    public StringType getMode() {
        return this._mode;
    }

    public StringType defaultMode() {
        String[] tags = new String[]{"A", "B", "C"};
        return new StringType(this, tags, "C");
    }

    public void setNumberOfBuckets(String numberOfBuckets) {
        String oldValue = this._numberOfBuckets;
        this._numberOfBuckets = numberOfBuckets;
        this.firePropertyChange("numberOfBuckets", oldValue, this._numberOfBuckets);
    }

    public String getNumberOfBuckets() {
        return this._numberOfBuckets;
    }

    public String defaultNumberOfBuckets() {
        return "";
    }

    public void setTtl(String ttl) {
        String oldValue = this._ttl;
        this._ttl = ttl;
        this.firePropertyChange("ttl", oldValue, this._ttl);
    }

    public String getTtl() {
        return this._ttl;
    }

    public String defaultTtl() {
        return "";
    }

    public void setOcaFieldMapping(OcaFieldMappingType ocaFieldMapping) throws ConfigurationException {
        OcaFieldMappingType oldValue = this._ocaFieldMapping;
        this._ocaFieldMapping = ocaFieldMapping;
        this.firePropertyChange("ocaFieldMapping", oldValue, this._ocaFieldMapping);
    }

    public OcaFieldMappingType getOcaFieldMapping() {
        return this._ocaFieldMapping;
    }

    public OcaFieldMappingType defaultOcaFieldMapping() {
        try {
            return new OcaFieldMappingType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addOcaFieldMapping() throws ConfigurationException {
        if (this._ocaFieldMapping != null) {
            return;
        }
        OcaFieldMappingType ocaFieldMapping = new OcaFieldMappingType(this, null);
        this.setOcaFieldMapping(ocaFieldMapping);
    }

    public void removeOcaFieldMapping() throws ConfigurationException {
        if (this._ocaFieldMapping == null) {
            return;
        }
        this.setOcaFieldMapping(null);
    }

    public void setNonCmrField(NonCmrFieldType nonCmrField) throws ConfigurationException {
        NonCmrFieldType oldValue = this._nonCmrField;
        this._nonCmrField = nonCmrField;
        this.firePropertyChange("nonCmrField", oldValue, this._nonCmrField);
    }

    public NonCmrFieldType getNonCmrField() {
        return this._nonCmrField;
    }

    public NonCmrFieldType defaultNonCmrField() {
        try {
            return new NonCmrFieldType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addNonCmrField() throws ConfigurationException {
        if (this._nonCmrField != null) {
            return;
        }
        NonCmrFieldType nonCmrField = new NonCmrFieldType(this, null);
        this.setNonCmrField(nonCmrField);
    }

    public void removeNonCmrField() throws ConfigurationException {
        if (this._nonCmrField == null) {
            return;
        }
        this.setNonCmrField(null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "commit-option");
        XMLUtils.writeAttribute(out, indentation, "mode", this._mode);
        XMLUtils.writeAttribute(out, indentation, "number-of-buckets", this._numberOfBuckets);
        XMLUtils.writeAttribute(out, indentation, "ttl", this._ttl);
        XMLUtils.writeTagAttributeEnd(out, indentation, "commit-option");
        if (this._ocaFieldMapping != null) {
            this._ocaFieldMapping.writeXML(out, indentation + "\t");
        }
        if (this._nonCmrField != null) {
            this._nonCmrField.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "commit-option");
    }

    private void init() throws ConfigurationException {
        this.setXpath("commit-option");
        Vector params = new Vector();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "mode");
            if (val != null && !val.trim().equals("")) {
                StringType mode = this.defaultMode();
                mode.setValue(val);
                this.setMode(mode);
            }
            if ((val = XMLUtils.getAttribute(node, "number-of-buckets")) != null && !val.trim().equals("")) {
                this.setNumberOfBuckets(val);
            }
            if ((val = XMLUtils.getAttribute(node, "ttl")) != null && !val.trim().equals("")) {
                this.setTtl(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("oca-field-mapping")) {
                    this.setOcaFieldMapping(new OcaFieldMappingType(this, node));
                    continue;
                }
                if (!name.equals("non-cmr-field")) continue;
                this.setNonCmrField(new NonCmrFieldType(this, node));
            }
        }
    }
}

