/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationRuntimeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;

public class ClientOperationTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ClientOperationType _bean;
    private static final String ADD_RUNTIME_MENU_STRING = "Add Runtime";
    private static final String REMOVE_CLIENT_OPERATION_MENU_STRING = "Remove Client Operation";
    private JMenuItem _addRuntimeMenuItem;
    private JMenuItem _removeClientOperationMenuItem;

    public ClientOperationTreeNode(ConfigTreeNode rootNode, ClientOperationType clientOperation) {
        super(clientOperation);
        this.setRootNode(rootNode);
        this._bean = clientOperation;
        this._addRuntimeMenuItem = new JMenuItem(ADD_RUNTIME_MENU_STRING);
        this._addRuntimeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRuntimeMenuItem.setFont(ClientOperationTreeNode.getFont());
        this._addRuntimeMenuItem.addActionListener(this);
        if (this._bean.getRuntime() != null) {
            this._addRuntimeMenuItem.setEnabled(false);
        }
        this._removeClientOperationMenuItem = new JMenuItem(REMOVE_CLIENT_OPERATION_MENU_STRING);
        this._removeClientOperationMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeClientOperationMenuItem.setFont(ClientOperationTreeNode.getFont());
        this._removeClientOperationMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRuntimeMenuItem);
        this._popup.add(this._removeClientOperationMenuItem);
    }

    public String viewHeaderString() {
        return "Client Operation";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        ClientOperationRuntimeType runtime = this._bean.getRuntime();
        if (runtime != null) {
            ClientOperationRuntimeTreeNode clientOperationRuntimeTreeNode = new ClientOperationRuntimeTreeNode(this.getRootNode(), runtime);
            this.addChild(clientOperationRuntimeTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_RUNTIME_MENU_STRING)) {
                if (this._bean.getRuntime() == null) {
                    this._bean.addRuntime();
                    ClientOperationRuntimeTreeNode newNode = new ClientOperationRuntimeTreeNode(this, this._bean.getRuntime());
                    this.insertNode(newNode);
                    this._addRuntimeMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_CLIENT_OPERATION_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ClientOperationRuntimeTreeNode) {
            this._bean.removeRuntime();
            this.removeNode(node);
            this._addRuntimeMenuItem.setEnabled(true);
        }
    }
}

