/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.CallPropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.CallPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class CallPropertiesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_CALL_PROPERTY_MENU_STRING = "Add Call Property";
    private JMenuItem _addCallPropertyMenuItem;
    private CallPropertyType[] callPropertyType = new CallPropertyType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public CallPropertiesTreeNode(ConfigTreeNode rootNode, MultipleType callProperties) {
        super(callProperties);
        this.setRootNode(rootNode);
        this._parentBean = callProperties.getConfigParent();
        this._addCallPropertyMenuItem = new JMenuItem(ADD_CALL_PROPERTY_MENU_STRING);
        this._addCallPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addCallPropertyMenuItem.setFont(CallPropertiesTreeNode.getFont());
        this._addCallPropertyMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addCallPropertyMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getCallProperties", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addCallProperty", CallPropertyType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeCallProperty", CallPropertyType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Call Properties";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            CallPropertyType[] callProperties = (CallPropertyType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (callProperties != null) {
                for (int i = 0; i < callProperties.length; ++i) {
                    CallPropertyType callProperty = callProperties[i];
                    if (callProperty == null) continue;
                    CallPropertyTreeNode callPropertyTreeNode = new CallPropertyTreeNode(this.getRootNode(), callProperty);
                    this.addChild(callPropertyTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            CallPropertyType newCallProperty;
            if (event.getActionCommand().equals(ADD_CALL_PROPERTY_MENU_STRING) && this.showAddDialog(newCallProperty = new CallPropertyType(this._parentBean), ADD_CALL_PROPERTY_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newCallProperty);
                CallPropertyTreeNode newNode = new CallPropertyTreeNode(this, newCallProperty);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof CallPropertyTreeNode) {
            try {
                CallPropertyType callProperty = (CallPropertyType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, callProperty);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

