/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.HostAccessType;
import oracle.oc4j.admin.deploy.spi.xml.IpAccessType;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccessMaskType
extends ConfigBeanNode {
    HostAccessType[] _hostAccess = null;
    IpAccessType[] _ipAccess = null;
    StringType _default = null;
    StringType _oldDefault = null;

    public AccessMaskType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public AccessMaskType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setDefault(StringType def) throws ConfigurationException {
        this._default = def;
        this.firePropertyChange("default", this._oldDefault, this._default);
        if (this._default != null) {
            if (this._oldDefault == null) {
                this._oldDefault = this.defaultDefault();
            }
            this._oldDefault.setValue(this._default.getValue());
        } else {
            this._oldDefault = null;
        }
    }

    public StringType getDefault() {
        return this._default;
    }

    public StringType defaultDefault() {
        String[] tags = new String[]{"deny", "allow"};
        return new StringType(this, tags, "allow");
    }

    public void setHostAccess(HostAccessType[] hostAccess) throws ConfigurationException {
        HostAccessType[] oldValue = this._hostAccess;
        this._hostAccess = hostAccess;
        this.firePropertyChange("hostAccess", oldValue, this._hostAccess);
    }

    public HostAccessType[] getHostAccess() {
        return this._hostAccess;
    }

    public HostAccessType[] defaultHostAccess() {
        try {
            return new HostAccessType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addHostAccess() throws ConfigurationException {
        if (this._hostAccess != null) {
            return;
        }
        HostAccessType[] hostAccess = new HostAccessType[]{new HostAccessType(this, null)};
        this.setHostAccess(hostAccess);
    }

    public void removeHostAccess() throws ConfigurationException {
        if (this._hostAccess == null) {
            return;
        }
        this.setHostAccess(null);
    }

    public void addHostAccess(HostAccessType hostAccess) throws ConfigurationException {
        hostAccess.setParent(this);
        int existinghostAccessCnt = 0;
        if (this._hostAccess != null) {
            existinghostAccessCnt = this._hostAccess.length;
        }
        HostAccessType[] newHostAccess = new HostAccessType[existinghostAccessCnt + 1];
        for (int n = 0; n < existinghostAccessCnt; ++n) {
            newHostAccess[n] = this._hostAccess[n];
        }
        newHostAccess[existinghostAccessCnt] = hostAccess;
        HostAccessType[] oldValue = this._hostAccess;
        this._hostAccess = newHostAccess;
        this.firePropertyChange("hostAccess", oldValue, this._hostAccess);
    }

    public void removeHostAccess(HostAccessType hostAccess) throws ConfigurationException {
        int existinghostAccessCnt = 0;
        if (this._hostAccess != null) {
            existinghostAccessCnt = this._hostAccess.length;
        }
        HostAccessType[] newHostAccess = new HostAccessType[existinghostAccessCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existinghostAccessCnt; ++n) {
            if (hostAccess.equals(this._hostAccess[n])) continue;
            newHostAccess[newIndex++] = this._hostAccess[n];
        }
        if (newHostAccess.length == 0) {
            newHostAccess = null;
        }
        HostAccessType[] oldValue = this._hostAccess;
        this._hostAccess = newHostAccess;
        this.firePropertyChange("hostAccess", oldValue, this._hostAccess);
    }

    public void setIpAccess(IpAccessType[] ipAccess) throws ConfigurationException {
        IpAccessType[] oldValue = this._ipAccess;
        this._ipAccess = ipAccess;
        this.firePropertyChange("ipAccess", oldValue, this._ipAccess);
    }

    public IpAccessType[] getIpAccess() {
        return this._ipAccess;
    }

    public IpAccessType[] defaultIpAccess() {
        try {
            return new IpAccessType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addIpAccess() throws ConfigurationException {
        if (this._ipAccess != null) {
            return;
        }
        IpAccessType[] ipAccess = new IpAccessType[]{new IpAccessType(this, null)};
        this.setIpAccess(ipAccess);
    }

    public void removeIpAccess() throws ConfigurationException {
        if (this._ipAccess == null) {
            return;
        }
        this.setIpAccess(null);
    }

    public void addIpAccess(IpAccessType ipAccess) throws ConfigurationException {
        ipAccess.setParent(this);
        int existingipAccessCnt = 0;
        if (this._ipAccess != null) {
            existingipAccessCnt = this._ipAccess.length;
        }
        IpAccessType[] newIpAccess = new IpAccessType[existingipAccessCnt + 1];
        for (int n = 0; n < existingipAccessCnt; ++n) {
            newIpAccess[n] = this._ipAccess[n];
        }
        newIpAccess[existingipAccessCnt] = ipAccess;
        IpAccessType[] oldValue = this._ipAccess;
        this._ipAccess = newIpAccess;
        this.firePropertyChange("ipAccess", oldValue, this._ipAccess);
    }

    public void removeIpAccess(IpAccessType ipAccess) throws ConfigurationException {
        int existingipAccessCnt = 0;
        if (this._ipAccess != null) {
            existingipAccessCnt = this._ipAccess.length;
        }
        IpAccessType[] newIpAccess = new IpAccessType[existingipAccessCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingipAccessCnt; ++n) {
            if (ipAccess.equals(this._ipAccess[n])) continue;
            newIpAccess[newIndex++] = this._ipAccess[n];
        }
        if (newIpAccess.length == 0) {
            newIpAccess = null;
        }
        IpAccessType[] oldValue = this._ipAccess;
        this._ipAccess = newIpAccess;
        this.firePropertyChange("ipAccess", oldValue, this._ipAccess);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "access-mask");
        XMLUtils.writeAttribute(out, indentation, "default", this._default);
        XMLUtils.writeTagAttributeEnd(out, indentation, "access-mask");
        AccessMaskType.writeXML(out, indentation + "\t", this._hostAccess);
        AccessMaskType.writeXML(out, indentation + "\t", this._ipAccess);
        XMLUtils.writeTagEnd(out, indentation, "access-mask");
    }

    private void init() throws ConfigurationException {
        this.setXpath("access-mask");
        Vector<HostAccessType> hostAccess = new Vector<HostAccessType>();
        Vector<HostAccessType> ipAccess = new Vector<HostAccessType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "default");
            if (val != null && !val.trim().equals("")) {
                StringType def = this.defaultDefault();
                def.setValue(val);
                this.setDefault(def);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ConfigBeanNode configBean;
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("host-access")) {
                    configBean = new HostAccessType(this, node);
                    hostAccess.add((HostAccessType)configBean);
                    continue;
                }
                if (!name.equals("ip-access")) continue;
                configBean = new IpAccessType(this, node);
                ipAccess.add((HostAccessType)configBean);
            }
        }
        if (hostAccess.size() > 0) {
            this.setHostAccess(hostAccess.toArray(new HostAccessType[0]));
        }
        if (ipAccess.size() > 0) {
            this.setIpAccess(ipAccess.toArray(new IpAccessType[0]));
        }
    }

    public void writeHostAccessXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        HostAccessType.writeXML(out, indentation, this._hostAccess);
    }

    public void writeIpAccessXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        IpAccessType.writeXML(out, indentation, this._ipAccess);
    }
}

