/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.status;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import oracle.oc4j.admin.deploy.spi.ClusterHelper;
import oracle.oc4j.admin.deploy.spi.status.ClusterExtendedProgressEvent;
import oracle.oc4j.admin.deploy.spi.status.ExtendedProgressEvent;

public class CmdlineProgressListener
implements ProgressListener {
    private PrintWriter _out = null;
    private Object _monitor = null;
    private HashMap _states = null;
    private HashMap _instanceNames = null;
    private boolean _isCluster;
    private boolean _completed = false;

    public CmdlineProgressListener(OutputStream out, Object monitor) {
        this._out = new PrintWriter(out, true);
        this._monitor = monitor;
        this._states = new HashMap();
        this._instanceNames = new HashMap();
        this._isCluster = false;
    }

    public boolean isCompleted() {
        return this._completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleProgressEvent(ProgressEvent event) {
        StringBuffer msg = new StringBuffer();
        if (event instanceof ExtendedProgressEvent) {
            msg.append(((ExtendedProgressEvent)event).toCmdlineString());
            if (event instanceof ClusterExtendedProgressEvent) {
                this.handleClusterEvent((ClusterExtendedProgressEvent)event);
            }
        } else {
            msg.append(event.toString());
        }
        this._out.println(msg.toString());
        this._out.flush();
        if (!event.getDeploymentStatus().isRunning()) {
            if (this._isCluster) {
                this._out.println(this.getSummary());
                this._out.flush();
            }
            this._completed = true;
            Object object = this._monitor;
            synchronized (object) {
                this._monitor.notify();
            }
        }
    }

    private void handleClusterEvent(ClusterExtendedProgressEvent event) {
        this._isCluster = true;
        String targetName = event.getTargetID();
        StateType state = event.getSubTargetState();
        if (!this._instanceNames.containsKey(targetName)) {
            this._instanceNames.put(targetName, ClusterHelper.getTargetNameUniqueId(targetName));
        }
        if (!state.equals(StateType.RUNNING)) {
            this._states.put(this._instanceNames.get(targetName), state);
        }
    }

    private String getSummary() {
        StringBuffer buff = new StringBuffer();
        int size = this._states.size();
        buff.append("\n\n");
        buff.append("[Summary] There are total " + size + " instances in the operation.\n");
        int failCount = 0;
        Iterator it = this._states.keySet().iterator();
        while (it.hasNext()) {
            String instanceName = (String)it.next();
            StateType state = (StateType)this._states.get(instanceName);
            if (!state.equals(StateType.COMPLETED)) {
                ++failCount;
            }
            buff.append("[Summary] Operation " + state.toString() + " on " + instanceName + "\n");
        }
        if (failCount == 0) {
            buff.append("[Summary] Operation on cluster COMPLETED!\n");
        } else {
            buff.append("[Summary] Operation on cluster FAILED since " + failCount + " instanced failed!\n");
        }
        buff.append("\n");
        return buff.toString();
    }
}

