/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import javax.management.j2ee.statistics.Stats;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.spi.DataSourceInfo;
import oracle.oc4j.admin.deploy.spi.DataSourceInfoImpl;
import oracle.oc4j.admin.deploy.spi.EJBInfo;
import oracle.oc4j.admin.deploy.spi.EJBInfoImpl;
import oracle.oc4j.admin.deploy.spi.JavaMailInfo;
import oracle.oc4j.admin.deploy.spi.JavaMailInfoImpl;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.ServletInfo;
import oracle.oc4j.admin.deploy.spi.ServletInfoImpl;
import oracle.oc4j.admin.deploy.spi.TargetImpl;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.SharedLibraryImport;

public class TargetModuleIDImpl
implements ProprietaryTargetModuleID {
    private static Logger logger_ = TraceLogger.getLogger((Class)TargetModuleIDImpl.class);
    private Management mejb_ = null;
    private ObjectName j2eeDeployedObject_ = null;

    public TargetModuleIDImpl(Management mejb, ObjectName j2eeDeployedObject) {
        this.mejb_ = mejb;
        this.j2eeDeployedObject_ = j2eeDeployedObject;
    }

    public Target getTarget() {
        String j2eeServerName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String j2eeServerString = this.j2eeDeployedObject_.getDomain() + ":j2eeType=J2EEServer,name=" + j2eeServerName;
        ObjectName j2eeServer = ObjectNameFactory.create(j2eeServerString);
        return new TargetImpl(this.mejb_, j2eeServer);
    }

    public String getModuleID() {
        return this.j2eeDeployedObject_.toString();
    }

    public String getWebURL() {
        if (!this.j2eeDeployedObject_.getKeyProperty("j2eeType").equalsIgnoreCase("WebModule")) {
            return null;
        }
        String webUrl = null;
        try {
            webUrl = (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "webURL");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
        return webUrl;
    }

    public String toString() {
        return this.j2eeDeployedObject_.toString();
    }

    public TargetModuleID getParentTargetModuleID() {
        if (this.isJ2EEApplication()) {
            return null;
        }
        if (this.isResourceAdapterModule() & this.j2eeDeployedObject_.getKeyProperty("J2EEApplication").equalsIgnoreCase("default")) {
            return null;
        }
        String parentApplication = this.j2eeDeployedObject_.getDomain() + ":j2eeType=J2EEApplication,name=" + this.j2eeDeployedObject_.getKeyProperty("J2EEApplication") + ",J2EEServer=" + this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        ObjectName parentApplicationName = ObjectNameFactory.create(parentApplication);
        return new TargetModuleIDImpl(this.mejb_, parentApplicationName);
    }

    public TargetModuleID[] getChildTargetModuleID() {
        if (!this.isJ2EEApplication()) {
            return null;
        }
        ObjectName[] childModules = null;
        try {
            childModules = (ObjectName[])this.mejb_.getAttribute(this.j2eeDeployedObject_, "Modules");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
        if (childModules == null || childModules.length == 0) {
            return null;
        }
        TargetModuleID[] childTargetModuleID = new TargetModuleIDImpl[childModules.length];
        for (int i = 0; i < childModules.length; ++i) {
            childTargetModuleID[i] = new TargetModuleIDImpl(this.mejb_, childModules[i]);
        }
        return childTargetModuleID;
    }

    private final boolean isJ2EEApplication() {
        return this.j2eeDeployedObject_.getKeyProperty("j2eeType").equalsIgnoreCase("J2EEApplication");
    }

    private final boolean isResourceAdapterModule() {
        return this.j2eeDeployedObject_.getKeyProperty("j2eeType").equalsIgnoreCase("ResourceAdapterModule");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TargetModuleIDImpl)) {
            return false;
        }
        return this.j2eeDeployedObject_.equals(((TargetModuleIDImpl)obj).j2eeDeployedObject_);
    }

    public int hashCode() {
        return this.j2eeDeployedObject_.hashCode();
    }

    public long getStartTime() {
        try {
            Long startTime = (Long)this.mejb_.getAttribute(this.j2eeDeployedObject_, "startTime");
            return startTime;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getStandardDeploymentDescriptor() {
        try {
            String desc = (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "deploymentDescriptor");
            return desc;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getStandardWSDeploymentDescriptor() {
        try {
            String desc = (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "wsDeploymentDescriptor");
            return desc;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getProprietaryDeploymentDescriptor() {
        try {
            String desc = (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "proprietaryDeploymentDescriptor");
            return desc;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getProprietaryWSDeploymentDescriptor() {
        try {
            String desc = (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "proprietaryWsDeploymentDescriptor");
            return desc;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getDataSourcesDescriptor() {
        try {
            String desc = (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "dataSourcesDescriptor");
            return desc;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String listDataSources() {
        String appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String objName = domain + ":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + appName + ",J2EEServer=" + serverName;
        ObjectName securityProviderObjectName = ObjectNameFactory.create(objName);
        try {
            return (String)this.mejb_.invoke(securityProviderObjectName, "listDataSources", (Object[])new String[0], new String[0]);
        }
        catch (Exception ex) {
            throw new JMXRuntimeException(ex);
        }
    }

    public String listDataSourceConnectionPools() {
        String appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String objName = domain + ":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + appName + ",J2EEServer=" + serverName;
        ObjectName securityProviderObjectName = ObjectNameFactory.create(objName);
        try {
            return (String)this.mejb_.invoke(securityProviderObjectName, "listDataSourceConnectionPools", (Object[])new String[0], new String[0]);
        }
        catch (Exception ex) {
            throw new JMXRuntimeException(ex);
        }
    }

    public final DataSourceInfo[] getDataSources() {
        String appName = null;
        appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String searchPattern = domain + ":j2eeType=JDBCResource,J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        try {
            ObjectName targetPattern = ObjectNameFactory.create(searchPattern);
            Set targets = this.mejb_.queryNames(targetPattern, null);
            LinkedList<DataSourceInfoImpl> ds = new LinkedList<DataSourceInfoImpl>();
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ObjectName jdbcResource = (ObjectName)iter.next();
                String[] dsr = (String[])this.mejb_.getAttribute(jdbcResource, "jdbcDataSources");
                if (dsr == null) continue;
                for (int i = 0; i < dsr.length; ++i) {
                    ds.add(new DataSourceInfoImpl(this.mejb_, jdbcResource, new ObjectName(dsr[i])));
                }
            }
            DataSourceInfo[] dsInf = new DataSourceInfo[ds.size()];
            Iterator iterDs = ds.iterator();
            int targetCount = 0;
            while (iterDs.hasNext()) {
                dsInf[targetCount++] = (DataSourceInfo)iterDs.next();
            }
            return dsInf;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getJaznDataDescriptor() {
        String appName = null;
        appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String objName = domain + ":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + appName + ",J2EEServer=" + serverName;
        ObjectName securityProviderObjectName = ObjectNameFactory.create(objName);
        String jaznDesc = null;
        try {
            jaznDesc = (String)this.mejb_.invoke(securityProviderObjectName, "getJaznDataDescriptor", (Object[])new String[0], new String[0]);
        }
        catch (Exception ex) {
            jaznDesc = null;
        }
        return jaznDesc;
    }

    public String[] getLDAPLoginModuleOptionNames() {
        String appName = null;
        appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String objName = domain + ":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + appName + ",J2EEServer=" + serverName;
        ObjectName securityProviderObjectName = ObjectNameFactory.create(objName);
        String[] optionNames = null;
        try {
            optionNames = (String[])this.mejb_.invoke(securityProviderObjectName, "getLDAPLoginModuleOptions", (Object[])new String[0], new String[0]);
        }
        catch (Exception ex) {
            optionNames = null;
        }
        return optionNames;
    }

    public Map getLDAPLoginModuleDefaultOptions(String serverType) {
        String appName = null;
        appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String objName = domain + ":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + appName + ",J2EEServer=" + serverName;
        ObjectName securityProviderObjectName = ObjectNameFactory.create(objName);
        Map defaultOptions = null;
        try {
            defaultOptions = (Map)this.mejb_.invoke(securityProviderObjectName, "getLDAPLoginModuleDefaultOptions", new Object[]{serverType}, new String[]{"java.lang.String"});
        }
        catch (Exception ex) {
            defaultOptions = null;
        }
        return defaultOptions;
    }

    public Vector getLoginModules() {
        Vector loginModules;
        block3: {
            loginModules = null;
            String appName = null;
            try {
                if (!this.isJ2EEApplication()) {
                    return null;
                }
                appName = this.j2eeDeployedObject_.getKeyProperty("name");
                TargetImpl tgt = (TargetImpl)this.getTarget();
                String globalAppName = tgt.getDefaultApplication();
                String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
                String domain = this.j2eeDeployedObject_.getDomain();
                String objName = domain + ":j2eeType=Security,name=SecurityProvider,J2EEApplication=" + globalAppName + ",J2EEServer=" + serverName;
                ObjectName securityProviderObjectName = ObjectNameFactory.create(objName);
                loginModules = (Vector)this.mejb_.invoke(securityProviderObjectName, "listLoginModules", new Object[]{appName}, new String[]{"java.lang.String"});
            }
            catch (Exception ex) {
                if (!logger_.isLoggable(Level.SEVERE)) break block3;
                logger_.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return loginModules;
    }

    public JavaMailInfo[] getJavaMailSessions() {
        String appName = null;
        appName = this.isJ2EEApplication() ? this.j2eeDeployedObject_.getKeyProperty("name") : this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String domain = this.j2eeDeployedObject_.getDomain();
        String searchPattern = domain + ":j2eeType=JavaMailResource,J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        try {
            ObjectName targetPattern = ObjectNameFactory.create(searchPattern);
            Set targets = this.mejb_.queryNames(targetPattern, null);
            JavaMailInfo[] jmInf = new JavaMailInfo[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                jmInf[targetCount++] = new JavaMailInfoImpl(this.mejb_, (ObjectName)iter.next());
            }
            return jmInf;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public Set getUsers() {
        if (!this.isJ2EEApplication()) {
            return null;
        }
        try {
            Set users = (Set)this.mejb_.getAttribute(this.j2eeDeployedObject_, "allAccessibleUsers");
            return users;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public Set getGroups() {
        if (!this.isJ2EEApplication()) {
            return null;
        }
        try {
            Set groups = (Set)this.mejb_.getAttribute(this.j2eeDeployedObject_, "allAccessibleGroups");
            return groups;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public Stats getstats() {
        try {
            return (Stats)this.mejb_.getAttribute(this.j2eeDeployedObject_, "stats");
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public ServletInfo[] getServlets() {
        if (!this.j2eeDeployedObject_.getKeyProperty("j2eeType").equalsIgnoreCase("WebModule")) {
            return new ServletInfo[0];
        }
        String appName = this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String webModuleName = this.j2eeDeployedObject_.getKeyProperty("name");
        String domain = this.j2eeDeployedObject_.getDomain();
        String searchPattern = domain + ":j2eeType=Servlet,WebModule=" + webModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        try {
            ObjectName targetPattern = ObjectNameFactory.create(searchPattern);
            Set targets = this.mejb_.queryNames(targetPattern, null);
            ServletInfo[] sInf = new ServletInfo[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                sInf[targetCount++] = new ServletInfoImpl(this.mejb_, (ObjectName)iter.next());
            }
            return sInf;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public EJBInfo[] getEJBs() {
        if (!this.j2eeDeployedObject_.getKeyProperty("j2eeType").equalsIgnoreCase("EJBModule")) {
            return new EJBInfo[0];
        }
        String appName = this.j2eeDeployedObject_.getKeyProperty("J2EEApplication");
        String serverName = this.j2eeDeployedObject_.getKeyProperty("J2EEServer");
        String ejbModuleName = this.j2eeDeployedObject_.getKeyProperty("name");
        String domain = this.j2eeDeployedObject_.getDomain();
        String[] searchPatterns = new String[4];
        Set[] targets = new Set[4];
        searchPatterns[0] = domain + ":j2eeType=EntityBean,EJBModule=" + ejbModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        searchPatterns[1] = domain + ":j2eeType=MessageDrivenBean,EJBModule=" + ejbModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        searchPatterns[2] = domain + ":j2eeType=StatelessSessionBean,EJBModule=" + ejbModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        searchPatterns[3] = domain + ":j2eeType=StatefulSessionBean,EJBModule=" + ejbModuleName + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        try {
            for (int cnt = 0; cnt < 4; ++cnt) {
                ObjectName targetPattern = ObjectNameFactory.create(searchPatterns[cnt]);
                targets[cnt] = this.mejb_.queryNames(targetPattern, null);
            }
            EJBInfo[] eInf = new EJBInfo[targets[0].size() + targets[1].size() + targets[2].size() + targets[3].size()];
            int targetCount = 0;
            for (int i = 0; i < 4; ++i) {
                Iterator iter = targets[i].iterator();
                while (iter.hasNext()) {
                    eInf[targetCount++] = new EJBInfoImpl(this.mejb_, (ObjectName)iter.next());
                }
            }
            return eInf;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public ObjectName getObjectName() {
        return this.j2eeDeployedObject_;
    }

    public SharedLibraryImport[] getSharedLibraryImports() {
        try {
            return (SharedLibraryImport[])this.mejb_.getAttribute(this.j2eeDeployedObject_, "sharedLibraryImports");
        }
        catch (AttributeNotFoundException e) {
            return new SharedLibraryImport[0];
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getParentApplicationName() {
        try {
            return (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "parentApplicationName");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public String getWebSite() {
        try {
            return (String)this.mejb_.getAttribute(this.j2eeDeployedObject_, "webSite");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public Map getWebSiteBindings() {
        try {
            return (Map)this.mejb_.getAttribute(this.j2eeDeployedObject_, "webSiteBindings");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public Map getWebBindings(String webSite) {
        try {
            return (Map)this.mejb_.invoke(this.j2eeDeployedObject_, "getWebBindings", new Object[]{webSite}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public boolean getIIOPEnabled() {
        try {
            Boolean iiopEnabled = (Boolean)this.mejb_.getAttribute(this.j2eeDeployedObject_, "IIOPEnabled");
            return iiopEnabled;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }
}

