/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;
import oracle.oc4j.admin.deploy.spi.InternalRunner;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.jmx.client.deploy.OperationLifeCycle;
import oracle.oc4j.admin.jmx.client.deploy.UploadFileIterator;
import oracle.oc4j.admin.jmx.shared.EventTypeNotificationFilter;
import oracle.oc4j.admin.jmx.shared.RmiDomain;
import oracle.oc4j.admin.management.mejb.ProprietaryManagement;

public class InternalUploader
extends InternalRunner
implements OperationLifeCycle {
    private static int STATE_BEGIN = 0;
    private static int STATE_CANCELUPLOAD = 1;
    private static int STATE_ENDUPLOAD = 2;
    private Integer id_;
    private boolean isCancel_;
    private int state_;
    private ObjectName uploaderName_;
    private ObjectName mbean_;
    private String operation_;
    private Object[] params_;
    private String[] sigs_;

    private InternalUploader(Management mejb, String name, Target[] targetList, Object input, ObjectName mbean, String operation, Object[] params, String[] sigs, ProgressListener listener) {
        super(mejb, name, null, targetList, input, CommandType.DISTRIBUTE, listener);
        this.mbean_ = mbean;
        this.operation_ = operation;
        this.params_ = params;
        this.sigs_ = sigs;
        RmiDomain domain = ((ProprietaryManagement)this.mejb_).getDomain();
        this.uploaderName_ = domain.getUploaderName();
        this.setLifeCycleCallBackInterface(this);
        this.isCancel_ = false;
        this.state_ = STATE_BEGIN;
    }

    public static ProgressObject install(Management mejb, String name, Target[] targetList, Object input, ObjectName mbean, String operation, Object[] params, String[] sigs, ProgressListener listener) {
        if (targetList == null || targetList.length == 0) {
            throw new IllegalArgumentException("Invalid targetList. Cannot be null or empty.");
        }
        InternalUploader uploader = new InternalUploader(mejb, name, targetList, input, mbean, operation, params, sigs, listener);
        uploader.progressObject_.setMBeanObjectName(uploader.uploaderName_);
        uploader.startOperation();
        return uploader.progressObject_;
    }

    public void theRun() {
        this.uploadFile();
    }

    private void uploadFile() {
        UploadFileIterator iterator = null;
        Object id_ = null;
        boolean needUpload = true;
        Object[] params = null;
        String[] signature = null;
        try {
            if (this.archive_ instanceof File) {
                String hostName = ((ProprietaryManagement)this.mejb_).getDomain().getHost();
                if (DeploymentUtils.isLocalHost(hostName)) {
                    needUpload = false;
                } else {
                    iterator = new UploadFileIterator((File)this.archive_);
                }
            } else {
                iterator = new UploadFileIterator((InputStream)this.archive_);
            }
            if (needUpload) {
                if (!iterator.hasMoreBytes()) {
                    ExtendedRuntimeException ex = new ExtendedRuntimeException("Uploaded stream should not be empty!");
                    this.progressObject_.reportError(ex);
                    throw ex;
                }
                params = new Object[]{this.name_};
                signature = new String[]{"java.lang.String"};
                id_ = (Integer)this.mejb_.invoke(this.uploaderName_, "beginUpload", params, signature);
                EventTypeNotificationFilter filter = new EventTypeNotificationFilter("upload." + id_);
                this.mejb_.getListenerRegistry().addNotificationListener(this.uploaderName_, (NotificationListener)this.progressObject_, (NotificationFilter)filter, null);
                while (!this.isCancel_ && iterator.hasMoreBytes()) {
                    params = new Object[]{id_, iterator.getBytes()};
                    signature = new String[]{"java.lang.Integer", "[B"};
                    this.mejb_.invoke(this.uploaderName_, "upload", params, signature);
                }
                if (this.isCancel_) {
                    this.doCancel(this.uploaderName_);
                    this.state_ = STATE_CANCELUPLOAD;
                } else {
                    params = new Object[]{id_};
                    signature = new String[]{"java.lang.Integer"};
                    this.mejb_.invoke(this.uploaderName_, "endUpload", params, signature);
                    this.state_ = STATE_ENDUPLOAD;
                }
            }
            params = new Object[5];
            if (!needUpload) {
                EventTypeNotificationFilter filter = new EventTypeNotificationFilter("upload." + ((File)this.archive_).getAbsolutePath());
                this.mejb_.getListenerRegistry().addNotificationListener(this.uploaderName_, (NotificationListener)this.progressObject_, (NotificationFilter)filter, null);
            }
            params[0] = needUpload ? id_ : ((File)this.archive_).getAbsolutePath();
            params[1] = this.mbean_;
            params[2] = this.operation_;
            params[3] = this.params_;
            params[4] = this.sigs_;
            signature = new String[]{needUpload ? "java.lang.Integer" : "java.lang.String", "javax.management.ObjectName", "java.lang.String", "[Ljava.lang.Object;", "[Ljava.lang.String;"};
            this.mejb_.invoke(this.uploaderName_, "install", params, signature);
        }
        catch (DeploymentRuntimeException de) {
            throw (ExtendedRuntimeException)de.fillInStackTrace();
        }
        catch (IOException ioe) {
            throw new ExtendedRuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            throw new ExtendedRuntimeException(e);
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public void cancel() {
        if (this.state_ != STATE_ENDUPLOAD) {
            this.isCancel_ = true;
        }
    }

    public void stop() {
        throw new ExtendedRuntimeException("stop() is not supported!");
    }

    private void doCancel(ObjectName name) {
        Object[] params = new Object[]{this.id_};
        String[] signature = new String[]{"java.lang.Integer"};
        try {
            this.mejb_.invoke(name, "cancel", params, signature);
        }
        catch (Exception e) {
            throw new ExtendedRuntimeException("cancel: " + e.getMessage());
        }
    }
}

