/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.spi.InternalRunner;
import oracle.oc4j.admin.jmx.shared.EventTypeNotificationFilter;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;

public class InternalStateManager
extends InternalRunner {
    private ObjectName targetObject_ = null;
    CommandType operation_ = null;

    private InternalStateManager(Management mejb, ObjectName name, Target[] targetList, CommandType operation, ProgressListener listen) {
        super(mejb, "StateManagement", targetList, operation, listen, name);
        this.targetObject_ = name;
        this.operation_ = operation;
        this.init();
    }

    private InternalStateManager(Management mejb, ObjectName name, Target[] targetList, CommandType operation, ProgressListener listen, Map additionalParams) {
        super(mejb, "StateManagement", additionalParams, targetList, operation, listen, name);
        this.targetObject_ = name;
        this.operation_ = operation;
        this.init();
    }

    private InternalStateManager(Management mejb, ObjectName name, Target[] targetList, CommandType operation, ProgressListener listen, ObjectName jsr88Target) {
        super(mejb, "StateManagement", targetList, operation, listen, name);
        this.targetObject_ = jsr88Target;
        this.operation_ = operation;
        this.init();
    }

    private void init() {
        if (this.targetJ2eeServers_.length > 1) {
            throw new JMXRuntimeException("We do not currently support managing several objects at once");
        }
        HashSet<String> eventTypes = new HashSet<String>();
        if (this.operation_.equals(CommandType.START)) {
            eventTypes.add("j2ee.state.running");
            eventTypes.add("j2ee.state.starting");
        }
        if (this.operation_.equals(CommandType.STOP)) {
            eventTypes.add("j2ee.state.stopped");
            eventTypes.add("j2ee.state.stopping");
        }
        eventTypes.add("j2ee.state.failed");
        EventTypeNotificationFilter filter = new EventTypeNotificationFilter(eventTypes);
        try {
            this.mejb_.getListenerRegistry().addNotificationListener(this.targetObject_, (NotificationListener)this.progressObject_, (NotificationFilter)filter, null);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public static ProgressObject manageState(Management mejb, ObjectName name, Target[] targetList, CommandType operation, ProgressListener listen) {
        if (targetList == null || targetList.length == 0) {
            throw new IllegalArgumentException("Invalid targetList. Cannot be null or empty.");
        }
        String j2eeType = name.getKeyProperty("j2eeType");
        InternalStateManager stateManager = null;
        if (!"J2EEApplication".equals(j2eeType) && !"ResourceAdapterModule".equals(j2eeType)) {
            ObjectName targetObject = ObjectNameFactory.create(name.getDomain() + ":j2eeType=J2EEApplication,name=" + name.getKeyProperty("J2EEApplication") + ",J2EEServer=" + name.getKeyProperty("J2EEServer"));
            stateManager = new InternalStateManager(mejb, name, targetList, operation, listen, targetObject);
        } else {
            stateManager = new InternalStateManager(mejb, name, targetList, operation, listen);
        }
        stateManager.startOperation();
        return stateManager.progressObject_;
    }

    public static ProgressObject manageState(Management mejb, ObjectName name, Target[] targetList, CommandType operation, ProgressListener listen, Map additionalParams) {
        if (targetList == null || targetList.length == 0) {
            throw new IllegalArgumentException("Invalid targetList. Cannot be null or empty.");
        }
        String j2eeType = name.getKeyProperty("j2eeType");
        InternalStateManager stateManager = null;
        if (!"J2EEApplication".equals(j2eeType) && !"ResourceAdapterModule".equals(j2eeType)) {
            ObjectName targetObject = ObjectNameFactory.create(name.getDomain() + ":j2eeType=J2EEApplication,name=" + name.getKeyProperty("J2EEApplication") + ",J2EEServer=" + name.getKeyProperty("J2EEServer"));
            stateManager = new InternalStateManager(mejb, name, targetList, operation, listen, targetObject);
        } else {
            stateManager = new InternalStateManager(mejb, name, targetList, operation, listen, additionalParams);
        }
        stateManager.startOperation();
        return stateManager.progressObject_;
    }

    protected ObjectName getMBeanObjectName() throws RemoteException {
        return this.targetObject_;
    }

    public void theRun() {
        String[] signatures;
        Object[] params;
        String methodName = null;
        if (this.operation_.equals(CommandType.START)) {
            methodName = "start";
            params = new Object[]{};
            signatures = new String[]{};
        } else {
            methodName = "stop";
            params = new Object[1];
            signatures = new String[1];
            params[0] = this.extraParameters_;
            signatures[0] = "java.util.Map";
        }
        try {
            this.mejb_.invoke(this.targetObject_, methodName, params, signatures);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }
}

