/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.spi.ConfigSetAddApplication;
import oracle.oc4j.admin.deploy.spi.ConfigSetRemoveApplication;
import oracle.oc4j.admin.deploy.spi.ConfigSetStart;
import oracle.oc4j.admin.deploy.spi.ConfigSetStop;
import oracle.oc4j.admin.deploy.spi.DeplConfiguration;
import oracle.oc4j.admin.deploy.spi.DeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.DummyProgressObject;
import oracle.oc4j.admin.deploy.spi.InternalDeployer;
import oracle.oc4j.admin.deploy.spi.InternalStateManager;
import oracle.oc4j.admin.deploy.spi.InternalUploader;
import oracle.oc4j.admin.deploy.spi.J2EEWebSite;
import oracle.oc4j.admin.deploy.spi.J2EEWebSiteImpl;
import oracle.oc4j.admin.deploy.spi.LifeCycleListener;
import oracle.oc4j.admin.deploy.spi.NotificationListenerToLifeCycleListenerAdaptor;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.SharedModuleTypeHelper;
import oracle.oc4j.admin.deploy.spi.TargetImpl;
import oracle.oc4j.admin.deploy.spi.TargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedDeploymentManagerCreationException;
import oracle.oc4j.admin.jmx.client.ConfigurableThread;
import oracle.oc4j.admin.jmx.client.CoreRemoteMBeanServer;
import oracle.oc4j.admin.jmx.client.HeartBeatListener;
import oracle.oc4j.admin.jmx.client.ThreadPool;
import oracle.oc4j.admin.jmx.shared.ClusterDomain;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.mejb.MEjbFactory;
import oracle.oc4j.admin.management.mejb.ProprietaryManagement;
import oracle.oc4j.admin.management.shared.Constant;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public abstract class ConnectedDeploymentManagerBase
extends DeploymentManagerBase
implements ProprietaryConnectedDeploymentManager {
    private static Logger logger_ = TraceLogger.getLogger((Class)ConnectedDeploymentManagerBase.class);
    private static final String targetObjectNamePattern_ = "*:j2eeType=J2EEServer,*";
    protected Management mejb_ = null;
    protected boolean isConnected_ = false;
    private List currentTasks_ = new LinkedList();
    private TaskCleaner taskCleaner_ = new TaskCleaner();
    private ObjectName deployerName_ = null;

    protected ConnectedDeploymentManagerBase(Domain domain) throws DeploymentManagerCreationException {
        try {
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Creating DeploymentManager: " + this + " MEJB");
            }
            this.mejb_ = MEjbFactory.getManagement(domain);
            ((ProprietaryManagement)this.getMEJB()).setLocale(this.getDefaultLocale());
            this.deployerName_ = domain.getDeployerName();
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new ExtendedDeploymentManagerCreationException(t);
        }
        this.isConnected_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.isConnected_ = false;
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Releasing DeploymentManager: " + this);
        }
        List list = this.currentTasks_;
        synchronized (list) {
            block12: {
                Iterator iter = this.currentTasks_.iterator();
                try {
                    while (iter.hasNext()) {
                        ProgressObject progObj = (ProgressObject)iter.next();
                        DeploymentStatus depStatus = progObj.getDeploymentStatus();
                        while (depStatus.isRunning()) {
                            Thread.yield();
                            Thread.sleep(1000L);
                        }
                        iter.remove();
                    }
                }
                catch (InterruptedException e) {
                    if (!logger_.isLoggable(Level.FINE)) break block12;
                    logger_.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        if (this.mejb_ != null) {
            try {
                this.mejb_.remove();
            }
            catch (Exception re) {
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.log(Level.FINE, re.getMessage(), re);
                }
                throw new JMXRuntimeException(re);
            }
            this.mejb_ = null;
        }
    }

    public final boolean isConnected() {
        return this.isConnected_;
    }

    public Target[] getTargets() throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        try {
            ObjectName targetPattern = ObjectNameFactory.create(targetObjectNamePattern_);
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Target search pattern: " + targetPattern);
            }
            Set targets = this.mejb_.queryNames(targetPattern, null);
            Target[] targetArray = new TargetImpl[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                ObjectName nextTarget = (ObjectName)iter.next();
                targetArray[targetCount++] = new TargetImpl(this.mejb_, nextTarget);
                if (!logger_.isLoggable(Level.FINE)) continue;
                logger_.fine("Retrieved deployment target: " + nextTarget + " for DeploymentManager: " + this);
            }
            return targetArray;
        }
        catch (RemoteException re) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, re.getMessage(), re);
            }
            throw new JMXRuntimeException(re);
        }
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        ProgressListener listen = null;
        return this.internalDeploy(targetList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan, ProgressListener listen) throws IllegalStateException {
        return this.internalDeploy(targetList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressListener listen = null;
        return this.internalDeploy(targetList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws IllegalStateException {
        return this.internalDeploy(targetList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressListener listen = null;
        return this.internalDeploy(targetList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws IllegalStateException {
        return this.internalDeploy(targetList, moduleArchive, deploymentPlan, listen);
    }

    public final ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.start(moduleIDList, null);
    }

    public ProgressObject start(TargetModuleID[] moduleIDList, ProgressListener listen) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (moduleIDList == null) {
            return null;
        }
        if (moduleIDList.length == 0) {
            return new DummyProgressObject();
        }
        if (moduleIDList.length > 1) {
            throw new IllegalStateException("We can only process a single TargetModuleID per operation");
        }
        ObjectName appObjectName = ((ProprietaryTargetModuleID)moduleIDList[0]).getObjectName();
        Target[] targetList = new Target[]{moduleIDList[0].getTarget()};
        ProgressListener listn = listen;
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            listn = new ConfigSetStart((CoreRemoteMBeanServer)this.mejb_, listen, appObjectName);
        }
        ProgressObject progObj = InternalStateManager.manageState(this.mejb_, appObjectName, targetList, CommandType.START, listn);
        this.addTask(progObj);
        return progObj;
    }

    public final ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.stop(moduleIDList, null, null);
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList, ProgressListener listen) throws IllegalStateException {
        return this.stop(moduleIDList, listen, null);
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList, ProgressListener listen, Map params) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (moduleIDList == null) {
            return null;
        }
        if (moduleIDList.length > 1) {
            throw new IllegalStateException("We can only process a single TargetModuleID per operation");
        }
        ObjectName appObjectName = ((ProprietaryTargetModuleID)moduleIDList[0]).getObjectName();
        Target[] targetList = new Target[]{moduleIDList[0].getTarget()};
        ProgressListener listn = listen;
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            listn = new ConfigSetStop((CoreRemoteMBeanServer)this.mejb_, listen, appObjectName);
        }
        ProgressObject progObj = InternalStateManager.manageState(this.mejb_, appObjectName, targetList, CommandType.STOP, listn, params);
        this.addTask(progObj);
        return progObj;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, "getRunningModules");
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, "getNonRunningModules");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (targetList == null) {
            return null;
        }
        if (moduleType == null) {
            throw new IllegalStateException("moduleType parameter cannot be null");
        }
        Set[] deployedObjects = new Set[targetList.length];
        int deployedObjectsCount = 0;
        String searchPattern = null;
        if (moduleType.getValue() == ModuleType.EAR.getValue()) {
            searchPattern = "*:j2eeType=J2EEApplication,J2EEServer=";
        }
        if (moduleType.getValue() == ModuleType.WAR.getValue()) {
            searchPattern = "*:j2eeType=WebModule,J2EEServer=";
        }
        if (moduleType.getValue() == ModuleType.EJB.getValue()) {
            searchPattern = "*:j2eeType=EJBModule,J2EEServer=";
        }
        if (moduleType.getValue() == ModuleType.RAR.getValue()) {
            searchPattern = "*:j2eeType=ResourceAdapterModule,J2EEServer=";
        }
        if (moduleType.getValue() == ModuleType.CAR.getValue()) {
            searchPattern = "*:j2eeType=AppClientModule,J2EEServer=";
        }
        for (int i = 0; i < targetList.length; ++i) {
            TargetImpl trgt = (TargetImpl)targetList[i];
            ObjectName j2eeServer = trgt.getObjectName();
            String serverName = j2eeServer.getKeyProperty("name");
            String sPattern = searchPattern + serverName + ",*";
            try {
                ObjectName targetPattern = ObjectNameFactory.create(sPattern);
                deployedObjects[i] = this.mejb_.queryNames(targetPattern, null);
            }
            catch (RemoteException re) {
                if (logger_.isLoggable(Level.SEVERE)) {
                    logger_.log(Level.SEVERE, re.getMessage(), re);
                }
                throw new JMXRuntimeException(re);
            }
            if (deployedObjects[i] == null) continue;
            deployedObjectsCount += deployedObjects[i].size();
        }
        TargetModuleID[] tgtModId = new TargetModuleIDImpl[deployedObjectsCount];
        int count = 0;
        for (int i = 0; i < targetList.length; ++i) {
            if (deployedObjects[i] == null) continue;
            Iterator iter = deployedObjects[i].iterator();
            while (iter.hasNext()) {
                tgtModId[count++] = new TargetModuleIDImpl(this.mejb_, (ObjectName)iter.next());
            }
        }
        return tgtModId;
    }

    public final ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.undeploy(moduleIDList, null);
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList, ProgressListener listen) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        boolean isUndeploy = true;
        HashMap values = DeploymentUtils.parseTargets(moduleIDList, isUndeploy);
        String appName = (String)values.get("applicationID");
        Target[] targetList = (Target[])values.get("targetList");
        SharedModuleType moduleType = (SharedModuleType)values.get("moduleType");
        ProgressListener listn = listen;
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            listn = new ConfigSetRemoveApplication((CoreRemoteMBeanServer)this.mejb_, listen, appName);
        }
        ProgressObject progObj = InternalDeployer.undeploy(this.mejb_, appName, targetList, listn, moduleType);
        this.addTask(progObj);
        return progObj;
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ProgressListener listen = null;
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan, ProgressListener listen) throws UnsupportedOperationException, IllegalStateException {
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan, ProgressListener listen, boolean keepSettings) throws UnsupportedOperationException, IllegalStateException {
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, keepSettings);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ProgressListener listen = null;
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws UnsupportedOperationException, IllegalStateException {
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, InputStream deploymentPlan, ProgressListener listen, boolean keepSettings) throws UnsupportedOperationException, IllegalStateException {
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, keepSettings);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ProgressListener listen = null;
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws UnsupportedOperationException, IllegalStateException {
        return this.internalRedeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject install(String name, Target[] targetList, Object input, ObjectName mbean, String operation, Object[] params, String[] sigs, ProgressListener listener) {
        return InternalUploader.install(this.mejb_, name, targetList, input, mbean, operation, params, sigs, listener);
    }

    public final void addLifeCycleListener(LifeCycleListener listener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        ObjectName mbeanServerDelegate = ObjectNameFactory.create("JMImplementation:type=MBeanServerDelegate");
        NotificationListenerToLifeCycleListenerAdaptor notificationListener = new NotificationListenerToLifeCycleListenerAdaptor(listener, this.mejb_);
        try {
            this.mejb_.getListenerRegistry().addNotificationListener(mbeanServerDelegate, (NotificationListener)notificationListener, null, null);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final void removeLifeCycleListener(LifeCycleListener listener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        ObjectName mbeanServerDelegate = ObjectNameFactory.create("JMImplementation:type=MBeanServerDelegate");
        NotificationListener notificationListener = listener.getListenerAssociation();
        try {
            this.mejb_.getListenerRegistry().removeNotificationListener(mbeanServerDelegate, notificationListener);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    private TargetModuleID[] getModules(ModuleType moduleType, Target[] targetList, String state) throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (targetList == null) {
            return null;
        }
        if (moduleType == null) {
            throw new IllegalStateException("moduleType parameter cannot be null");
        }
        HashSet<ObjectName> targets = new HashSet<ObjectName>();
        for (int i = 0; i < targetList.length; ++i) {
            ObjectName j2eeServer = ((ProprietaryTarget)targetList[i]).getObjectName();
            targets.add(j2eeServer);
        }
        Object[] params = new Object[]{SharedModuleTypeHelper.getSharedModuleType(moduleType), targets};
        String[] signs = new String[]{"oracle.oc4j.admin.management.shared.SharedModuleType", "java.util.Set"};
        Set runningModules = null;
        try {
            runningModules = (Set)this.mejb_.invoke(Constant.deploymentManagerProxyObjectName, state, params, signs);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
        TargetModuleID[] res = new TargetModuleID[runningModules.size()];
        Iterator iter = runningModules.iterator();
        int count = 0;
        while (iter.hasNext()) {
            res[count++] = new TargetModuleIDImpl(this.mejb_, (ObjectName)iter.next());
        }
        return res;
    }

    public final void addHeartBeatListener(HeartBeatListener listener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        ((ProprietaryManagement)this.mejb_).addHeartBeatListener(listener);
    }

    public final void removeHeartBeatListener(HeartBeatListener listener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        ((ProprietaryManagement)this.mejb_).removeHeartBeatListener(listener);
    }

    public J2EEWebSite[] getJ2EEWebSites(Target tgt) {
        ObjectName[] webSites = null;
        try {
            webSites = (ObjectName[])this.mejb_.getAttribute(((ProprietaryTarget)tgt).getObjectName(), "J2eeWebSites");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
        J2EEWebSite[] j2eeWebSites = new J2EEWebSite[webSites.length];
        for (int i = 0; i < webSites.length; ++i) {
            j2eeWebSites[i] = new J2EEWebSiteImpl(this.mejb_, webSites[i]);
        }
        return j2eeWebSites;
    }

    public TargetModuleID getTargetModuleIDForApplication(String name, Target tgt) {
        if (name == null) {
            return null;
        }
        String pattn = "*:j2eeType=J2EEApplication,name=" + name + ",J2EEServer=";
        return this.getTargetModuleIDForPattern(pattn, tgt);
    }

    public TargetModuleID getTargetModuleIDForPattern(String pattn, Target tgt) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (tgt == null || pattn == null) {
            return null;
        }
        Set res = null;
        ObjectName j2eeServer = ((ProprietaryTarget)tgt).getObjectName();
        String serverName = j2eeServer.getKeyProperty("name");
        String searchPattern = pattn + serverName + ",*";
        try {
            ObjectName targetPattern = ObjectNameFactory.create(searchPattern);
            res = this.mejb_.queryNames(targetPattern, null);
        }
        catch (RemoteException re) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, re.getMessage(), re);
            }
            throw new JMXRuntimeException(re);
        }
        if (res == null || res.size() == 0) {
            return null;
        }
        ObjectName appObjectName = (ObjectName)res.iterator().next();
        TargetModuleIDImpl tgtModId = new TargetModuleIDImpl(this.mejb_, appObjectName);
        return tgtModId;
    }

    public ProgressObject start(Target j2eeServer, ProgressListener listen) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (j2eeServer == null) {
            return null;
        }
        ObjectName serverObjectName = ((ProprietaryTarget)j2eeServer).getObjectName();
        Target[] targetList = new Target[]{j2eeServer};
        ProgressListener listn = listen;
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            listn = new ConfigSetStart((CoreRemoteMBeanServer)this.mejb_, listen, serverObjectName);
        }
        ProgressObject progObj = InternalStateManager.manageState(this.mejb_, serverObjectName, targetList, CommandType.START, listn);
        this.addTask(progObj);
        return progObj;
    }

    public ProgressObject stop(Target j2eeServer, ProgressListener listen) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (j2eeServer == null) {
            return null;
        }
        ObjectName serverObjectName = ((ProprietaryTarget)j2eeServer).getObjectName();
        Target[] targetList = new Target[]{j2eeServer};
        ProgressListener listn = listen;
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            listn = new ConfigSetStop((CoreRemoteMBeanServer)this.mejb_, listen, serverObjectName);
        }
        ProgressObject progObj = InternalStateManager.manageState(this.mejb_, serverObjectName, targetList, CommandType.STOP, listn);
        this.addTask(progObj);
        return progObj;
    }

    public void bindWebApp(TargetModuleID moduleID, String siteName) {
        this.bindWebApp(moduleID, siteName, (HashMap)null);
    }

    /*
     * Loose catch block
     */
    public void bindWebApp(TargetModuleID moduleID, String siteName, HashMap optionalParams) {
        block14: {
            ObjectName tgtMod = ObjectNameFactory.create(moduleID.getModuleID());
            if (!tgtMod.getKeyProperty("j2eeType").equalsIgnoreCase("J2EEApplication")) {
                throw new JMXRuntimeException("bindWebApp(moduleID, siteName), moduleID has to be a J2EEApplication!");
            }
            String appName = tgtMod.getKeyProperty("name");
            Object[] params = new Object[]{appName, siteName, optionalParams};
            String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.util.HashMap"};
            try {
                this.mejb_.invoke(this.deployerName_, "bindWebApp", params, signatures);
                if (!(((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain)) break block14;
                ClusterDomain clustDom = (ClusterDomain)((Object)((CoreRemoteMBeanServer)this.mejb_).getDomain());
                Domain[] syncDoms = clustDom.getSynchronizationDomains(((CoreRemoteMBeanServer)this.mejb_).portInUse());
                Management mejbSync = null;
                if (syncDoms == null || syncDoms.length == 0) break block14;
                for (int i = 0; i < syncDoms.length; ++i) {
                    mejbSync = MEjbFactory.getManagement(syncDoms[i]);
                    mejbSync.invoke(this.deployerName_, "bindWebApp", params, signatures);
                    Object var14_13 = null;
                    if (mejbSync == null) continue;
                    try {
                        mejbSync.remove();
                    }
                    catch (Throwable te) {
                        if (!logger_.isLoggable(Level.FINE)) continue;
                        logger_.log(Level.FINE, te.getMessage(), te);
                    }
                    continue;
                    {
                        catch (Exception t) {
                            if (logger_.isLoggable(Level.SEVERE)) {
                                logger_.log(Level.SEVERE, t.getMessage(), t);
                            }
                            throw new JMXRuntimeException(t);
                        }
                    }
                    catch (Throwable throwable) {
                        block15: {
                            var14_13 = null;
                            if (mejbSync != null) {
                                try {
                                    mejbSync.remove();
                                }
                                catch (Throwable te) {
                                    if (!logger_.isLoggable(Level.FINE)) break block15;
                                    logger_.log(Level.FINE, te.getMessage(), te);
                                }
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                if (logger_.isLoggable(Level.SEVERE)) {
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
                throw new JMXRuntimeException(e);
            }
        }
    }

    public void bindWebApp(TargetModuleID moduleID, String siteName, String contextRoot) {
        this.bindWebApp(moduleID, siteName, contextRoot, (HashMap)null);
    }

    /*
     * Loose catch block
     */
    public void bindWebApp(TargetModuleID moduleID, String siteName, String contextRoot, HashMap optionalParams) {
        block15: {
            ObjectName tgtMod = ObjectNameFactory.create(moduleID.getModuleID());
            String webName = null;
            String j2eeType = tgtMod.getKeyProperty("j2eeType");
            if (!j2eeType.equalsIgnoreCase("WebModule") && !j2eeType.equalsIgnoreCase("EJBModule")) {
                throw new JMXRuntimeException("bindWebApp(moduleID, siteName, contextRoot), moduleID: " + moduleID + " has to be a WebModule or an EJBModule with web-services");
            }
            webName = ObjectNameFactory.create(moduleID.getModuleID()).getKeyProperty("name");
            if (j2eeType.equalsIgnoreCase("EJBModule")) {
                webName = ObjectName.unquote(webName);
            }
            TargetModuleIDImpl parentModuleID = (TargetModuleIDImpl)moduleID.getParentTargetModuleID();
            String appName = ObjectNameFactory.create(parentModuleID.getModuleID()).getKeyProperty("name");
            Object[] params = new Object[]{appName, webName, siteName, contextRoot, optionalParams};
            String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.HashMap"};
            try {
                this.mejb_.invoke(this.deployerName_, "bindWebApp", params, signatures);
                if (!(((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain)) break block15;
                ClusterDomain clustDom = (ClusterDomain)((Object)((CoreRemoteMBeanServer)this.mejb_).getDomain());
                Domain[] syncDoms = clustDom.getSynchronizationDomains(((CoreRemoteMBeanServer)this.mejb_).portInUse());
                Management mejbSync = null;
                if (syncDoms == null || syncDoms.length == 0) break block15;
                for (int i = 0; i < syncDoms.length; ++i) {
                    mejbSync = MEjbFactory.getManagement(syncDoms[i]);
                    mejbSync.invoke(this.deployerName_, "bindWebApp", params, signatures);
                    Object var18_17 = null;
                    if (mejbSync == null) continue;
                    try {
                        mejbSync.remove();
                    }
                    catch (Throwable te) {
                        if (!logger_.isLoggable(Level.FINE)) continue;
                        logger_.log(Level.FINE, te.getMessage(), te);
                    }
                    continue;
                    {
                        catch (Exception t) {
                            if (logger_.isLoggable(Level.SEVERE)) {
                                logger_.log(Level.SEVERE, t.getMessage(), t);
                            }
                            throw new JMXRuntimeException(t);
                        }
                    }
                    catch (Throwable throwable) {
                        block16: {
                            var18_17 = null;
                            if (mejbSync != null) {
                                try {
                                    mejbSync.remove();
                                }
                                catch (Throwable te) {
                                    if (!logger_.isLoggable(Level.FINE)) break block16;
                                    logger_.log(Level.FINE, te.getMessage(), te);
                                }
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                if (logger_.isLoggable(Level.SEVERE)) {
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
                throw new JMXRuntimeException(e);
            }
        }
    }

    public void bindWebApp(TargetModuleID[] moduleIDs, String siteName) {
        this.bindWebApp(moduleIDs, siteName, (HashMap)null);
    }

    public void bindWebApp(TargetModuleID[] moduleIDs, String siteName, HashMap optionalParams) {
        for (int i = 0; i < moduleIDs.length; ++i) {
            this.bindWebApp(moduleIDs[i], siteName, optionalParams);
        }
    }

    public void bindWebApp(TargetModuleID[] moduleIDs, String siteName, String contextRoot) {
        this.bindWebApp(moduleIDs, siteName, contextRoot, (HashMap)null);
    }

    public void bindWebApp(TargetModuleID[] moduleIDs, String siteName, String contextRoot, HashMap optionalParams) {
        for (int i = 0; i < moduleIDs.length; ++i) {
            this.bindWebApp(moduleIDs[i], siteName, contextRoot, optionalParams);
        }
    }

    public void unbindWebApp(TargetModuleID[] moduleIDs, String siteName) {
        for (int i = 0; i < moduleIDs.length; ++i) {
            this.unbindWebApp(moduleIDs[i], siteName);
        }
    }

    /*
     * Loose catch block
     */
    public void unbindWebApp(TargetModuleID moduleID, String siteName) {
        block18: {
            ObjectName tgtMod = ObjectNameFactory.create(moduleID.getModuleID());
            String webName = null;
            String appName = null;
            String j2eeType = tgtMod.getKeyProperty("j2eeType");
            if (j2eeType.equalsIgnoreCase("J2EEApplication")) {
                appName = tgtMod.getKeyProperty("name");
            } else if (j2eeType.equalsIgnoreCase("WebModule") || j2eeType.equalsIgnoreCase("EJBModule")) {
                TargetModuleIDImpl parentModuleID = (TargetModuleIDImpl)moduleID.getParentTargetModuleID();
                appName = ObjectNameFactory.create(parentModuleID.getModuleID()).getKeyProperty("name");
                webName = ObjectNameFactory.create(moduleID.getModuleID()).getKeyProperty("name");
            } else {
                throw new JMXRuntimeException("unbindWebApp(moduleID, siteName), moduleID: " + moduleID + " has to be a WebModule or an EJBModule with web-services");
            }
            if (j2eeType.equalsIgnoreCase("EJBModule")) {
                webName = ObjectName.unquote(webName);
            }
            Object[] params = new Object[]{appName, webName, siteName};
            String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            try {
                this.mejb_.invoke(this.deployerName_, "unbindWebApp", params, signatures);
                if (!(((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain)) break block18;
                ClusterDomain clustDom = (ClusterDomain)((Object)((CoreRemoteMBeanServer)this.mejb_).getDomain());
                Domain[] syncDoms = clustDom.getSynchronizationDomains(((CoreRemoteMBeanServer)this.mejb_).portInUse());
                Management mejbSync = null;
                if (syncDoms == null || syncDoms.length == 0) break block18;
                for (int i = 0; i < syncDoms.length; ++i) {
                    mejbSync = MEjbFactory.getManagement(syncDoms[i]);
                    mejbSync.invoke(this.deployerName_, "unbindWebApp", params, signatures);
                    Object var15_14 = null;
                    if (mejbSync == null) continue;
                    try {
                        mejbSync.remove();
                    }
                    catch (Throwable te) {
                        if (!logger_.isLoggable(Level.FINE)) continue;
                        logger_.log(Level.FINE, te.getMessage(), te);
                    }
                    continue;
                    {
                        catch (Exception t) {
                            if (logger_.isLoggable(Level.SEVERE)) {
                                logger_.log(Level.SEVERE, t.getMessage(), t);
                            }
                            throw new JMXRuntimeException(t);
                        }
                    }
                    catch (Throwable throwable) {
                        block19: {
                            var15_14 = null;
                            if (mejbSync != null) {
                                try {
                                    mejbSync.remove();
                                }
                                catch (Throwable te) {
                                    if (!logger_.isLoggable(Level.FINE)) break block19;
                                    logger_.log(Level.FINE, te.getMessage(), te);
                                }
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                if (logger_.isLoggable(Level.SEVERE)) {
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
                throw new JMXRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addTask(ProgressObject progObj) {
        boolean clean = false;
        List list = this.currentTasks_;
        synchronized (list) {
            this.currentTasks_.add(progObj);
            if (this.currentTasks_.size() > 100) {
                clean = true;
            }
        }
        if (clean) {
            this.taskCleaner_.start();
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj, ProprietaryTargetModuleID tgt) throws InvalidModuleException {
        this.deplConfiguration_ = new DeplConfiguration(dObj, this, tgt);
        return this.deplConfiguration_;
    }

    public Management getMEJB() {
        return this.mejb_;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        super.setLocale(locale);
        try {
            ((ProprietaryManagement)this.getMEJB()).setLocale(locale);
        }
        catch (RemoteException e) {
            UnsupportedOperationException ue = new UnsupportedOperationException();
            ue.initCause(e);
            throw ue;
        }
    }

    private ProgressObject internalDeploy(Target[] targetList, Object moduleArchive, Object deploymentPlan, ProgressListener listener) throws IllegalStateException {
        String appName = null;
        HashMap values = DeploymentUtils.parseDeploymentPlan(deploymentPlan, appName);
        if (logger_.isLoggable(Level.FINEST) && values != null) {
            logger_.finest("Deployment Plan:");
            logger_.finest(((Object)values).toString());
        }
        if (!DeplConfiguration.validateAppName(appName = (String)values.get("applicationID"))) {
            throw new IllegalStateException(FormattingResourceBundle.DeploymentMessages.getString("invalidArgumentValue", new String[]{appName}));
        }
        SharedModuleType moduleType = (SharedModuleType)values.get("moduleType");
        HashMap extraParams = (HashMap)values.get("extraParams");
        boolean isRedeploy = false;
        return this.commonDeploy(appName, extraParams, targetList, moduleArchive, listener, moduleType, isRedeploy);
    }

    private ProgressObject internalRedeploy(TargetModuleID[] moduleIDList, Object moduleArchive, Object deploymentPlan, ProgressListener listener, boolean keepSettings) throws UnsupportedOperationException, IllegalStateException {
        String appName = null;
        boolean isUndeploy = false;
        HashMap values = DeploymentUtils.parseTargets(moduleIDList, isUndeploy);
        if (logger_.isLoggable(Level.FINEST) && values != null) {
            logger_.finest("Deployment Plan Targets:");
            logger_.finest(((Object)values).toString());
        }
        Target[] targetList = (Target[])values.get("targetList");
        appName = (String)values.get("applicationID");
        values = DeploymentUtils.parseDeploymentPlan(deploymentPlan, appName);
        HashMap extraParams = (HashMap)values.get("extraParams");
        if (keepSettings) {
            extraParams.put("keepSettings", "true");
        }
        SharedModuleType moduleType = (SharedModuleType)values.get("moduleType");
        boolean isRedeploy = true;
        return this.commonDeploy(appName, extraParams, targetList, moduleArchive, listener, moduleType, isRedeploy);
    }

    private ProgressObject commonDeploy(String appName, Map extraParams, Target[] targetList, Object moduleArchive, ProgressListener listener, SharedModuleType moduleType, boolean isRedeploy) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Operation not supported in disconnected mode");
        }
        if (isRedeploy && !this.isRedeploySupported()) {
            throw new UnsupportedOperationException("Operation redeploy() is not supported");
        }
        ProgressListener listn = listener;
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            listn = new ConfigSetAddApplication((CoreRemoteMBeanServer)this.mejb_, listener, appName, extraParams);
        }
        ProgressObject progObj = InternalDeployer.deploy(this.mejb_, appName, extraParams, targetList, moduleArchive, listn, moduleType, isRedeploy);
        this.addTask(progObj);
        return progObj;
    }

    public ProgressObject updateEJBModule(String appName, String moduleName, String jarFilePath, ProgressListener listener) {
        Target[] targetList = this.getTargets();
        try {
            ObjectName serverTarget = ((ProprietaryTarget)targetList[0]).getObjectName();
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("J2EEServer", serverTarget.getKeyProperty("name"));
            ht.put("j2eeType", "J2EEApplication");
            ht.put("name", appName);
            ObjectName appMBean = new ObjectName(serverTarget.getDomain(), ht);
            Object[] params = new Object[]{moduleName, moduleName};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String"};
            return this.install(moduleName, targetList, new File(jarFilePath), appMBean, "updateEJBModule", params, sigs, listener);
        }
        catch (Throwable t) {
            throw new DeploymentRuntimeException(t);
        }
    }

    public Target getValidationTarget() throws IllegalStateException {
        Target[] tgts = this.getTargets();
        if (tgts == null) {
            throw new IllegalStateException("No Target available. DeploymentManager.getTargets() returns null");
        }
        if (tgts.length != 1) {
            throw new IllegalStateException("A single Target should be available in standalone. DeploymentManager.getTargets() returns " + tgts.length + " Targets.");
        }
        return tgts[0];
    }

    class TaskCleaner
    implements Runnable {
        public static final int cleaningThreshold = 100;
        private ConfigurableThread thread_ = null;

        public final synchronized void start() {
            if (this.thread_ == null) {
                this.thread_ = ThreadPool.getThread();
                this.thread_.start(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                Thread.currentThread().setName("DeploymentManager::TaskCleaner");
                List list = ConnectedDeploymentManagerBase.this.currentTasks_;
                synchronized (list) {
                    Iterator iter = ConnectedDeploymentManagerBase.this.currentTasks_.iterator();
                    while (iter.hasNext()) {
                        ProgressObject progObj = (ProgressObject)iter.next();
                        DeploymentStatus depStatus = progObj.getDeploymentStatus();
                        if (depStatus.isRunning()) continue;
                        iter.remove();
                    }
                }
            }
            finally {
                this.thread_ = null;
            }
        }
    }
}

