/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shared.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.ObjectName;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.api.J2EEDeploymentException;
import oracle.oc4j.admin.deploy.model.file.CarFile;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.EjbFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.file.RarFile;
import oracle.oc4j.admin.deploy.model.file.WarFile;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.DeplConfiguration;
import oracle.oc4j.admin.deploy.spi.DisconnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.SharedModuleTypeHelper;
import oracle.oc4j.admin.deploy.spi.factories.ClusterDeploymentFactory;
import oracle.oc4j.admin.deploy.spi.factories.IasDeploymentFactory;
import oracle.oc4j.admin.deploy.spi.factories.Oc4jDeploymentFactory;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanRootNode;
import oracle.oc4j.admin.deploy.spi.xml.WarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteType;
import oracle.oc4j.admin.jmx.shared.util.JarTool;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class DeploymentUtils {
    private static Logger logger_ = TraceLogger.getLogger((Class)DeploymentUtils.class);
    private static DeploymentFactoryManager _deplFactMgr = DeploymentFactoryManager.getInstance();

    public static HashMap parseDeploymentPlan(Object deploymentPlan, String applicationName) {
        if (deploymentPlan == null) {
            throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("deploymentPlan_can_not_be_null"));
        }
        if (deploymentPlan instanceof File) {
            return DeploymentUtils.parseDeploymentPlan((File)deploymentPlan, applicationName);
        }
        if (deploymentPlan instanceof InputStream) {
            return DeploymentUtils.parseDeploymentPlan((InputStream)deploymentPlan, applicationName);
        }
        throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("deploymentPlan_takes_File_InputStream_as_parameter", new String[]{deploymentPlan.getClass().getName()}));
    }

    public static HashMap parseTargets(TargetModuleID[] moduleIDList, boolean isUndeploy) {
        if (moduleIDList == null || moduleIDList.length == 0) {
            throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("parseTargets_parameter_can_not_be_null"));
        }
        String applicationName = null;
        SharedModuleType moduleType = null;
        Target[] targetList = new Target[moduleIDList.length];
        TargetModuleID tgMod = null;
        for (int i = 0; i < moduleIDList.length; ++i) {
            tgMod = moduleIDList[i].getParentTargetModuleID() != null && moduleIDList[i].getParentTargetModuleID().getChildTargetModuleID().length == 1 ? moduleIDList[i].getParentTargetModuleID() : moduleIDList[i];
            ObjectName tgModName = ((ProprietaryTargetModuleID)tgMod).getObjectName();
            String appName = tgModName.getKeyProperty("name");
            if (applicationName == null) {
                applicationName = appName;
                if (isUndeploy) {
                    moduleType = SharedModuleTypeHelper.getSharedModuleTypeFromJ2eeType(tgModName.getKeyProperty("j2eeType"));
                }
            } else if (!applicationName.equalsIgnoreCase(appName)) {
                throw new IllegalStateException(FormattingResourceBundle.DeploymentMessages.getString("support_redeployment_of_single_module"));
            }
            targetList[i] = tgMod.getTarget();
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("applicationID", applicationName);
        results.put("targetList", targetList);
        if (moduleType != null) {
            results.put("moduleType", moduleType);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap parseDeploymentPlan(File file, String applicationName) {
        HashMap hashMap;
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                hashMap = DeploymentUtils.parseDeploymentPlan(in, applicationName);
                Object var5_5 = null;
                if (in == null) return hashMap;
            }
            catch (IOException e) {
                if (!logger_.isLoggable(Level.SEVERE)) throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("parseDeploymentPlan_file_getAbsolutePath_error", new String[]{file.getAbsolutePath(), e.getMessage()}));
                logger_.log(Level.SEVERE, e.getMessage(), e);
                throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("parseDeploymentPlan_file_getAbsolutePath_error", new String[]{file.getAbsolutePath(), e.getMessage()}));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!logger_.isLoggable(Level.SEVERE)) throw throwable;
                logger_.log(Level.SEVERE, FormattingResourceBundle.DeploymentMessages.getString("parseDeploymnetPlan_getAbsulutePath_unable_to_close_error", new String[]{file.getAbsolutePath(), e2.getMessage()}), e2);
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            if (!logger_.isLoggable(Level.SEVERE)) return hashMap;
            logger_.log(Level.SEVERE, FormattingResourceBundle.DeploymentMessages.getString("parseDeploymnetPlan_getAbsulutePath_unable_to_close_error", new String[]{file.getAbsolutePath(), e2.getMessage()}), e2);
            return hashMap;
        }
        in.close();
        return hashMap;
    }

    private static HashMap parseDeploymentPlan(InputStream in, String applicationName) {
        String appName;
        Hashtable parsedConf;
        HashMap<String, String> extraParams;
        HashMap<String, Object> results;
        block10: {
            if (in.markSupported()) {
                in.mark(Integer.MAX_VALUE);
            }
            results = new HashMap<String, Object>();
            extraParams = new HashMap<String, String>();
            parsedConf = DeplConfiguration.parseConfiguration(in);
            if (in.markSupported()) {
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, ioe.getMessage(), ioe);
                }
            }
        }
        Hashtable attributes = (Hashtable)parsedConf.get("attributes");
        String string = appName = applicationName == null ? (String)attributes.get("applicationID") : applicationName;
        if (appName == null || appName.length() == 0) {
            throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("noApplicationId"));
        }
        String moduleTypeAsString = (String)attributes.get("moduleType");
        SharedModuleType moduleType = SharedModuleTypeHelper.getSharedModuleType(moduleTypeAsString);
        attributes.remove("moduleType");
        attributes.remove("applicationID");
        String key = null;
        String value = null;
        String tmp = null;
        Enumeration e = attributes.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = (String)attributes.get(key);
            if (key.equals(".")) {
                tmp = moduleType == SharedModuleType.EAR ? "<main>" : appName + moduleType.getModuleExtention();
                extraParams.put(tmp, value);
                continue;
            }
            if (key.equals(".:webservices")) {
                tmp = moduleType == SharedModuleType.EAR ? "<main>:webservices" : appName + moduleType.getModuleExtention() + ":webservices";
                extraParams.put(tmp, value);
                continue;
            }
            extraParams.put(key, value);
        }
        if (applicationName == null) {
            results.put("applicationID", appName);
        }
        if (moduleType != null) {
            results.put("moduleType", moduleType);
        }
        results.put("extraParams", extraParams);
        return results;
    }

    public static ByteArrayInputStream getDeploymentPlan(String deployName, Map extraParams, SharedModuleType moduleType) {
        String tmp = "applicationID=" + deployName + "\n";
        tmp = tmp + "moduleType=" + moduleType + "\n";
        if (extraParams != null) {
            Iterator it = extraParams.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)extraParams.get(key);
                tmp = tmp + key + "=" + value + "\n";
            }
        }
        return new ByteArrayInputStream(tmp.getBytes());
    }

    public static SharedModuleType getSharedModuleType(String fileName) {
        int idx = fileName.lastIndexOf(46);
        String suffix = fileName.substring(idx + 1);
        if ("ear".equals(suffix)) {
            return SharedModuleType.EAR;
        }
        if ("war".equals(suffix)) {
            return SharedModuleType.WAR;
        }
        if ("rar".equals(suffix)) {
            return SharedModuleType.RAR;
        }
        if ("jar".equals(suffix)) {
            return SharedModuleType.EJB;
        }
        throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("getSharedModuleType_not_determine_module_type", new String[]{fileName}));
    }

    public static DeploymentFactoryManager getDeploymentFactoryManager() {
        return _deplFactMgr;
    }

    public static String getValidURIMsg() {
        return FormattingResourceBundle.DeploymentMessages.getString("valid_uri") + "\n" + FormattingResourceBundle.DeploymentMessages.getString("target_all_in_cluster") + "\n" + "   deployer:cluster:[ormis:]opmn://opmnHost[:opmnPort]/oc4jGroupName\n\n" + FormattingResourceBundle.DeploymentMessages.getString("target_one_in_cluster") + "\n" + "   deployer:oc4j:[ormis:]opmn://opmnHost[:opmnPort]/oc4jInstanceName\n" + "   deployer:oc4j:[ormis:]opmn://opmnHost[:opmnPort]/asInstanceName/oc4jInstanceName\n\n" + FormattingResourceBundle.DeploymentMessages.getString("target_standalone") + "\n" + "   deployer:oc4j:oc4jHost:rmiPort\n" + "   deployer:oc4j:ormis:oc4jHost:ormisPort\n\n" + FormattingResourceBundle.DeploymentMessages.getString("opmnPort_in_opmnxml");
    }

    public static Throwable getMostInnerCause(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static boolean isLocalHost(String hostName) {
        if (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1")) {
            return true;
        }
        try {
            return InetAddress.getByName(hostName).equals(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static J2eeFile getJ2eeArchiveFile(File archiveFile) throws Throwable {
        J2eeFile j2eeFile = null;
        try {
            String fileName = archiveFile.getName();
            String fileExtension = fileName.substring(fileName.lastIndexOf(46));
            j2eeFile = fileExtension.equalsIgnoreCase(".jar") ? (DeploymentUtils.isClientArchive(archiveFile) ? new CarFile(archiveFile) : new EjbFile(archiveFile)) : (fileExtension.equalsIgnoreCase(".war") ? new WarFile(archiveFile) : (fileExtension.equalsIgnoreCase(".rar") ? new RarFile(archiveFile) : new EarFile(archiveFile)));
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.severe("Error creating J2eeFile: " + archiveFile);
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw t;
        }
        return j2eeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClientArchive(File archiveFile) throws IOException {
        JarTool jt = null;
        try {
            jt = new JarTool(archiveFile);
            if (jt.hasEntry("META-INF/application-client.xml")) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (jt != null) {
                jt.close();
            }
        }
        return false;
    }

    public static ByteArrayInputStream getDeploymentPlan(DeploymentManager deplMgr, File deployFile, TargetModuleID[] tmids, Map extraParams, String deployName) throws J2EEDeploymentException {
        try {
            J2eeFile j2eeArchiveFile = DeploymentUtils.getJ2eeArchiveFile(deployFile);
            DeploymentConfiguration deplConfig = null;
            String bindWebAppValue = (String)extraParams.get("bindWebApp");
            String contextRoot = (String)extraParams.get("contextRoot");
            String failureRecovery = (String)extraParams.get("failureRecovery");
            String removeArchive = (String)extraParams.get("removeArchive");
            ProprietaryTargetModuleID targetModuleID = null;
            for (int i = 0; i < tmids.length; ++i) {
                ProprietaryTargetModuleID pid = (ProprietaryTargetModuleID)tmids[i];
                if (!pid.getObjectName().getKeyProperty("name").equals(deployName)) continue;
                targetModuleID = pid;
                break;
            }
            if (targetModuleID == null) {
                throw new J2EEDeploymentException("application " + deployName + " does not exist!");
            }
            ConnectedDeploymentManagerBase cdmb = (ConnectedDeploymentManagerBase)deplMgr;
            deplConfig = cdmb.createConfiguration(j2eeArchiveFile, targetModuleID);
            if (bindWebAppValue != null) {
                DeploymentUtils.setBindWebApp(deplConfig, j2eeArchiveFile, bindWebAppValue);
            } else {
                DeploymentUtils.setBindWebApp(deplConfig, j2eeArchiveFile, "");
            }
            if (contextRoot != null) {
                DeploymentUtils.setContextRoot(deplConfig, j2eeArchiveFile, contextRoot);
            }
            if (removeArchive != null) {
                DeploymentUtils.setRemoveArchive(deplConfig, j2eeArchiveFile);
            }
            if (failureRecovery != null) {
                DeploymentUtils.setFailureRecovery(deplConfig, j2eeArchiveFile);
            }
            ByteArrayOutputStream configOutputStream = new ByteArrayOutputStream();
            deplConfig.save((OutputStream)configOutputStream);
            configOutputStream.close();
            return new ByteArrayInputStream(configOutputStream.toByteArray());
        }
        catch (Throwable t) {
            throw new J2EEDeploymentException(t.getMessage(), t);
        }
    }

    private static void setBindWebApp(DeploymentConfiguration deplConfig, DeployableObject j2eeArchiveFile, String webSiteName) throws ConfigurationException {
        ConfigBeanRootNode rootNode = (ConfigBeanRootNode)deplConfig.getDConfigBeanRoot(j2eeArchiveFile.getDDBeanRoot());
        WebSiteType webSiteType = new WebSiteType(rootNode);
        webSiteType.setValue(webSiteName);
        rootNode.setWebSiteBinding(webSiteType);
    }

    private static void setContextRoot(DeploymentConfiguration deplConfig, DeployableObject j2eeArchiveFile, String contextRoot) throws ConfigurationException {
        ConfigBeanRootNode rootNode = (ConfigBeanRootNode)deplConfig.getDConfigBeanRoot(j2eeArchiveFile.getDDBeanRoot());
        if (rootNode instanceof WarDepXml) {
            WarDepXml depXml = (WarDepXml)rootNode;
            depXml.setContextRoot(contextRoot);
        }
    }

    private static void setRemoveArchive(DeploymentConfiguration deplConfig, DeployableObject j2eeArchiveFile) throws ConfigurationException {
        ConfigBeanRootNode rootNode = (ConfigBeanRootNode)deplConfig.getDConfigBeanRoot(j2eeArchiveFile.getDDBeanRoot());
        BooleanType booleanType = rootNode.defaultRemoveArchive();
        booleanType.setValue("true");
        rootNode.setRemoveArchive(booleanType);
    }

    private static void setFailureRecovery(DeploymentConfiguration deplConfig, DeployableObject j2eeArchiveFile) throws ConfigurationException {
        ConfigBeanRootNode rootNode = (ConfigBeanRootNode)deplConfig.getDConfigBeanRoot(j2eeArchiveFile.getDDBeanRoot());
        BooleanType booleanType = rootNode.defaultFailureRecovery();
        booleanType.setValue("true");
        rootNode.setFailureRecovery(booleanType);
    }

    public static boolean isWar(String fileName) {
        SharedModuleType modType = null;
        try {
            File deployFile = new File(fileName);
            modType = deployFile.isDirectory() ? SharedModuleType.EAR : DeploymentUtils.getSharedModuleType(fileName);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return modType != null && modType.equals(SharedModuleType.WAR);
    }

    public static void setDefaultContextRoot(String appName, Map extraParams) {
        String contextRoot = (String)extraParams.get("contextRoot");
        if (contextRoot == null) {
            contextRoot = "/" + appName;
            System.out.println(FormattingResourceBundle.DeploymentMessages.getString("contextroot_not_specified", new String[]{contextRoot}));
        }
        extraParams.put("contextRoot", contextRoot);
    }

    public static InputStream findContextRootInDeploymentPlan(String fileName, Map extraParams, String deploymentPlan) {
        InputStream planStream = null;
        String contextRoot = (String)extraParams.get("contextRoot");
        File deployFile = new File(fileName);
        if (deploymentPlan != null) {
            try {
                DisconnectedDeploymentManager mgr = new DisconnectedDeploymentManager();
                J2eeFile j2eeArchiveFile = DeploymentUtils.getJ2eeArchiveFile(deployFile);
                DeploymentConfiguration deplConfig = mgr.createConfiguration(j2eeArchiveFile);
                planStream = new FileInputStream(deploymentPlan);
                deplConfig.restore(planStream);
                WarDepXml rootNode = (WarDepXml)deplConfig.getDConfigBeanRoot(j2eeArchiveFile.getDDBeanRoot());
                if (contextRoot == null) {
                    contextRoot = rootNode.getContextRoot();
                }
                if (contextRoot != null) {
                    rootNode.setContextRoot(contextRoot);
                    String bindWebApp = (String)extraParams.get("bindWebApp");
                    if (bindWebApp != null) {
                        WebSiteType webSiteType = new WebSiteType(rootNode);
                        webSiteType.setValue(bindWebApp);
                        rootNode.setWebSiteBinding(webSiteType);
                    }
                    ByteArrayOutputStream depPlan = new ByteArrayOutputStream();
                    deplConfig.save((OutputStream)depPlan);
                    planStream = new ByteArrayInputStream(depPlan.toByteArray());
                    extraParams.put("contextRoot", contextRoot);
                }
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
            }
        }
        return planStream;
    }

    public static void findContextRootInArchive(String fileName, Map extraParams) {
        String contextRoot = (String)extraParams.get("contextRoot");
        File deployFile = new File(fileName);
        try {
            DisconnectedDeploymentManager mgr = new DisconnectedDeploymentManager();
            J2eeFile j2eeArchiveFile = DeploymentUtils.getJ2eeArchiveFile(deployFile);
            DeploymentConfiguration deplConfig = mgr.createConfiguration(j2eeArchiveFile);
            WarDepXml rootNode = (WarDepXml)deplConfig.getDConfigBeanRoot(j2eeArchiveFile.getDDBeanRoot());
            if (contextRoot == null) {
                contextRoot = rootNode.getContextRoot();
            }
            if (contextRoot != null) {
                rootNode.setContextRoot(contextRoot);
                String bindWebApp = (String)extraParams.get("bindWebApp");
                if (bindWebApp != null) {
                    WebSiteType webSiteType = new WebSiteType(rootNode);
                    webSiteType.setValue(bindWebApp);
                    rootNode.setWebSiteBinding(webSiteType);
                }
                extraParams.put("contextRoot", contextRoot);
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
        }
    }

    static {
        _deplFactMgr.registerDeploymentFactory((DeploymentFactory)new Oc4jDeploymentFactory());
        _deplFactMgr.registerDeploymentFactory((DeploymentFactory)new IasDeploymentFactory());
        _deplFactMgr.registerDeploymentFactory((DeploymentFactory)new ClusterDeploymentFactory());
    }
}

